/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.spring.util;

import java.util.ArrayList;
import java.util.List;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.ProcessorDefinition;
import org.apache.camel.model.RouteDefinition;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleRouteBuilder
extends RouteBuilder {
    private List<String> fromUris = new ArrayList<String>();
    private List<String> toUris = new ArrayList<String>();
    private Class beanType;
    private String beanClass;
    private String beanRef;
    private String beanMethod;

    public void configure() throws Exception {
        if (this.fromUris.isEmpty()) {
            throw new IllegalArgumentException("the fromUris property must contain at least one valid URI");
        }
        for (String fromUri : this.fromUris) {
            RouteDefinition route = this.from(fromUri);
            route = this.addBeanCall((ProcessorDefinition)route);
            for (String toUri : this.toUris) {
                route = route.to(toUri);
            }
        }
    }

    public void setFromUri(String uri) {
        this.setFromUris(this.singletonList(uri));
    }

    public void setToUri(String uri) {
        this.setToUris(this.singletonList(uri));
    }

    public List<String> getFromUris() {
        return this.fromUris;
    }

    public void setFromUris(List<String> fromUris) {
        this.fromUris = fromUris;
    }

    public List<String> getToUris() {
        return this.toUris;
    }

    public void setToUris(List<String> toUris) {
        this.toUris = toUris;
    }

    public String getBeanClass() {
        return this.beanClass;
    }

    public void setBeanClass(String beanClass) {
        this.beanClass = beanClass;
    }

    public String getBeanRef() {
        return this.beanRef;
    }

    public void setBeanRef(String beanRef) {
        this.beanRef = beanRef;
    }

    public Class getBeanType() {
        if (this.beanType == null && this.beanClass != null) {
            this.beanType = this.getContext().getClassResolver().resolveClass(this.beanClass, ((Object)((Object)this)).getClass().getClassLoader());
        }
        return this.beanType;
    }

    public void setBeanType(Class beanType) {
        this.beanType = beanType;
    }

    public String getBeanMethod() {
        return this.beanMethod;
    }

    public void setBeanMethod(String beanMethod) {
        this.beanMethod = beanMethod;
    }

    protected ProcessorDefinition addBeanCall(ProcessorDefinition route) {
        Class type = this.getBeanType();
        if (type != null) {
            route = this.beanMethod != null ? route.bean(type, this.beanMethod) : route.bean(type);
        } else if (this.beanRef != null) {
            route = this.beanMethod != null ? route.beanRef(this.beanRef, this.beanMethod) : route.beanRef(this.beanRef);
        }
        return route;
    }

    protected List<String> singletonList(String value) {
        ArrayList<String> uris = new ArrayList<String>();
        uris.add(value);
        return uris;
    }
}

