/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.spring.spi;

import java.util.Map;
import java.util.Properties;
import org.apache.camel.CamelContext;
import org.apache.camel.component.properties.AugmentedPropertyNameAwarePropertiesParser;
import org.apache.camel.component.properties.PropertiesParser;
import org.apache.camel.component.properties.PropertiesResolver;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.config.PropertyPlaceholderConfigurer;
import org.springframework.core.Constants;
import org.springframework.util.PropertyPlaceholderHelper;

public class BridgePropertyPlaceholderConfigurer
extends PropertyPlaceholderConfigurer
implements PropertiesResolver,
AugmentedPropertyNameAwarePropertiesParser {
    private final Properties properties = new Properties();
    private PropertiesResolver resolver;
    private PropertiesParser parser;
    private String id;
    private PropertyPlaceholderHelper helper;
    private String configuredPlaceholderPrefix;
    private String configuredPlaceholderSuffix;
    private String configuredValueSeparator;
    private Boolean configuredIgnoreUnresolvablePlaceholders;
    private int systemPropertiesMode = 1;
    private Boolean ignoreResourceNotFound;

    protected void processProperties(ConfigurableListableBeanFactory beanFactoryToProcess, Properties props) throws BeansException {
        super.processProperties(beanFactoryToProcess, props);
        this.properties.putAll((Map<?, ?>)props);
        this.helper = new PropertyPlaceholderHelper(this.configuredPlaceholderPrefix != null ? this.configuredPlaceholderPrefix : "${", this.configuredPlaceholderSuffix != null ? this.configuredPlaceholderSuffix : "}", this.configuredValueSeparator != null ? this.configuredValueSeparator : ":", this.configuredIgnoreUnresolvablePlaceholders != null ? this.configuredIgnoreUnresolvablePlaceholders : false);
    }

    public void setBeanName(String beanName) {
        this.id = beanName;
        super.setBeanName(beanName);
    }

    public void setSystemPropertiesModeName(String constantName) throws IllegalArgumentException {
        super.setSystemPropertiesModeName(constantName);
        Constants constants = new Constants(PropertyPlaceholderConfigurer.class);
        this.systemPropertiesMode = constants.asNumber(constantName).intValue();
    }

    public void setSystemPropertiesMode(int systemPropertiesMode) {
        super.setSystemPropertiesMode(systemPropertiesMode);
        this.systemPropertiesMode = systemPropertiesMode;
    }

    public void setPlaceholderPrefix(String placeholderPrefix) {
        super.setPlaceholderPrefix(placeholderPrefix);
        this.configuredPlaceholderPrefix = placeholderPrefix;
    }

    public void setPlaceholderSuffix(String placeholderSuffix) {
        super.setPlaceholderSuffix(placeholderSuffix);
        this.configuredPlaceholderSuffix = placeholderSuffix;
    }

    public void setValueSeparator(String valueSeparator) {
        super.setValueSeparator(valueSeparator);
        this.configuredValueSeparator = valueSeparator;
    }

    public void setIgnoreUnresolvablePlaceholders(boolean ignoreUnresolvablePlaceholders) {
        super.setIgnoreUnresolvablePlaceholders(ignoreUnresolvablePlaceholders);
        this.configuredIgnoreUnresolvablePlaceholders = ignoreUnresolvablePlaceholders;
    }

    public void setIgnoreResourceNotFound(boolean ignoreResourceNotFound) {
        super.setIgnoreResourceNotFound(ignoreResourceNotFound);
        this.ignoreResourceNotFound = ignoreResourceNotFound;
    }

    public Properties resolveProperties(CamelContext context, boolean ignoreMissingLocation, String ... uri) throws Exception {
        Properties answer = new Properties();
        for (String u : uri) {
            Properties p;
            String ref = "ref:" + this.id;
            if (ref.equals(u)) {
                answer.putAll((Map<?, ?>)this.properties);
                continue;
            }
            if (this.resolver == null) continue;
            boolean flag = ignoreMissingLocation;
            if (this.ignoreResourceNotFound != null) {
                flag = this.ignoreResourceNotFound;
            }
            if ((p = this.resolver.resolveProperties(context, flag, new String[]{u})) == null) continue;
            answer.putAll((Map<?, ?>)p);
        }
        return answer;
    }

    public String parseUri(String text, Properties properties, String prefixToken, String suffixToken, String propertyPrefix, String propertySuffix, boolean fallbackToUnaugmentedProperty) throws IllegalArgumentException {
        String answer = this.parser instanceof AugmentedPropertyNameAwarePropertiesParser ? ((AugmentedPropertyNameAwarePropertiesParser)this.parser).parseUri(text, properties, prefixToken, suffixToken, propertyPrefix, propertySuffix, fallbackToUnaugmentedProperty) : this.parser.parseUri(text, properties, prefixToken, suffixToken);
        answer = answer != null ? this.springResolvePlaceholders(answer, properties) : this.springResolvePlaceholders(text, properties);
        return answer;
    }

    public String parseUri(String text, Properties properties, String prefixToken, String suffixToken) throws IllegalArgumentException {
        String answer = this.parser.parseUri(text, properties, prefixToken, suffixToken);
        answer = answer != null ? this.springResolvePlaceholders(answer, properties) : this.springResolvePlaceholders(text, properties);
        return answer;
    }

    public String parseProperty(String key, String value, Properties properties) {
        String answer = this.parser.parseProperty(key, value, properties);
        answer = answer != null ? this.springResolvePlaceholders(answer, properties) : this.springResolvePlaceholders(value, properties);
        return answer;
    }

    protected String springResolvePlaceholders(String text, Properties properties) {
        return this.helper.replacePlaceholders(text, (PropertyPlaceholderHelper.PlaceholderResolver)new BridgePropertyPlaceholderResolver(properties));
    }

    public void setResolver(PropertiesResolver resolver) {
        this.resolver = resolver;
    }

    public void setParser(PropertiesParser parser) {
        this.parser = parser;
    }

    private class BridgePropertyPlaceholderResolver
    implements PropertyPlaceholderHelper.PlaceholderResolver {
        private final Properties properties;

        public BridgePropertyPlaceholderResolver(Properties properties) {
            this.properties = properties;
        }

        public String resolvePlaceholder(String placeholderName) {
            String propVal = null;
            if (BridgePropertyPlaceholderConfigurer.this.systemPropertiesMode == 2) {
                propVal = BridgePropertyPlaceholderConfigurer.this.resolveSystemProperty(placeholderName);
            }
            if (propVal == null) {
                propVal = (String)this.properties.get(placeholderName);
            }
            if (propVal == null && BridgePropertyPlaceholderConfigurer.this.systemPropertiesMode == 1) {
                propVal = BridgePropertyPlaceholderConfigurer.this.resolveSystemProperty(placeholderName);
            }
            return propVal;
        }
    }
}

