/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.spring.remoting;

import org.apache.camel.CamelContext;
import org.apache.camel.CamelContextAware;
import org.apache.camel.Endpoint;
import org.apache.camel.FailedToCreateProducerException;
import org.apache.camel.Producer;
import org.apache.camel.component.bean.ProxyHelper;
import org.apache.camel.spring.util.CamelContextResolverHelper;
import org.apache.camel.util.ServiceHelper;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.remoting.support.UrlBasedRemoteAccessor;

public class CamelProxyFactoryBean
extends UrlBasedRemoteAccessor
implements FactoryBean,
CamelContextAware,
DisposableBean,
ApplicationContextAware {
    private String serviceRef;
    private CamelContext camelContext;
    private String camelContextId;
    private ApplicationContext applicationContext;
    private Endpoint endpoint;
    private Object serviceProxy;
    private Producer producer;

    public void afterPropertiesSet() {
        if (this.endpoint == null) {
            if (this.camelContext == null && this.camelContextId != null) {
                this.camelContext = CamelContextResolverHelper.getCamelContextWithId(this.applicationContext, this.camelContextId);
            }
            if (this.camelContext == null) {
                throw new IllegalArgumentException("camelContext or camelContextId must be specified");
            }
            if (this.getServiceUrl() == null && this.getServiceRef() == null) {
                throw new IllegalArgumentException("serviceUrl or serviceRef must be specified.");
            }
            this.endpoint = this.getServiceRef() != null ? (Endpoint)this.camelContext.getRegistry().lookup(this.getServiceRef(), Endpoint.class) : this.camelContext.getEndpoint(this.getServiceUrl());
            if (this.endpoint == null) {
                throw new IllegalArgumentException("Could not resolve endpoint: " + this.getServiceUrl());
            }
        }
        try {
            this.producer = this.endpoint.createProducer();
            ServiceHelper.startService((Object)this.producer);
            this.serviceProxy = ProxyHelper.createProxy((Endpoint)this.endpoint, (Producer)this.producer, (Class[])new Class[]{this.getServiceInterface()});
        }
        catch (Exception e) {
            throw new FailedToCreateProducerException(this.endpoint, (Throwable)e);
        }
    }

    public void destroy() throws Exception {
        ServiceHelper.stopService((Object)this.producer);
    }

    public Class getServiceInterface() {
        return super.getServiceInterface();
    }

    public String getServiceUrl() {
        return super.getServiceUrl();
    }

    public Object getObject() throws Exception {
        return this.serviceProxy;
    }

    public Class getObjectType() {
        return this.getServiceInterface();
    }

    public boolean isSingleton() {
        return true;
    }

    public String getServiceRef() {
        return this.serviceRef;
    }

    public void setServiceRef(String serviceRef) {
        this.serviceRef = serviceRef;
    }

    public Endpoint getEndpoint() {
        return this.endpoint;
    }

    public void setEndpoint(Endpoint endpoint) {
        this.endpoint = endpoint;
    }

    public CamelContext getCamelContext() {
        return this.camelContext;
    }

    public void setCamelContext(CamelContext camelContext) {
        this.camelContext = camelContext;
    }

    public void setCamelContextId(String contextId) {
        this.camelContextId = contextId;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }
}

