/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.osgi;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import org.apache.camel.core.osgi.OsgiCamelContextPublisher;
import org.apache.camel.core.osgi.OsgiEventAdminNotifier;
import org.apache.camel.osgi.OsgiSpringCamelContext;
import org.apache.camel.spi.EventNotifier;
import org.apache.camel.spring.SpringCamelContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.framework.BundleContext;
import org.springframework.osgi.context.BundleContextAware;

@XmlRootElement(name="camelContext")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class CamelContextFactoryBean
extends org.apache.camel.spring.CamelContextFactoryBean
implements BundleContextAware {
    private static final transient Log LOG = LogFactory.getLog(CamelContextFactoryBean.class);
    @XmlTransient
    private BundleContext bundleContext;

    public BundleContext getBundleContext() {
        return this.bundleContext;
    }

    public void setBundleContext(BundleContext bundleContext) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Using BundleContext: " + bundleContext));
        }
        this.bundleContext = bundleContext;
    }

    protected SpringCamelContext createContext() {
        SpringCamelContext ctx = this.newCamelContext();
        if (!this.isImplicitId()) {
            ctx.setName(this.getId());
        }
        return ctx;
    }

    protected SpringCamelContext newCamelContext() {
        return new OsgiSpringCamelContext(this.getApplicationContext(), this.getBundleContext());
    }

    public void afterPropertiesSet() throws Exception {
        super.afterPropertiesSet();
        ((SpringCamelContext)((Object)this.getContext())).getManagementStrategy().addEventNotifier((EventNotifier)new OsgiCamelContextPublisher(this.bundleContext));
        try {
            ((Object)((Object)this)).getClass().getClassLoader().loadClass("org.osgi.service.event.EventAdmin");
            ((SpringCamelContext)((Object)this.getContext())).getManagementStrategy().addEventNotifier((EventNotifier)new OsgiEventAdminNotifier(this.bundleContext));
        }
        catch (Throwable t) {
            LOG.debug((Object)"EventAdmin package is not available, just don't use it");
        }
    }
}

