/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.spring;

import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElements;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import org.apache.camel.CamelContext;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.ShutdownRoute;
import org.apache.camel.ShutdownRunningTask;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.core.xml.AbstractCamelContextFactoryBean;
import org.apache.camel.core.xml.CamelJMXAgentDefinition;
import org.apache.camel.core.xml.CamelPropertyPlaceholderDefinition;
import org.apache.camel.core.xml.CamelProxyFactoryDefinition;
import org.apache.camel.core.xml.CamelServiceExporterDefinition;
import org.apache.camel.model.ContextScanDefinition;
import org.apache.camel.model.InterceptDefinition;
import org.apache.camel.model.InterceptFromDefinition;
import org.apache.camel.model.InterceptSendToEndpointDefinition;
import org.apache.camel.model.OnCompletionDefinition;
import org.apache.camel.model.OnExceptionDefinition;
import org.apache.camel.model.PackageScanDefinition;
import org.apache.camel.model.RouteBuilderDefinition;
import org.apache.camel.model.RouteContextRefDefinition;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.model.ThreadPoolProfileDefinition;
import org.apache.camel.model.config.PropertiesDefinition;
import org.apache.camel.model.dataformat.DataFormatsDefinition;
import org.apache.camel.spi.PackageScanFilter;
import org.apache.camel.spi.Registry;
import org.apache.camel.spring.CamelBeanPostProcessor;
import org.apache.camel.spring.CamelConsumerTemplateFactoryBean;
import org.apache.camel.spring.CamelEndpointFactoryBean;
import org.apache.camel.spring.CamelProducerTemplateFactoryBean;
import org.apache.camel.spring.CamelRedeliveryPolicyFactoryBean;
import org.apache.camel.spring.CamelThreadPoolFactoryBean;
import org.apache.camel.spring.ContextScanRouteBuilderFinder;
import org.apache.camel.spring.ErrorHandlerDefinition;
import org.apache.camel.spring.PackageScanRouteBuilderFinder;
import org.apache.camel.spring.SpringCamelContext;
import org.apache.camel.util.ObjectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.context.event.ContextRefreshedEvent;

@XmlRootElement(name="camelContext")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class CamelContextFactoryBean
extends AbstractCamelContextFactoryBean<SpringCamelContext>
implements FactoryBean,
InitializingBean,
DisposableBean,
ApplicationContextAware,
ApplicationListener {
    private static final Logger LOG = LoggerFactory.getLogger(CamelContextFactoryBean.class);
    @XmlAttribute(name="depends-on", required=false)
    private String dependsOn;
    @XmlAttribute(required=false)
    private String trace;
    @XmlAttribute(required=false)
    private String streamCache;
    @XmlAttribute(required=false)
    private String delayer;
    @XmlAttribute(required=false)
    private String handleFault;
    @XmlAttribute(required=false)
    private String errorHandlerRef;
    @XmlAttribute(required=false)
    private String autoStartup;
    @XmlAttribute(required=false)
    private String useMDCLogging;
    @XmlAttribute(required=false)
    private ShutdownRoute shutdownRoute;
    @XmlAttribute(required=false)
    private ShutdownRunningTask shutdownRunningTask;
    @XmlAttribute(required=false)
    private Boolean lazyLoadTypeConverters;
    @XmlElement(name="properties", required=false)
    private PropertiesDefinition properties;
    @XmlElement(name="propertyPlaceholder", type=CamelPropertyPlaceholderDefinition.class, required=false)
    private CamelPropertyPlaceholderDefinition camelPropertyPlaceholder;
    @XmlElement(name="package", required=false)
    private String[] packages = new String[0];
    @XmlElement(name="packageScan", type=PackageScanDefinition.class, required=false)
    private PackageScanDefinition packageScan;
    @XmlElement(name="contextScan", type=ContextScanDefinition.class, required=false)
    private ContextScanDefinition contextScan;
    @XmlElement(name="jmxAgent", type=CamelJMXAgentDefinition.class, required=false)
    private CamelJMXAgentDefinition camelJMXAgent;
    @XmlElements(value={@XmlElement(name="template", type=CamelProducerTemplateFactoryBean.class, required=false), @XmlElement(name="consumerTemplate", type=CamelConsumerTemplateFactoryBean.class, required=false), @XmlElement(name="proxy", type=CamelProxyFactoryDefinition.class, required=false), @XmlElement(name="export", type=CamelServiceExporterDefinition.class, required=false), @XmlElement(name="errorHandler", type=ErrorHandlerDefinition.class, required=false)})
    private List beans;
    @XmlElement(name="routeBuilder", required=false)
    private List<RouteBuilderDefinition> builderRefs = new ArrayList<RouteBuilderDefinition>();
    @XmlElement(name="routeContextRef", required=false)
    private List<RouteContextRefDefinition> routeRefs = new ArrayList<RouteContextRefDefinition>();
    @XmlElement(name="threadPoolProfile", required=false)
    private List<ThreadPoolProfileDefinition> threadPoolProfiles;
    @XmlElement(name="threadPool", required=false)
    private List<CamelThreadPoolFactoryBean> threadPools;
    @XmlElement(name="endpoint", required=false)
    private List<CamelEndpointFactoryBean> endpoints;
    @XmlElement(name="dataFormats", required=false)
    private DataFormatsDefinition dataFormats;
    @XmlElement(name="redeliveryPolicyProfile", required=false)
    private List<CamelRedeliveryPolicyFactoryBean> redeliveryPolicies;
    @XmlElement(name="onException", required=false)
    private List<OnExceptionDefinition> onExceptions = new ArrayList<OnExceptionDefinition>();
    @XmlElement(name="onCompletion", required=false)
    private List<OnCompletionDefinition> onCompletions = new ArrayList<OnCompletionDefinition>();
    @XmlElement(name="intercept", required=false)
    private List<InterceptDefinition> intercepts = new ArrayList<InterceptDefinition>();
    @XmlElement(name="interceptFrom", required=false)
    private List<InterceptFromDefinition> interceptFroms = new ArrayList<InterceptFromDefinition>();
    @XmlElement(name="interceptSendToEndpoint", required=false)
    private List<InterceptSendToEndpointDefinition> interceptSendToEndpoints = new ArrayList<InterceptSendToEndpointDefinition>();
    @XmlElement(name="route", required=false)
    private List<RouteDefinition> routes = new ArrayList<RouteDefinition>();
    @XmlTransient
    private SpringCamelContext context;
    @XmlTransient
    private ClassLoader contextClassLoaderOnStart;
    @XmlTransient
    private ApplicationContext applicationContext;
    @XmlTransient
    private BeanPostProcessor beanPostProcessor;
    @XmlTransient
    private boolean implicitId;

    @Override
    public Class getObjectType() {
        return SpringCamelContext.class;
    }

    @Override
    protected <S> S getBeanForType(Class<S> clazz) {
        ApplicationContext parentContext;
        Object bean = null;
        String[] names = this.getApplicationContext().getBeanNamesForType(clazz, true, true);
        if (names.length == 1) {
            bean = this.getApplicationContext().getBean(names[0], clazz);
        }
        if (bean == null && (parentContext = this.getApplicationContext().getParent()) != null && (names = parentContext.getBeanNamesForType(clazz, true, true)).length == 1) {
            bean = parentContext.getBean(names[0], clazz);
        }
        return (S)bean;
    }

    @Override
    protected void findRouteBuildersByPackageScan(String[] packages, PackageScanFilter filter, List<RoutesBuilder> builders) throws Exception {
        ((SpringCamelContext)((Object)this.getContext())).getPackageScanClassResolver().addFilter(filter);
        PackageScanRouteBuilderFinder finder = new PackageScanRouteBuilderFinder((SpringCamelContext)((Object)this.getContext()), packages, this.getContextClassLoaderOnStart(), this.getBeanPostProcessor(), ((SpringCamelContext)((Object)this.getContext())).getPackageScanClassResolver());
        finder.appendBuilders(builders);
        ((SpringCamelContext)((Object)this.getContext())).getPackageScanClassResolver().removeFilter(filter);
    }

    @Override
    protected void findRouteBuildersByContextScan(PackageScanFilter filter, List<RoutesBuilder> builders) throws Exception {
        ContextScanRouteBuilderFinder finder = new ContextScanRouteBuilderFinder((SpringCamelContext)((Object)this.getContext()), filter);
        finder.appendBuilders(builders);
    }

    @Override
    protected void initBeanPostProcessor(SpringCamelContext context) {
        if (this.beanPostProcessor != null) {
            if (this.beanPostProcessor instanceof ApplicationContextAware) {
                ((ApplicationContextAware)this.beanPostProcessor).setApplicationContext(this.applicationContext);
            }
            if (this.beanPostProcessor instanceof CamelBeanPostProcessor) {
                ((CamelBeanPostProcessor)this.beanPostProcessor).setCamelContext((CamelContext)this.getContext());
            }
        }
    }

    @Override
    protected void postProcessBeforeInit(RouteBuilder builder) {
        if (this.beanPostProcessor != null) {
            this.beanPostProcessor.postProcessBeforeInitialization((Object)builder, builder.toString());
        }
    }

    @Override
    protected void initCustomRegistry(SpringCamelContext context) {
        Registry registry = this.getBeanForType(Registry.class);
        if (registry != null) {
            LOG.info("Using custom Registry: " + registry);
            context.setRegistry(registry);
        }
    }

    public void onApplicationEvent(ApplicationEvent event) {
        SpringCamelContext context = this.getContext(false);
        if (context != null) {
            context.onApplicationEvent(event);
        } else {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Publishing spring-event: " + event);
            }
            if (event instanceof ContextRefreshedEvent) {
                try {
                    LOG.debug("Starting the context now!");
                    ((SpringCamelContext)((Object)this.getContext())).start();
                }
                catch (Exception e) {
                    throw ObjectHelper.wrapRuntimeCamelException((Throwable)e);
                }
            }
        }
    }

    public ApplicationContext getApplicationContext() {
        if (this.applicationContext == null) {
            throw new IllegalArgumentException("No applicationContext has been injected!");
        }
        return this.applicationContext;
    }

    public void setApplicationContext(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }

    public void setBeanPostProcessor(BeanPostProcessor postProcessor) {
        this.beanPostProcessor = postProcessor;
    }

    public BeanPostProcessor getBeanPostProcessor() {
        return this.beanPostProcessor;
    }

    protected SpringCamelContext createContext() {
        SpringCamelContext ctx = this.newCamelContext();
        ctx.setName(this.getId());
        return ctx;
    }

    protected SpringCamelContext newCamelContext() {
        return new SpringCamelContext(this.getApplicationContext());
    }

    @Override
    public SpringCamelContext getContext(boolean create) {
        if (this.context == null && create) {
            this.context = this.createContext();
        }
        return this.context;
    }

    public void setContext(SpringCamelContext context) {
        this.context = context;
    }

    @Override
    public List<RouteDefinition> getRoutes() {
        return this.routes;
    }

    public void setRoutes(List<RouteDefinition> routes) {
        this.routes = routes;
    }

    @Override
    public List<CamelEndpointFactoryBean> getEndpoints() {
        return this.endpoints;
    }

    @Override
    public List<CamelRedeliveryPolicyFactoryBean> getRedeliveryPolicies() {
        return this.redeliveryPolicies;
    }

    @Override
    public List<InterceptDefinition> getIntercepts() {
        return this.intercepts;
    }

    public void setIntercepts(List<InterceptDefinition> intercepts) {
        this.intercepts = intercepts;
    }

    @Override
    public List<InterceptFromDefinition> getInterceptFroms() {
        return this.interceptFroms;
    }

    public void setInterceptFroms(List<InterceptFromDefinition> interceptFroms) {
        this.interceptFroms = interceptFroms;
    }

    @Override
    public List<InterceptSendToEndpointDefinition> getInterceptSendToEndpoints() {
        return this.interceptSendToEndpoints;
    }

    public void setInterceptSendToEndpoints(List<InterceptSendToEndpointDefinition> interceptSendToEndpoints) {
        this.interceptSendToEndpoints = interceptSendToEndpoints;
    }

    @Override
    public PropertiesDefinition getProperties() {
        return this.properties;
    }

    public void setProperties(PropertiesDefinition properties) {
        this.properties = properties;
    }

    @Override
    public String[] getPackages() {
        return this.packages;
    }

    public void setPackages(String[] packages) {
        this.packages = packages;
    }

    @Override
    public PackageScanDefinition getPackageScan() {
        return this.packageScan;
    }

    @Override
    public void setPackageScan(PackageScanDefinition packageScan) {
        this.packageScan = packageScan;
    }

    @Override
    public ContextScanDefinition getContextScan() {
        return this.contextScan;
    }

    @Override
    public void setContextScan(ContextScanDefinition contextScan) {
        this.contextScan = contextScan;
    }

    @Override
    public CamelPropertyPlaceholderDefinition getCamelPropertyPlaceholder() {
        return this.camelPropertyPlaceholder;
    }

    public void setCamelPropertyPlaceholder(CamelPropertyPlaceholderDefinition camelPropertyPlaceholder) {
        this.camelPropertyPlaceholder = camelPropertyPlaceholder;
    }

    public void setCamelJMXAgent(CamelJMXAgentDefinition agent) {
        this.camelJMXAgent = agent;
    }

    @Override
    public String getTrace() {
        return this.trace;
    }

    public void setTrace(String trace) {
        this.trace = trace;
    }

    @Override
    public String getStreamCache() {
        return this.streamCache;
    }

    public void setStreamCache(String streamCache) {
        this.streamCache = streamCache;
    }

    @Override
    public String getDelayer() {
        return this.delayer;
    }

    public void setDelayer(String delayer) {
        this.delayer = delayer;
    }

    @Override
    public String getHandleFault() {
        return this.handleFault;
    }

    public void setHandleFault(String handleFault) {
        this.handleFault = handleFault;
    }

    @Override
    public String getAutoStartup() {
        return this.autoStartup;
    }

    public void setAutoStartup(String autoStartup) {
        this.autoStartup = autoStartup;
    }

    @Override
    public String getUseMDCLogging() {
        return this.useMDCLogging;
    }

    public void setUseMDCLogging(String useMDCLogging) {
        this.useMDCLogging = useMDCLogging;
    }

    @Override
    public Boolean getLazyLoadTypeConverters() {
        return this.lazyLoadTypeConverters;
    }

    public void setLazyLoadTypeConverters(Boolean lazyLoadTypeConverters) {
        this.lazyLoadTypeConverters = lazyLoadTypeConverters;
    }

    @Override
    public CamelJMXAgentDefinition getCamelJMXAgent() {
        return this.camelJMXAgent;
    }

    @Override
    public List<RouteBuilderDefinition> getBuilderRefs() {
        return this.builderRefs;
    }

    public void setBuilderRefs(List<RouteBuilderDefinition> builderRefs) {
        this.builderRefs = builderRefs;
    }

    @Override
    public List<RouteContextRefDefinition> getRouteRefs() {
        return this.routeRefs;
    }

    public void setRouteRefs(List<RouteContextRefDefinition> routeRefs) {
        this.routeRefs = routeRefs;
    }

    @Override
    public String getErrorHandlerRef() {
        return this.errorHandlerRef;
    }

    public void setErrorHandlerRef(String errorHandlerRef) {
        this.errorHandlerRef = errorHandlerRef;
    }

    public void setDataFormats(DataFormatsDefinition dataFormats) {
        this.dataFormats = dataFormats;
    }

    @Override
    public DataFormatsDefinition getDataFormats() {
        return this.dataFormats;
    }

    public void setOnExceptions(List<OnExceptionDefinition> onExceptions) {
        this.onExceptions = onExceptions;
    }

    @Override
    public List<OnExceptionDefinition> getOnExceptions() {
        return this.onExceptions;
    }

    @Override
    public List<OnCompletionDefinition> getOnCompletions() {
        return this.onCompletions;
    }

    public void setOnCompletions(List<OnCompletionDefinition> onCompletions) {
        this.onCompletions = onCompletions;
    }

    @Override
    public ShutdownRoute getShutdownRoute() {
        return this.shutdownRoute;
    }

    public void setShutdownRoute(ShutdownRoute shutdownRoute) {
        this.shutdownRoute = shutdownRoute;
    }

    @Override
    public ShutdownRunningTask getShutdownRunningTask() {
        return this.shutdownRunningTask;
    }

    public void setShutdownRunningTask(ShutdownRunningTask shutdownRunningTask) {
        this.shutdownRunningTask = shutdownRunningTask;
    }

    @Override
    public List<ThreadPoolProfileDefinition> getThreadPoolProfiles() {
        return this.threadPoolProfiles;
    }

    public void setThreadPoolProfiles(List<ThreadPoolProfileDefinition> threadPoolProfiles) {
        this.threadPoolProfiles = threadPoolProfiles;
    }

    @Override
    public String getDependsOn() {
        return this.dependsOn;
    }

    public void setDependsOn(String dependsOn) {
        this.dependsOn = dependsOn;
    }

    public boolean isImplicitId() {
        return this.implicitId;
    }

    public void setImplicitId(boolean flag) {
        this.implicitId = flag;
    }
}

