/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component;

import org.apache.camel.CamelContext;
import org.apache.camel.component.CamelClassPathResource;
import org.springframework.core.io.DefaultResourceLoader;
import org.springframework.core.io.Resource;
import org.springframework.util.Assert;

public class CamelResourceLoader
extends DefaultResourceLoader {
    private final CamelContext camelContext;

    public CamelResourceLoader(CamelContext camelContext) {
        this.camelContext = camelContext;
    }

    public Resource getResource(String location) {
        Assert.notNull((Object)location, (String)"Location must not be null");
        if (location.startsWith("classpath:")) {
            return new CamelClassPathResource(this.camelContext.getClassResolver(), location.substring("classpath:".length()), this.getClassLoader());
        }
        return super.getResource(location);
    }

    protected Resource getResourceByPath(String path) {
        return new CamelClassPathResource(this.camelContext.getClassResolver(), path, this.getClassLoader());
    }
}

