/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.spring;

import org.apache.camel.CamelContext;
import org.apache.camel.Component;
import org.apache.camel.Endpoint;
import org.apache.camel.Processor;
import org.apache.camel.component.bean.BeanProcessor;
import org.apache.camel.component.event.EventComponent;
import org.apache.camel.component.event.EventEndpoint;
import org.apache.camel.impl.DefaultCamelContext;
import org.apache.camel.impl.ProcessorEndpoint;
import org.apache.camel.spi.Injector;
import org.apache.camel.spi.Registry;
import org.apache.camel.spring.spi.ApplicationContextRegistry;
import org.apache.camel.spring.spi.SpringInjector;
import org.apache.camel.util.ObjectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.context.event.ContextStoppedEvent;
import org.springframework.context.support.ClassPathXmlApplicationContext;

public class SpringCamelContext
extends DefaultCamelContext
implements InitializingBean,
DisposableBean,
ApplicationContextAware {
    private static final transient Logger LOG = LoggerFactory.getLogger(SpringCamelContext.class);
    private ApplicationContext applicationContext;
    private EventEndpoint eventEndpoint;

    public SpringCamelContext() {
    }

    public SpringCamelContext(ApplicationContext applicationContext) {
        this.setApplicationContext(applicationContext);
    }

    public static SpringCamelContext springCamelContext(ApplicationContext applicationContext) throws Exception {
        return SpringCamelContext.springCamelContext(applicationContext, true);
    }

    public static SpringCamelContext springCamelContext(ApplicationContext applicationContext, boolean maybeStart) throws Exception {
        String[] names = applicationContext.getBeanNamesForType(SpringCamelContext.class);
        if (names.length == 1) {
            return (SpringCamelContext)((Object)applicationContext.getBean(names[0], SpringCamelContext.class));
        }
        SpringCamelContext answer = new SpringCamelContext();
        answer.setApplicationContext(applicationContext);
        if (maybeStart) {
            answer.afterPropertiesSet();
        }
        return answer;
    }

    public static SpringCamelContext springCamelContext(String configLocations) throws Exception {
        return SpringCamelContext.springCamelContext((ApplicationContext)new ClassPathXmlApplicationContext(configLocations));
    }

    public void afterPropertiesSet() throws Exception {
        this.maybeStart();
    }

    public void destroy() throws Exception {
        this.stop();
    }

    public void onApplicationEvent(ApplicationEvent event) {
        LOG.debug("onApplicationEvent: {}", (Object)event);
        if (event instanceof ContextRefreshedEvent) {
            try {
                this.maybeStart();
            }
            catch (Exception e) {
                throw ObjectHelper.wrapRuntimeCamelException((Throwable)e);
            }
        }
        if (event instanceof ContextStoppedEvent) {
            try {
                this.maybeStop();
            }
            catch (Exception e) {
                throw ObjectHelper.wrapRuntimeCamelException((Throwable)e);
            }
        }
        if (this.eventEndpoint != null) {
            this.eventEndpoint.onApplicationEvent(event);
        } else {
            LOG.info("No spring-event endpoint enabled to handle event: {}", (Object)event);
        }
    }

    public ApplicationContext getApplicationContext() {
        return this.applicationContext;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        ClassLoader cl;
        this.applicationContext = applicationContext;
        if (applicationContext != null && applicationContext.getClassLoader() != null) {
            cl = applicationContext.getClassLoader();
        } else {
            LOG.warn("Cannot find the class loader from application context, using the thread context class loader instead");
            cl = Thread.currentThread().getContextClassLoader();
        }
        LOG.debug("Set the application context classloader to: {}", (Object)cl);
        this.setApplicationContextClassLoader(cl);
        if (applicationContext instanceof ConfigurableApplicationContext && this.hasComponent("spring-event") == null) {
            this.addComponent("spring-event", (Component)new EventComponent(applicationContext));
        }
    }

    public EventEndpoint getEventEndpoint() {
        return this.eventEndpoint;
    }

    public void setEventEndpoint(EventEndpoint eventEndpoint) {
        this.eventEndpoint = eventEndpoint;
    }

    protected void doStart() throws Exception {
        super.doStart();
        if (this.eventEndpoint == null) {
            this.eventEndpoint = this.createEventEndpoint();
        }
    }

    protected Injector createInjector() {
        if (this.applicationContext instanceof ConfigurableApplicationContext) {
            return new SpringInjector((ConfigurableApplicationContext)this.applicationContext);
        }
        LOG.warn("Cannot use SpringInjector as applicationContext is not a ConfigurableApplicationContext as its: " + this.applicationContext);
        return super.createInjector();
    }

    protected EventEndpoint createEventEndpoint() {
        return (EventEndpoint)this.getEndpoint("spring-event:default", EventEndpoint.class);
    }

    protected Endpoint convertBeanToEndpoint(String uri, Object bean) {
        Endpoint endpoint = (Endpoint)this.getTypeConverter().convertTo(Endpoint.class, bean);
        if (endpoint != null) {
            endpoint.setCamelContext((CamelContext)this);
            return endpoint;
        }
        return new ProcessorEndpoint(uri, (CamelContext)this, (Processor)new BeanProcessor(bean, (CamelContext)this));
    }

    protected Registry createRegistry() {
        return new ApplicationContextRegistry(this.getApplicationContext());
    }

    private void maybeStart() throws Exception {
        String maybeStart = System.getProperty("maybeStartCamelContext", "true");
        if ("true".equals(maybeStart)) {
            if (!this.isStarted() && !this.isStarting()) {
                this.start();
            } else {
                LOG.trace("Ignoring maybeStart() as Apache Camel is already started");
            }
        } else {
            LOG.trace("Ignoring maybeStart() as System property maybeStartCamelContext is false");
        }
    }

    private void maybeStop() throws Exception {
        if (!this.isStopping() && !this.isStopped()) {
            this.stop();
        } else {
            LOG.trace("Ignoring maybeStop() as Apache Camel is already stopped");
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("SpringCamelContext(").append(this.getName()).append(")");
        if (this.applicationContext != null) {
            sb.append(" with spring id ").append(this.applicationContext.getId());
        }
        return sb.toString();
    }
}

