/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.core.osgi;

import java.io.BufferedInputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Properties;
import org.apache.camel.NoFactoryAvailableException;
import org.apache.camel.impl.DefaultFactoryFinder;
import org.apache.camel.spi.ClassResolver;
import org.apache.camel.util.IOHelper;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;

public class OsgiFactoryFinder
extends DefaultFactoryFinder {
    private BundleContext bundleContext;

    public OsgiFactoryFinder(BundleContext bundleContext, ClassResolver classResolver, String resourcePath) {
        super(classResolver, resourcePath);
        this.bundleContext = bundleContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Class<?> findClass(String key, String propertyPrefix, Class<?> checkClass) throws ClassNotFoundException, IOException {
        Class clazz;
        if (propertyPrefix == null) {
            propertyPrefix = "";
        }
        if ((clazz = (Class)this.classMap.get(propertyPrefix + key)) == null) {
            BundleEntry entry = this.getResource(key, checkClass);
            if (entry != null) {
                URL url = entry.url;
                InputStream in = url.openStream();
                BufferedInputStream reader = null;
                try {
                    reader = new BufferedInputStream(in);
                    Properties properties = new Properties();
                    properties.load(reader);
                    String className = properties.getProperty(propertyPrefix + "class");
                    if (className == null) {
                        throw new IOException("Expected property is missing: " + propertyPrefix + "class");
                    }
                    clazz = entry.bundle.loadClass(className);
                    this.classMap.put(propertyPrefix + key, clazz);
                }
                finally {
                    IOHelper.close((Closeable)reader, (String)key, null);
                    IOHelper.close((Closeable)in, (String)key, null);
                }
            } else {
                throw new NoFactoryAvailableException(propertyPrefix + key);
            }
        }
        return clazz;
    }

    public Class<?> findClass(String key, String propertyPrefix) throws ClassNotFoundException, IOException {
        return this.findClass(key, propertyPrefix, null);
    }

    public BundleEntry getResource(String name) {
        return this.getResource(name, null);
    }

    public BundleEntry getResource(String name, Class<?> clazz) {
        BundleEntry entry = null;
        Bundle[] bundles = null;
        for (Bundle bundle : bundles = this.bundleContext.getBundles()) {
            URL url = bundle.getEntry(this.getResourcePath() + name);
            if (url == null || !this.checkCompat(bundle, clazz)) continue;
            entry = new BundleEntry();
            entry.url = url;
            entry.bundle = bundle;
            break;
        }
        return entry;
    }

    private boolean checkCompat(Bundle bundle, Class clazz) {
        if (clazz == null) {
            return true;
        }
        try {
            if (bundle.loadClass(clazz.getName()) != clazz) {
                return false;
            }
        }
        catch (Throwable t) {
            return false;
        }
        return true;
    }

    private static class BundleEntry {
        URL url;
        Bundle bundle;

        private BundleEntry() {
        }
    }
}

