package org.apache.camel.spring.converter;

import org.apache.camel.Exchange;
import org.apache.camel.TypeConversionException;
import org.apache.camel.TypeConverterLoaderException;
import org.apache.camel.spi.TypeConverterLoader;
import org.apache.camel.spi.TypeConverterRegistry;
import org.apache.camel.support.TypeConverterSupport;
import org.apache.camel.util.DoubleMap;

@SuppressWarnings("unchecked")
public class ResourceConverterLoader implements TypeConverterLoader {


    static abstract class BaseTypeConverter extends TypeConverterSupport {
        private final boolean allowNull;

        public BaseTypeConverter(boolean allowNull) {
            this.allowNull = allowNull;
        }

        @Override
        public boolean allowNull() {
            return allowNull;
        }

        @Override
        public <T> T convertTo(Class<T> type, Exchange exchange, Object value) throws TypeConversionException {
            try {
                return (T) doConvert(exchange, value);
            } catch (TypeConversionException e) {
                throw e;
            } catch (Exception e) {
                throw new TypeConversionException(value, type, e);
            }
        }
        protected abstract Object doConvert(Exchange exchange, Object value) throws Exception;
    };

    private final DoubleMap<Class<?>, Class<?>, BaseTypeConverter> converters = new DoubleMap<>(1);

    public ResourceConverterLoader() {
    }

    private void registerConverters() {
        converters.put(java.io.InputStream.class, org.springframework.core.io.Resource.class, new BaseTypeConverter(false) {
            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return org.apache.camel.spring.converter.ResourceConverter.convertToInputStream((org.springframework.core.io.Resource) value);
            }
        });
    }

    @Override
    public void load(TypeConverterRegistry registry) throws TypeConverterLoaderException {
        registerConverters();
        converters.forEach((k, v, c) -> registry.addTypeConverter(k, v, c));
    }

}
