/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.sql;

import java.util.Map;
import javax.sql.DataSource;
import org.apache.camel.CamelContext;
import org.apache.camel.Component;
import org.apache.camel.Endpoint;
import org.apache.camel.component.sql.SqlEndpoint;
import org.apache.camel.impl.DefaultComponent;
import org.apache.camel.util.CamelContextHelper;
import org.apache.camel.util.IntrospectionSupport;
import org.springframework.jdbc.core.JdbcTemplate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SqlComponent
extends DefaultComponent {
    private DataSource dataSource;

    public SqlComponent() {
    }

    public SqlComponent(CamelContext context) {
        super(context);
    }

    protected Endpoint createEndpoint(String uri, String remaining, Map<String, Object> parameters) throws Exception {
        String dataSourceRef = (String)this.getAndRemoveParameter(parameters, "dataSourceRef", String.class);
        if (dataSourceRef != null) {
            this.dataSource = (DataSource)CamelContextHelper.mandatoryLookup((CamelContext)this.getCamelContext(), (String)dataSourceRef, DataSource.class);
        }
        JdbcTemplate jdbcTemplate = new JdbcTemplate(this.dataSource);
        IntrospectionSupport.setProperties((Object)jdbcTemplate, parameters, (String)"template.");
        String query = remaining.replaceAll("#", "?");
        return new SqlEndpoint(uri, (Component)this, jdbcTemplate, query);
    }

    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    public DataSource getDataSource() {
        return this.dataSource;
    }
}

