/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.sql;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.component.sql.SqlEndpoint;
import org.apache.camel.component.sql.SqlOutputType;
import org.apache.camel.component.sql.SqlPrepareStatementStrategy;
import org.apache.camel.impl.DefaultProducer;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.PreparedStatementCallback;
import org.springframework.jdbc.core.PreparedStatementCreator;

public class SqlProducer
extends DefaultProducer {
    private String query;
    private JdbcTemplate jdbcTemplate;
    private boolean batch;
    private boolean alwaysPopulateStatement;
    private SqlPrepareStatementStrategy sqlPrepareStatementStrategy;
    private int parametersCount;

    public SqlProducer(SqlEndpoint endpoint, String query, JdbcTemplate jdbcTemplate, SqlPrepareStatementStrategy sqlPrepareStatementStrategy, boolean batch, boolean alwaysPopulateStatement) {
        super((Endpoint)endpoint);
        this.jdbcTemplate = jdbcTemplate;
        this.sqlPrepareStatementStrategy = sqlPrepareStatementStrategy;
        this.query = query;
        this.batch = batch;
        this.alwaysPopulateStatement = alwaysPopulateStatement;
    }

    public SqlEndpoint getEndpoint() {
        return (SqlEndpoint)super.getEndpoint();
    }

    public void process(final Exchange exchange) throws Exception {
        String queryHeader = (String)exchange.getIn().getHeader("CamelSqlQuery", String.class);
        final String sql = queryHeader != null ? queryHeader : this.query;
        final String preparedQuery = this.sqlPrepareStatementStrategy.prepareQuery(sql, this.getEndpoint().isAllowNamedParameters());
        final Boolean shouldRetrieveGeneratedKeys = (Boolean)exchange.getIn().getHeader("CamelSqlRetrieveGeneratedKeys", (Object)false, Boolean.class);
        PreparedStatementCreator statementCreator = new PreparedStatementCreator(){

            public PreparedStatement createPreparedStatement(Connection con) throws SQLException {
                if (!shouldRetrieveGeneratedKeys.booleanValue()) {
                    return con.prepareStatement(preparedQuery);
                }
                Object expectedGeneratedColumns = exchange.getIn().getHeader("CamelSqlGeneratedColumns");
                if (expectedGeneratedColumns == null) {
                    return con.prepareStatement(preparedQuery, 1);
                }
                if (expectedGeneratedColumns instanceof String[]) {
                    return con.prepareStatement(preparedQuery, (String[])expectedGeneratedColumns);
                }
                if (expectedGeneratedColumns instanceof int[]) {
                    return con.prepareStatement(preparedQuery, (int[])expectedGeneratedColumns);
                }
                throw new IllegalArgumentException("Header specifying expected returning columns isn't an instance of String[] or int[] but " + expectedGeneratedColumns.getClass());
            }
        };
        this.jdbcTemplate.execute(statementCreator, new PreparedStatementCallback<Map<?, ?>>(){

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public Map<?, ?> doInPreparedStatement(PreparedStatement ps) throws SQLException {
                int expected;
                int n = expected = SqlProducer.this.parametersCount > 0 ? SqlProducer.this.parametersCount : ps.getParameterMetaData().getParameterCount();
                if (SqlProducer.this.alwaysPopulateStatement || expected > 0) {
                    if (SqlProducer.this.batch) {
                        Iterator iterator = (Iterator)exchange.getIn().getBody(Iterator.class);
                        while (iterator != null && iterator.hasNext()) {
                            Object value = iterator.next();
                            Iterator<?> i = SqlProducer.this.sqlPrepareStatementStrategy.createPopulateIterator(sql, preparedQuery, expected, exchange, value);
                            SqlProducer.this.sqlPrepareStatementStrategy.populateStatement(ps, i, expected);
                            ps.addBatch();
                        }
                    } else {
                        Iterator<?> i = SqlProducer.this.sqlPrepareStatementStrategy.createPopulateIterator(sql, preparedQuery, expected, exchange, exchange.getIn().getBody());
                        SqlProducer.this.sqlPrepareStatementStrategy.populateStatement(ps, i, expected);
                    }
                }
                boolean isResultSet = false;
                if (SqlProducer.this.batch) {
                    int[] updateCounts = ps.executeBatch();
                    int total = 0;
                    for (int count : updateCounts) {
                        total += count;
                    }
                    exchange.getIn().setHeader("CamelSqlUpdateCount", (Object)total);
                } else {
                    isResultSet = ps.execute();
                    if (isResultSet) {
                        exchange.getOut().getHeaders().putAll(exchange.getIn().getHeaders());
                        ResultSet rs = ps.getResultSet();
                        SqlOutputType outputType = SqlProducer.this.getEndpoint().getOutputType();
                        SqlProducer.this.log.trace("Got result list from query: {}, outputType={}", (Object)rs, (Object)outputType);
                        if (outputType == SqlOutputType.SelectList) {
                            List<Map<String, Object>> data = SqlProducer.this.getEndpoint().queryForList(rs);
                            if (SqlProducer.this.getEndpoint().isNoop()) {
                                exchange.getOut().setBody(exchange.getIn().getBody());
                            } else {
                                exchange.getOut().setBody(data);
                            }
                            exchange.getOut().setHeader("CamelSqlRowCount", (Object)data.size());
                        } else {
                            if (outputType != SqlOutputType.SelectOne) throw new IllegalArgumentException("Invalid outputType=" + (Object)((Object)outputType));
                            Object data = SqlProducer.this.getEndpoint().queryForObject(rs);
                            if (data != null) {
                                if (SqlProducer.this.getEndpoint().isNoop()) {
                                    exchange.getOut().setBody(exchange.getIn().getBody());
                                } else {
                                    exchange.getOut().setBody(data);
                                }
                                exchange.getOut().setHeader("CamelSqlRowCount", (Object)1);
                            }
                        }
                    } else {
                        exchange.getIn().setHeader("CamelSqlUpdateCount", (Object)ps.getUpdateCount());
                    }
                }
                if (!shouldRetrieveGeneratedKeys.booleanValue()) return null;
                if (!exchange.hasOut()) {
                    exchange.getOut().getHeaders().putAll(exchange.getIn().getHeaders());
                }
                if (isResultSet) {
                    exchange.getOut().setHeader("CamelSqlGeneratedKeyRows", (Object)Collections.EMPTY_LIST);
                    exchange.getOut().setHeader("CamelSqlGeneratedKeysRowCount", (Object)0);
                    return null;
                } else {
                    List<Map<String, Object>> generatedKeys = SqlProducer.this.getEndpoint().queryForList(ps.getGeneratedKeys());
                    exchange.getOut().setHeader("CamelSqlGeneratedKeyRows", generatedKeys);
                    exchange.getOut().setHeader("CamelSqlGeneratedKeysRowCount", (Object)generatedKeys.size());
                }
                return null;
            }
        });
    }

    public void setParametersCount(int parametersCount) {
        this.parametersCount = parametersCount;
    }
}

