/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.sql.stored.template.ast;

import java.lang.reflect.Field;
import java.sql.Types;
import org.apache.camel.component.sql.stored.template.ast.ParseRuntimeException;
import org.apache.camel.component.sql.stored.template.generated.Token;
import org.apache.camel.spi.ClassResolver;
import org.apache.camel.util.StringHelper;
import org.springframework.util.ReflectionUtils;

public final class ParseHelper {
    private ParseHelper() {
    }

    public static int parseSqlType(Token sqlTypeToken, ClassResolver classResolver) {
        String sqlType = sqlTypeToken.toString();
        if (sqlTypeToken.kind == 4) {
            return Integer.valueOf(sqlType);
        }
        if (sqlType.contains(".")) {
            String fieldName;
            String className;
            try {
                className = sqlType.substring(0, sqlType.lastIndexOf("."));
                fieldName = sqlType.substring(sqlType.lastIndexOf(".") + 1);
            }
            catch (Exception ex) {
                throw new ParseRuntimeException("Failed to parse class.field:" + sqlType);
            }
            try {
                Class clazz = classResolver.resolveMandatoryClass(className);
                return ParseHelper.getFieldInt(clazz, fieldName);
            }
            catch (ClassNotFoundException e) {
                throw new ParseRuntimeException("Class for " + className + " not found", e);
            }
        }
        return ParseHelper.getFieldInt(Types.class, sqlType);
    }

    public static Integer parseScale(Token token) {
        try {
            String str = token.toString();
            return Integer.valueOf(str.substring(1, str.length() - 1));
        }
        catch (Exception ex) {
            throw new ParseRuntimeException("Failed to parse scale from token:" + token.toString(), ex);
        }
    }

    private static int getFieldInt(Class clazz, String sqlType) {
        Field field = ReflectionUtils.findField((Class)clazz, (String)sqlType);
        if (field == null) {
            throw new ParseRuntimeException("Field " + sqlType + " not found from " + clazz.getName());
        }
        try {
            return field.getInt(Types.class);
        }
        catch (IllegalAccessException e) {
            throw new ParseRuntimeException(e);
        }
    }

    public static String removeQuotes(String token) {
        try {
            return StringHelper.removeLeadingAndEndingQuotes((String)token);
        }
        catch (Exception ex) {
            throw new ParseRuntimeException("Failed to remove quotes from token:" + token, ex);
        }
    }
}

