/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.sql;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.component.sql.SqlEndpoint;
import org.apache.camel.impl.DefaultProducer;
import org.springframework.jdbc.core.ColumnMapRowMapper;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.PreparedStatementCallback;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.RowMapperResultSetExtractor;

public class SqlProducer
extends DefaultProducer {
    private String query;
    private JdbcTemplate jdbcTemplate;
    private boolean batch;

    public SqlProducer(SqlEndpoint endpoint, String query, JdbcTemplate jdbcTemplate, boolean batch) {
        super((Endpoint)endpoint);
        this.jdbcTemplate = jdbcTemplate;
        this.query = query;
        this.batch = batch;
    }

    public void process(final Exchange exchange) throws Exception {
        this.jdbcTemplate.execute(this.query, new PreparedStatementCallback<Map<?, ?>>(){

            public Map<?, ?> doInPreparedStatement(PreparedStatement ps) throws SQLException {
                int expected = ps.getParameterMetaData().getParameterCount();
                if (exchange.getIn().getBody() != null) {
                    Iterator iterator = (Iterator)exchange.getIn().getBody(Iterator.class);
                    if (SqlProducer.this.batch) {
                        while (iterator != null && iterator.hasNext()) {
                            Object value = iterator.next();
                            Iterator i = (Iterator)exchange.getContext().getTypeConverter().convertTo(Iterator.class, value);
                            SqlProducer.this.populateStatement(ps, i, expected);
                            ps.addBatch();
                        }
                    } else {
                        SqlProducer.this.populateStatement(ps, iterator, expected);
                    }
                }
                if (SqlProducer.this.batch) {
                    int[] updateCounts = ps.executeBatch();
                    int total = 0;
                    for (int count : updateCounts) {
                        total += count;
                    }
                    exchange.getIn().setHeader("CamelSqlUpdateCount", (Object)total);
                } else {
                    boolean isResultSet = ps.execute();
                    if (isResultSet) {
                        RowMapperResultSetExtractor mapper = new RowMapperResultSetExtractor((RowMapper)new ColumnMapRowMapper());
                        List result = mapper.extractData(ps.getResultSet());
                        exchange.getOut().setBody((Object)result);
                        exchange.getIn().setHeader("CamelSqlRowCount", (Object)result.size());
                        exchange.getOut().setHeaders(exchange.getIn().getHeaders());
                    } else {
                        exchange.getIn().setHeader("CamelSqlUpdateCount", (Object)ps.getUpdateCount());
                    }
                }
                return null;
            }
        });
    }

    private void populateStatement(PreparedStatement ps, Iterator<?> iterator, int expectedParams) throws SQLException {
        int argNumber = 1;
        if (expectedParams > 0) {
            while (iterator != null && iterator.hasNext()) {
                Object value = iterator.next();
                this.log.trace("Setting parameter #{} with value: {}", (Object)argNumber, value);
                ps.setObject(argNumber, value);
                ++argNumber;
            }
        }
        if (argNumber - 1 != expectedParams) {
            throw new SQLException("Number of parameters mismatch. Expected: " + expectedParams + ", was:" + (argNumber - 1));
        }
    }
}

