/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor.aggregate.jdbc;

import java.io.IOException;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.sql.DataSource;
import org.apache.camel.CamelContext;
import org.apache.camel.Exchange;
import org.apache.camel.impl.ServiceSupport;
import org.apache.camel.processor.aggregate.jdbc.JdbcCamelCodec;
import org.apache.camel.spi.RecoverableAggregationRepository;
import org.apache.camel.util.ObjectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.dao.EmptyResultDataAccessException;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.PreparedStatementCallback;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.support.AbstractLobCreatingPreparedStatementCallback;
import org.springframework.jdbc.support.lob.DefaultLobHandler;
import org.springframework.jdbc.support.lob.LobCreator;
import org.springframework.jdbc.support.lob.LobHandler;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.TransactionCallback;
import org.springframework.transaction.support.TransactionCallbackWithoutResult;
import org.springframework.transaction.support.TransactionTemplate;

public class JdbcAggregationRepository
extends ServiceSupport
implements RecoverableAggregationRepository {
    private static final transient Logger LOG = LoggerFactory.getLogger(JdbcAggregationRepository.class);
    private static final String ID = "id";
    private static final String EXCHANGE = "exchange";
    private PlatformTransactionManager transactionManager;
    private DataSource dataSource;
    private TransactionTemplate transactionTemplate;
    private TransactionTemplate transactionTemplateReadOnly;
    private JdbcTemplate jdbcTemplate;
    private LobHandler lobHandler = new DefaultLobHandler();
    private String repositoryName;
    private boolean returnOldExchange;
    private JdbcCamelCodec codec = new JdbcCamelCodec();
    private long recoveryInterval = 5000L;
    private boolean useRecovery = true;
    private int maximumRedeliveries;
    private String deadLetterUri;

    public JdbcAggregationRepository() {
    }

    public JdbcAggregationRepository(PlatformTransactionManager transactionManager, String repositoryName, DataSource dataSource) {
        this.setRepositoryName(repositoryName);
        this.setTransactionManager(transactionManager);
        this.setDataSource(dataSource);
    }

    public final void setRepositoryName(String repositoryName) {
        this.repositoryName = repositoryName;
    }

    public final void setTransactionManager(PlatformTransactionManager transactionManager) {
        this.transactionManager = transactionManager;
        this.transactionTemplate = new TransactionTemplate(transactionManager);
        this.transactionTemplate.setPropagationBehavior(0);
        this.transactionTemplateReadOnly = new TransactionTemplate(transactionManager);
        this.transactionTemplateReadOnly.setPropagationBehavior(0);
        this.transactionTemplateReadOnly.setReadOnly(true);
    }

    public final void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
        this.jdbcTemplate = new JdbcTemplate(dataSource);
    }

    public Exchange add(final CamelContext camelContext, final String correlationId, final Exchange exchange) {
        return (Exchange)this.transactionTemplate.execute(new TransactionCallback(){

            public Exchange doInTransaction(TransactionStatus status) {
                Exchange result = null;
                final String key = correlationId;
                try {
                    String sql;
                    final byte[] data = JdbcAggregationRepository.this.codec.marshallExchange(camelContext, exchange);
                    LOG.debug("Adding exchange with key: [{}]", (Object)key);
                    String insert = "INSERT INTO " + JdbcAggregationRepository.this.getRepositoryName() + " (" + JdbcAggregationRepository.EXCHANGE + ", " + JdbcAggregationRepository.ID + ") VALUES (?, ?)";
                    String update = "UPDATE " + JdbcAggregationRepository.this.getRepositoryName() + " SET " + JdbcAggregationRepository.EXCHANGE + " = ? WHERE " + JdbcAggregationRepository.ID + " = ?";
                    boolean present = JdbcAggregationRepository.this.jdbcTemplate.queryForInt("SELECT COUNT(*) FROM " + JdbcAggregationRepository.this.getRepositoryName() + " WHERE " + JdbcAggregationRepository.ID + " = ?", new Object[]{key}) != 0;
                    String string = sql = present ? update : insert;
                    if (JdbcAggregationRepository.this.isReturnOldExchange() && present) {
                        result = JdbcAggregationRepository.this.get(key, JdbcAggregationRepository.this.getRepositoryName(), camelContext);
                    }
                    JdbcAggregationRepository.this.jdbcTemplate.execute(sql, (PreparedStatementCallback)new AbstractLobCreatingPreparedStatementCallback(JdbcAggregationRepository.this.getLobHandler()){

                        protected void setValues(PreparedStatement ps, LobCreator lobCreator) throws SQLException {
                            lobCreator.setBlobAsBytes(ps, 1, data);
                            ps.setString(2, key);
                        }
                    });
                }
                catch (IOException e) {
                    throw new RuntimeException("Error adding to repository " + JdbcAggregationRepository.this.repositoryName + " with key " + key, e);
                }
                return result;
            }
        });
    }

    public Exchange get(CamelContext camelContext, String correlationId) {
        String key = correlationId;
        Exchange result = this.get(key, this.getRepositoryName(), camelContext);
        LOG.debug("Getting key  [{}] -> {}", (Object)key, (Object)result);
        return result;
    }

    private Exchange get(final String key, final String repositoryName, final CamelContext camelContext) {
        return (Exchange)this.transactionTemplateReadOnly.execute(new TransactionCallback(){

            public Exchange doInTransaction(TransactionStatus status) {
                try {
                    byte[] data = (byte[])JdbcAggregationRepository.this.jdbcTemplate.queryForObject("SELECT exchange FROM " + repositoryName + " WHERE " + JdbcAggregationRepository.ID + " = ?", new Object[]{key}, byte[].class);
                    return JdbcAggregationRepository.this.codec.unmarshallExchange(camelContext, data);
                }
                catch (EmptyResultDataAccessException ex) {
                    return null;
                }
                catch (IOException ex) {
                    throw new RuntimeException("Error getting key " + key + " from repository " + repositoryName, ex);
                }
                catch (ClassNotFoundException ex) {
                    throw new RuntimeException(ex);
                }
            }
        });
    }

    public void remove(final CamelContext camelContext, final String correlationId, final Exchange exchange) {
        this.transactionTemplate.execute((TransactionCallback)new TransactionCallbackWithoutResult(){

            protected void doInTransactionWithoutResult(TransactionStatus status) {
                String key = correlationId;
                final String confirmKey = exchange.getExchangeId();
                try {
                    final byte[] data = JdbcAggregationRepository.this.codec.marshallExchange(camelContext, exchange);
                    LOG.debug("Removing key [{}]", (Object)key);
                    JdbcAggregationRepository.this.jdbcTemplate.update("DELETE FROM " + JdbcAggregationRepository.this.getRepositoryName() + " WHERE " + JdbcAggregationRepository.ID + " = ?", new Object[]{key});
                    JdbcAggregationRepository.this.jdbcTemplate.execute("INSERT INTO " + JdbcAggregationRepository.this.getRepositoryNameCompleted() + " (" + JdbcAggregationRepository.EXCHANGE + ", " + JdbcAggregationRepository.ID + ") VALUES (?, ?)", (PreparedStatementCallback)new AbstractLobCreatingPreparedStatementCallback(JdbcAggregationRepository.this.getLobHandler()){

                        protected void setValues(PreparedStatement ps, LobCreator lobCreator) throws SQLException {
                            lobCreator.setBlobAsBytes(ps, 1, data);
                            ps.setString(2, confirmKey);
                        }
                    });
                }
                catch (IOException e) {
                    throw new RuntimeException("Error removing key " + key + " from repository " + JdbcAggregationRepository.this.repositoryName, e);
                }
            }
        });
    }

    public void confirm(CamelContext camelContext, final String exchangeId) {
        this.transactionTemplate.execute((TransactionCallback)new TransactionCallbackWithoutResult(){

            protected void doInTransactionWithoutResult(TransactionStatus status) {
                LOG.debug("Confirming exchangeId [{}]", (Object)exchangeId);
                String confirmKey = exchangeId;
                JdbcAggregationRepository.this.jdbcTemplate.update("DELETE FROM " + JdbcAggregationRepository.this.getRepositoryNameCompleted() + " WHERE " + JdbcAggregationRepository.ID + " = ?", new Object[]{confirmKey});
            }
        });
    }

    public Set<String> getKeys() {
        return (LinkedHashSet)this.transactionTemplateReadOnly.execute(new TransactionCallback(){

            public LinkedHashSet<String> doInTransaction(TransactionStatus status) {
                List keys = JdbcAggregationRepository.this.jdbcTemplate.query("SELECT id FROM " + JdbcAggregationRepository.this.getRepositoryName(), (RowMapper)new RowMapper<String>(){

                    public String mapRow(ResultSet rs, int rowNum) throws SQLException {
                        String id = rs.getString(JdbcAggregationRepository.ID);
                        LOG.trace("getKey [{}]", (Object)id);
                        return id;
                    }
                });
                return new LinkedHashSet<String>(keys);
            }
        });
    }

    public Set<String> scan(CamelContext camelContext) {
        return (LinkedHashSet)this.transactionTemplateReadOnly.execute(new TransactionCallback(){

            public LinkedHashSet<String> doInTransaction(TransactionStatus status) {
                List keys = JdbcAggregationRepository.this.jdbcTemplate.query("SELECT id FROM " + JdbcAggregationRepository.this.getRepositoryNameCompleted(), (RowMapper)new RowMapper<String>(){

                    public String mapRow(ResultSet rs, int rowNum) throws SQLException {
                        String id = rs.getString(JdbcAggregationRepository.ID);
                        LOG.trace("getKey [{}]", (Object)id);
                        return id;
                    }
                });
                return new LinkedHashSet<String>(keys);
            }
        });
    }

    public Exchange recover(CamelContext camelContext, String exchangeId) {
        String key = exchangeId;
        Exchange answer = this.get(key, this.getRepositoryNameCompleted(), camelContext);
        LOG.debug("Recovering exchangeId [{}] -> {}", (Object)key, (Object)answer);
        return answer;
    }

    public void setRecoveryInterval(long interval, TimeUnit timeUnit) {
        this.recoveryInterval = timeUnit.toMillis(interval);
    }

    public void setRecoveryInterval(long interval) {
        this.recoveryInterval = interval;
    }

    public long getRecoveryIntervalInMillis() {
        return this.recoveryInterval;
    }

    public boolean isUseRecovery() {
        return this.useRecovery;
    }

    public void setUseRecovery(boolean useRecovery) {
        this.useRecovery = useRecovery;
    }

    public int getMaximumRedeliveries() {
        return this.maximumRedeliveries;
    }

    public void setMaximumRedeliveries(int maximumRedeliveries) {
        this.maximumRedeliveries = maximumRedeliveries;
    }

    public String getDeadLetterUri() {
        return this.deadLetterUri;
    }

    public void setDeadLetterUri(String deadLetterUri) {
        this.deadLetterUri = deadLetterUri;
    }

    public boolean isReturnOldExchange() {
        return this.returnOldExchange;
    }

    public void setReturnOldExchange(boolean returnOldExchange) {
        this.returnOldExchange = returnOldExchange;
    }

    public LobHandler getLobHandler() {
        return this.lobHandler;
    }

    public void setLobHandler(LobHandler lobHandler) {
        this.lobHandler = lobHandler;
    }

    public String getRepositoryName() {
        return this.repositoryName;
    }

    public String getRepositoryNameCompleted() {
        return this.getRepositoryName() + "_completed";
    }

    protected void doStart() throws Exception {
        ObjectHelper.notNull((Object)this.repositoryName, (String)"RepositoryName");
        ObjectHelper.notNull((Object)this.transactionManager, (String)"TransactionManager");
        ObjectHelper.notNull((Object)this.dataSource, (String)"DataSource");
        int current = this.getKeys().size();
        int completed = this.scan(null).size();
        if (current > 0) {
            LOG.info("On startup there are " + current + " aggregate exchanges (not completed) in repository: " + this.getRepositoryName());
        } else {
            LOG.info("On startup there are no existing aggregate exchanges (not completed) in repository: " + this.getRepositoryName());
        }
        if (completed > 0) {
            LOG.warn("On startup there are " + completed + " completed exchanges to be recovered in repository: " + this.getRepositoryNameCompleted());
        } else {
            LOG.info("On startup there are no completed exchanges to be recovered in repository: " + this.getRepositoryNameCompleted());
        }
    }

    protected void doStop() throws Exception {
    }
}

