/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor.idempotent.jdbc;

import java.sql.Timestamp;
import javax.sql.DataSource;
import org.apache.camel.impl.ServiceSupport;
import org.apache.camel.spi.IdempotentRepository;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.datasource.DataSourceTransactionManager;
import org.springframework.jmx.export.annotation.ManagedAttribute;
import org.springframework.jmx.export.annotation.ManagedOperation;
import org.springframework.jmx.export.annotation.ManagedResource;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.TransactionCallback;
import org.springframework.transaction.support.TransactionTemplate;

@ManagedResource(value="JdbcMessageIdRepository")
public class JdbcMessageIdRepository
extends ServiceSupport
implements IdempotentRepository<String> {
    protected static final String QUERY_STRING = "SELECT COUNT(*) FROM CAMEL_MESSAGEPROCESSED WHERE processorName = ? AND messageId = ?";
    protected static final String INSERT_STRING = "INSERT INTO CAMEL_MESSAGEPROCESSED (processorName, messageId, createdAt) VALUES (?, ?, ?)";
    protected static final String DELETE_STRING = "DELETE FROM CAMEL_MESSAGEPROCESSED WHERE processorName = ? AND messageId = ?";
    private final JdbcTemplate jdbcTemplate;
    private final String processorName;
    private final TransactionTemplate transactionTemplate;

    public JdbcMessageIdRepository(DataSource dataSource, String processorName) {
        this(dataSource, JdbcMessageIdRepository.createTransactionTemplate(dataSource), processorName);
    }

    public JdbcMessageIdRepository(DataSource dataSource, TransactionTemplate transactionTemplate, String processorName) {
        this.jdbcTemplate = new JdbcTemplate(dataSource);
        this.jdbcTemplate.afterPropertiesSet();
        this.processorName = processorName;
        this.transactionTemplate = transactionTemplate;
    }

    public static JdbcMessageIdRepository jpaMessageIdRepository(DataSource dataSource, String processorName) {
        return new JdbcMessageIdRepository(dataSource, processorName);
    }

    private static TransactionTemplate createTransactionTemplate(DataSource dataSource) {
        TransactionTemplate transactionTemplate = new TransactionTemplate();
        transactionTemplate.setTransactionManager((PlatformTransactionManager)new DataSourceTransactionManager(dataSource));
        transactionTemplate.setPropagationBehavior(0);
        return transactionTemplate;
    }

    @ManagedOperation(description="Adds the key to the store")
    public boolean add(final String messageId) {
        Boolean rc = (Boolean)this.transactionTemplate.execute(new TransactionCallback(){

            public Object doInTransaction(TransactionStatus status) {
                int count = JdbcMessageIdRepository.this.jdbcTemplate.queryForInt(JdbcMessageIdRepository.QUERY_STRING, new Object[]{JdbcMessageIdRepository.this.processorName, messageId});
                if (count == 0) {
                    JdbcMessageIdRepository.this.jdbcTemplate.update(JdbcMessageIdRepository.INSERT_STRING, new Object[]{JdbcMessageIdRepository.this.processorName, messageId, new Timestamp(System.currentTimeMillis())});
                    return Boolean.TRUE;
                }
                return Boolean.FALSE;
            }
        });
        return rc;
    }

    @ManagedOperation(description="Does the store contain the given key")
    public boolean contains(final String messageId) {
        Boolean rc = (Boolean)this.transactionTemplate.execute(new TransactionCallback(){

            public Object doInTransaction(TransactionStatus status) {
                int count = JdbcMessageIdRepository.this.jdbcTemplate.queryForInt(JdbcMessageIdRepository.QUERY_STRING, new Object[]{JdbcMessageIdRepository.this.processorName, messageId});
                if (count == 0) {
                    return Boolean.FALSE;
                }
                return Boolean.TRUE;
            }
        });
        return rc;
    }

    @ManagedOperation(description="Remove the key from the store")
    public boolean remove(final String messageId) {
        Boolean rc = (Boolean)this.transactionTemplate.execute(new TransactionCallback(){

            public Object doInTransaction(TransactionStatus status) {
                int updateCount = JdbcMessageIdRepository.this.jdbcTemplate.update(JdbcMessageIdRepository.DELETE_STRING, new Object[]{JdbcMessageIdRepository.this.processorName, messageId});
                if (updateCount == 0) {
                    return Boolean.FALSE;
                }
                return Boolean.TRUE;
            }
        });
        return rc;
    }

    public boolean confirm(String s) {
        return true;
    }

    @ManagedAttribute(description="The processor name")
    public String getProcessorName() {
        return this.processorName;
    }

    protected void doStart() throws Exception {
    }

    protected void doStop() throws Exception {
    }
}

