/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor.idempotent.jdbc;

import javax.sql.DataSource;
import org.apache.camel.spi.IdempotentRepository;
import org.apache.camel.support.ServiceSupport;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.datasource.DataSourceTransactionManager;
import org.springframework.jmx.export.annotation.ManagedOperation;
import org.springframework.jmx.export.annotation.ManagedResource;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.TransactionCallback;
import org.springframework.transaction.support.TransactionTemplate;

@ManagedResource(value="JDBC IdempotentRepository")
public abstract class AbstractJdbcMessageIdRepository<T>
extends ServiceSupport
implements IdempotentRepository<T> {
    protected JdbcTemplate jdbcTemplate;
    protected String processorName;
    protected TransactionTemplate transactionTemplate;
    protected DataSource dataSource;

    public AbstractJdbcMessageIdRepository() {
    }

    public AbstractJdbcMessageIdRepository(JdbcTemplate jdbcTemplate, TransactionTemplate transactionTemplate) {
        this.jdbcTemplate = jdbcTemplate;
        this.transactionTemplate = transactionTemplate;
    }

    public AbstractJdbcMessageIdRepository(DataSource dataSource, TransactionTemplate transactionTemplate, String processorName) {
        this.jdbcTemplate = new JdbcTemplate(dataSource);
        this.jdbcTemplate.afterPropertiesSet();
        this.processorName = processorName;
        this.transactionTemplate = transactionTemplate;
    }

    public AbstractJdbcMessageIdRepository(DataSource dataSource, String processorName) {
        this(dataSource, AbstractJdbcMessageIdRepository.createTransactionTemplate(dataSource), processorName);
    }

    protected abstract int queryForInt(T var1);

    protected abstract int insert(T var1);

    protected abstract int delete(T var1);

    protected static TransactionTemplate createTransactionTemplate(DataSource dataSource) {
        TransactionTemplate transactionTemplate = new TransactionTemplate();
        transactionTemplate.setTransactionManager((PlatformTransactionManager)new DataSourceTransactionManager(dataSource));
        transactionTemplate.setPropagationBehavior(0);
        return transactionTemplate;
    }

    protected void doStart() throws Exception {
    }

    protected void doStop() throws Exception {
    }

    @ManagedOperation(description="Adds the key to the store")
    public boolean add(final T key) {
        Boolean rc = (Boolean)this.transactionTemplate.execute((TransactionCallback)new TransactionCallback<Boolean>(){

            public Boolean doInTransaction(TransactionStatus status) {
                int count = AbstractJdbcMessageIdRepository.this.queryForInt(key);
                if (count == 0) {
                    AbstractJdbcMessageIdRepository.this.insert(key);
                    return Boolean.TRUE;
                }
                return Boolean.FALSE;
            }
        });
        return rc;
    }

    @ManagedOperation(description="Does the store contain the given key")
    public boolean contains(final T key) {
        Boolean rc = (Boolean)this.transactionTemplate.execute((TransactionCallback)new TransactionCallback<Boolean>(){

            public Boolean doInTransaction(TransactionStatus status) {
                int count = AbstractJdbcMessageIdRepository.this.queryForInt(key);
                if (count == 0) {
                    return Boolean.FALSE;
                }
                return Boolean.TRUE;
            }
        });
        return rc;
    }

    @ManagedOperation(description="Remove the key from the store")
    public boolean remove(final T key) {
        Boolean rc = (Boolean)this.transactionTemplate.execute((TransactionCallback)new TransactionCallback<Boolean>(){

            public Boolean doInTransaction(TransactionStatus status) {
                int updateCount = AbstractJdbcMessageIdRepository.this.delete(key);
                if (updateCount == 0) {
                    return Boolean.FALSE;
                }
                return Boolean.TRUE;
            }
        });
        return rc;
    }

    public boolean confirm(T key) {
        return true;
    }

    public JdbcTemplate getJdbcTemplate() {
        return this.jdbcTemplate;
    }

    public void setJdbcTemplate(JdbcTemplate jdbcTemplate) {
        this.jdbcTemplate = jdbcTemplate;
    }

    public String getProcessorName() {
        return this.processorName;
    }

    public void setProcessorName(String processorName) {
        this.processorName = processorName;
    }

    public TransactionTemplate getTransactionTemplate() {
        return this.transactionTemplate;
    }

    public void setTransactionTemplate(TransactionTemplate transactionTemplate) {
        this.transactionTemplate = transactionTemplate;
    }

    public DataSource getDataSource() {
        return this.dataSource;
    }

    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
    }
}

