/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor.idempotent.jdbc;

import java.sql.Timestamp;
import javax.sql.DataSource;
import org.apache.camel.processor.idempotent.jdbc.AbstractJdbcMessageIdRepository;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.transaction.support.TransactionTemplate;

public class JdbcMessageIdRepository
extends AbstractJdbcMessageIdRepository<String> {
    public static final String QUERY_STRING = "SELECT COUNT(*) FROM CAMEL_MESSAGEPROCESSED WHERE processorName = ? AND messageId = ?";
    public static final String INSERT_STRING = "INSERT INTO CAMEL_MESSAGEPROCESSED (processorName, messageId, createdAt) VALUES (?, ?, ?)";
    public static final String DELETE_STRING = "DELETE FROM CAMEL_MESSAGEPROCESSED WHERE processorName = ? AND messageId = ?";

    public JdbcMessageIdRepository() {
    }

    public JdbcMessageIdRepository(DataSource dataSource, String processorName) {
        super(dataSource, processorName);
    }

    public JdbcMessageIdRepository(DataSource dataSource, TransactionTemplate transactionTemplate, String processorName) {
        super(dataSource, transactionTemplate, processorName);
    }

    public JdbcMessageIdRepository(JdbcTemplate jdbcTemplate, TransactionTemplate transactionTemplate) {
        super(jdbcTemplate, transactionTemplate);
    }

    @Override
    protected int queryForInt(String key) {
        return this.jdbcTemplate.queryForInt(QUERY_STRING, new Object[]{this.processorName, key});
    }

    @Override
    protected int insert(String key) {
        return this.jdbcTemplate.update(INSERT_STRING, new Object[]{this.processorName, key, new Timestamp(System.currentTimeMillis())});
    }

    @Override
    protected int delete(String key) {
        return this.jdbcTemplate.update(DELETE_STRING, new Object[]{this.processorName, key});
    }
}

