/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor.aggregate.jdbc;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.sql.DataSource;
import org.apache.camel.CamelContext;
import org.apache.camel.Exchange;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.processor.aggregate.jdbc.DefaultJdbcOptimisticLockingExceptionMapper;
import org.apache.camel.processor.aggregate.jdbc.JdbcCamelCodec;
import org.apache.camel.processor.aggregate.jdbc.JdbcOptimisticLockingExceptionMapper;
import org.apache.camel.spi.OptimisticLockingAggregationRepository;
import org.apache.camel.spi.RecoverableAggregationRepository;
import org.apache.camel.support.service.ServiceSupport;
import org.apache.camel.util.ObjectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.dao.DataAccessException;
import org.springframework.dao.EmptyResultDataAccessException;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.PreparedStatementCallback;
import org.springframework.jdbc.core.ResultSetExtractor;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.support.AbstractLobCreatingPreparedStatementCallback;
import org.springframework.jdbc.core.support.AbstractLobStreamingResultSetExtractor;
import org.springframework.jdbc.support.lob.DefaultLobHandler;
import org.springframework.jdbc.support.lob.LobCreator;
import org.springframework.jdbc.support.lob.LobHandler;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.TransactionCallback;
import org.springframework.transaction.support.TransactionCallbackWithoutResult;
import org.springframework.transaction.support.TransactionTemplate;
import org.springframework.util.FileCopyUtils;

public class JdbcAggregationRepository
extends ServiceSupport
implements RecoverableAggregationRepository,
OptimisticLockingAggregationRepository {
    private static final Logger LOG = LoggerFactory.getLogger(JdbcAggregationRepository.class);
    private static final String ID = "id";
    private static final String EXCHANGE = "exchange";
    private static final String BODY = "body";
    private JdbcOptimisticLockingExceptionMapper jdbcOptimisticLockingExceptionMapper = new DefaultJdbcOptimisticLockingExceptionMapper();
    private PlatformTransactionManager transactionManager;
    private DataSource dataSource;
    private TransactionTemplate transactionTemplate;
    private TransactionTemplate transactionTemplateReadOnly;
    private JdbcTemplate jdbcTemplate;
    private LobHandler lobHandler = new DefaultLobHandler();
    private String repositoryName;
    private boolean returnOldExchange;
    private JdbcCamelCodec codec = new JdbcCamelCodec();
    private long recoveryInterval = 5000L;
    private boolean useRecovery = true;
    private int maximumRedeliveries;
    private String deadLetterUri;
    private List<String> headersToStoreAsText;
    private boolean storeBodyAsText;
    private boolean allowSerializedHeaders;

    public JdbcAggregationRepository() {
    }

    public JdbcAggregationRepository(PlatformTransactionManager transactionManager, String repositoryName, DataSource dataSource) {
        this.setRepositoryName(repositoryName);
        this.setTransactionManager(transactionManager);
        this.setDataSource(dataSource);
    }

    public final void setRepositoryName(String repositoryName) {
        this.repositoryName = repositoryName;
    }

    public final void setTransactionManager(PlatformTransactionManager transactionManager) {
        this.transactionManager = transactionManager;
        this.transactionTemplate = new TransactionTemplate(transactionManager);
        this.transactionTemplate.setPropagationBehavior(0);
        this.transactionTemplateReadOnly = new TransactionTemplate(transactionManager);
        this.transactionTemplateReadOnly.setPropagationBehavior(0);
        this.transactionTemplateReadOnly.setReadOnly(true);
    }

    public final void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
        this.jdbcTemplate = new JdbcTemplate(dataSource);
    }

    public Exchange add(CamelContext camelContext, String correlationId, Exchange oldExchange, Exchange newExchange) throws OptimisticLockingAggregationRepository.OptimisticLockingException {
        try {
            return this.add(camelContext, correlationId, newExchange);
        }
        catch (Exception e) {
            if (this.jdbcOptimisticLockingExceptionMapper != null && this.jdbcOptimisticLockingExceptionMapper.isOptimisticLocking(e)) {
                throw new OptimisticLockingAggregationRepository.OptimisticLockingException();
            }
            throw RuntimeCamelException.wrapRuntimeCamelException((Throwable)e);
        }
    }

    public Exchange add(final CamelContext camelContext, final String correlationId, final Exchange exchange) {
        return (Exchange)this.transactionTemplate.execute((TransactionCallback)new TransactionCallback<Exchange>(){

            public Exchange doInTransaction(TransactionStatus status) {
                Exchange result = null;
                String key = correlationId;
                try {
                    boolean present;
                    LOG.debug("Adding exchange with key: [{}]", (Object)key);
                    boolean bl = present = (Integer)JdbcAggregationRepository.this.jdbcTemplate.queryForObject("SELECT COUNT(*) FROM " + JdbcAggregationRepository.this.getRepositoryName() + " WHERE " + JdbcAggregationRepository.ID + " = ?", Integer.class, new Object[]{key}) != 0;
                    if (JdbcAggregationRepository.this.isReturnOldExchange() && present) {
                        result = JdbcAggregationRepository.this.get(key, JdbcAggregationRepository.this.getRepositoryName(), camelContext);
                    }
                    if (present) {
                        JdbcAggregationRepository.this.update(camelContext, correlationId, exchange, JdbcAggregationRepository.this.getRepositoryName());
                    } else {
                        JdbcAggregationRepository.this.insert(camelContext, correlationId, exchange, JdbcAggregationRepository.this.getRepositoryName());
                    }
                }
                catch (Exception e) {
                    throw new RuntimeException("Error adding to repository " + JdbcAggregationRepository.this.repositoryName + " with key " + key, e);
                }
                return result;
            }
        });
    }

    protected void update(CamelContext camelContext, String key, Exchange exchange, String repositoryName) throws Exception {
        StringBuilder queryBuilder = new StringBuilder().append("UPDATE ").append(repositoryName).append(" SET ").append(EXCHANGE).append(" = ?");
        if (this.storeBodyAsText) {
            queryBuilder.append(", ").append(BODY).append(" = ?");
        }
        if (this.hasHeadersToStoreAsText()) {
            for (String headerName : this.headersToStoreAsText) {
                queryBuilder.append(", ").append(headerName).append(" = ?");
            }
        }
        queryBuilder.append(" WHERE ").append(ID).append(" = ?");
        String sql = queryBuilder.toString();
        this.insertAndUpdateHelper(camelContext, key, exchange, sql, false);
    }

    protected void insert(CamelContext camelContext, String correlationId, Exchange exchange, String repositoryName) throws Exception {
        int totalParameterIndex = 2;
        StringBuilder queryBuilder = new StringBuilder().append("INSERT INTO ").append(repositoryName).append('(').append(EXCHANGE).append(", ").append(ID);
        if (this.storeBodyAsText) {
            queryBuilder.append(", ").append(BODY);
            ++totalParameterIndex;
        }
        if (this.hasHeadersToStoreAsText()) {
            for (String headerName : this.headersToStoreAsText) {
                queryBuilder.append(", ").append(headerName);
                ++totalParameterIndex;
            }
        }
        queryBuilder.append(") VALUES (");
        for (int i = 0; i < totalParameterIndex - 1; ++i) {
            queryBuilder.append("?, ");
        }
        queryBuilder.append("?)");
        String sql = queryBuilder.toString();
        this.insertAndUpdateHelper(camelContext, correlationId, exchange, sql, true);
    }

    protected void insertAndUpdateHelper(CamelContext camelContext, final String key, final Exchange exchange, String sql, final boolean idComesFirst) throws Exception {
        final byte[] data = this.codec.marshallExchange(camelContext, exchange, this.allowSerializedHeaders);
        this.jdbcTemplate.execute(sql, (PreparedStatementCallback)new AbstractLobCreatingPreparedStatementCallback(this.getLobHandler()){

            protected void setValues(PreparedStatement ps, LobCreator lobCreator) throws SQLException {
                int totalParameterIndex = 0;
                lobCreator.setBlobAsBytes(ps, ++totalParameterIndex, data);
                if (idComesFirst) {
                    ps.setString(++totalParameterIndex, key);
                }
                if (JdbcAggregationRepository.this.storeBodyAsText) {
                    ps.setString(++totalParameterIndex, (String)exchange.getIn().getBody(String.class));
                }
                if (JdbcAggregationRepository.this.hasHeadersToStoreAsText()) {
                    for (String headerName : JdbcAggregationRepository.this.headersToStoreAsText) {
                        String headerValue = (String)exchange.getIn().getHeader(headerName, String.class);
                        ps.setString(++totalParameterIndex, headerValue);
                    }
                }
                if (!idComesFirst) {
                    ps.setString(++totalParameterIndex, key);
                }
            }
        });
    }

    public Exchange get(CamelContext camelContext, String correlationId) {
        String key = correlationId;
        Exchange result = this.get(key, this.getRepositoryName(), camelContext);
        LOG.debug("Getting key  [{}] -> {}", (Object)key, (Object)result);
        return result;
    }

    private Exchange get(final String key, final String repositoryName, final CamelContext camelContext) {
        return (Exchange)this.transactionTemplateReadOnly.execute((TransactionCallback)new TransactionCallback<Exchange>(){

            public Exchange doInTransaction(TransactionStatus status) {
                try {
                    String sql = "SELECT exchange FROM " + repositoryName + " WHERE " + JdbcAggregationRepository.ID + " = ?";
                    final ByteArrayOutputStream bis = new ByteArrayOutputStream();
                    JdbcAggregationRepository.this.jdbcTemplate.query(sql, new Object[]{key}, (ResultSetExtractor)new AbstractLobStreamingResultSetExtractor<Object>(){

                        protected void streamData(ResultSet rs) throws SQLException, IOException, DataAccessException {
                            FileCopyUtils.copy((InputStream)JdbcAggregationRepository.this.getLobHandler().getBlobAsBinaryStream(rs, JdbcAggregationRepository.EXCHANGE), (OutputStream)bis);
                        }
                    });
                    return JdbcAggregationRepository.this.codec.unmarshallExchange(camelContext, bis.toByteArray());
                }
                catch (EmptyResultDataAccessException ex) {
                    return null;
                }
                catch (IOException ex) {
                    throw new RuntimeException("Error getting key " + key + " from repository " + repositoryName, ex);
                }
                catch (ClassNotFoundException ex) {
                    throw new RuntimeException(ex);
                }
            }
        });
    }

    public void remove(final CamelContext camelContext, final String correlationId, final Exchange exchange) {
        this.transactionTemplate.execute((TransactionCallback)new TransactionCallbackWithoutResult(){

            protected void doInTransactionWithoutResult(TransactionStatus status) {
                String key = correlationId;
                String confirmKey = exchange.getExchangeId();
                try {
                    LOG.debug("Removing key [{}]", (Object)key);
                    JdbcAggregationRepository.this.jdbcTemplate.update("DELETE FROM " + JdbcAggregationRepository.this.getRepositoryName() + " WHERE " + JdbcAggregationRepository.ID + " = ?", new Object[]{key});
                    JdbcAggregationRepository.this.insert(camelContext, confirmKey, exchange, JdbcAggregationRepository.this.getRepositoryNameCompleted());
                }
                catch (Exception e) {
                    throw new RuntimeException("Error removing key " + key + " from repository " + JdbcAggregationRepository.this.repositoryName, e);
                }
            }
        });
    }

    public void confirm(CamelContext camelContext, final String exchangeId) {
        this.transactionTemplate.execute((TransactionCallback)new TransactionCallbackWithoutResult(){

            protected void doInTransactionWithoutResult(TransactionStatus status) {
                LOG.debug("Confirming exchangeId [{}]", (Object)exchangeId);
                String confirmKey = exchangeId;
                JdbcAggregationRepository.this.jdbcTemplate.update("DELETE FROM " + JdbcAggregationRepository.this.getRepositoryNameCompleted() + " WHERE " + JdbcAggregationRepository.ID + " = ?", new Object[]{confirmKey});
            }
        });
    }

    public Set<String> getKeys() {
        return this.getKeys(this.getRepositoryName());
    }

    public Set<String> scan(CamelContext camelContext) {
        return this.getKeys(this.getRepositoryNameCompleted());
    }

    protected Set<String> getKeys(final String repositoryName) {
        return (Set)this.transactionTemplateReadOnly.execute((TransactionCallback)new TransactionCallback<LinkedHashSet<String>>(){

            public LinkedHashSet<String> doInTransaction(TransactionStatus status) {
                List keys = JdbcAggregationRepository.this.jdbcTemplate.query("SELECT id FROM " + repositoryName, (RowMapper)new RowMapper<String>(){

                    public String mapRow(ResultSet rs, int rowNum) throws SQLException {
                        String id = rs.getString(JdbcAggregationRepository.ID);
                        LOG.trace("getKey [{}]", (Object)id);
                        return id;
                    }
                });
                return new LinkedHashSet<String>(keys);
            }
        });
    }

    public Exchange recover(CamelContext camelContext, String exchangeId) {
        String key = exchangeId;
        Exchange answer = this.get(key, this.getRepositoryNameCompleted(), camelContext);
        LOG.debug("Recovering exchangeId [{}] -> {}", (Object)key, (Object)answer);
        return answer;
    }

    public void setRecoveryInterval(long interval, TimeUnit timeUnit) {
        this.recoveryInterval = timeUnit.toMillis(interval);
    }

    public void setRecoveryInterval(long interval) {
        this.recoveryInterval = interval;
    }

    public long getRecoveryIntervalInMillis() {
        return this.recoveryInterval;
    }

    public boolean isUseRecovery() {
        return this.useRecovery;
    }

    public void setUseRecovery(boolean useRecovery) {
        this.useRecovery = useRecovery;
    }

    public int getMaximumRedeliveries() {
        return this.maximumRedeliveries;
    }

    public void setMaximumRedeliveries(int maximumRedeliveries) {
        this.maximumRedeliveries = maximumRedeliveries;
    }

    public String getDeadLetterUri() {
        return this.deadLetterUri;
    }

    public void setDeadLetterUri(String deadLetterUri) {
        this.deadLetterUri = deadLetterUri;
    }

    public boolean isReturnOldExchange() {
        return this.returnOldExchange;
    }

    public void setReturnOldExchange(boolean returnOldExchange) {
        this.returnOldExchange = returnOldExchange;
    }

    public void setJdbcCamelCodec(JdbcCamelCodec codec) {
        this.codec = codec;
    }

    public boolean hasHeadersToStoreAsText() {
        return this.headersToStoreAsText != null && !this.headersToStoreAsText.isEmpty();
    }

    public void setHeadersToStoreAsText(List<String> headersToStoreAsText) {
        this.headersToStoreAsText = headersToStoreAsText;
    }

    public void setStoreBodyAsText(boolean storeBodyAsText) {
        this.storeBodyAsText = storeBodyAsText;
    }

    public boolean isAllowSerializedHeaders() {
        return this.allowSerializedHeaders;
    }

    public void setAllowSerializedHeaders(boolean allowSerializedHeaders) {
        this.allowSerializedHeaders = allowSerializedHeaders;
    }

    public LobHandler getLobHandler() {
        return this.lobHandler;
    }

    public void setLobHandler(LobHandler lobHandler) {
        this.lobHandler = lobHandler;
    }

    public JdbcOptimisticLockingExceptionMapper getJdbcOptimisticLockingExceptionMapper() {
        return this.jdbcOptimisticLockingExceptionMapper;
    }

    public void setJdbcOptimisticLockingExceptionMapper(JdbcOptimisticLockingExceptionMapper jdbcOptimisticLockingExceptionMapper) {
        this.jdbcOptimisticLockingExceptionMapper = jdbcOptimisticLockingExceptionMapper;
    }

    public String getRepositoryName() {
        return this.repositoryName;
    }

    public String getRepositoryNameCompleted() {
        return this.getRepositoryName() + "_completed";
    }

    protected void doStart() throws Exception {
        ObjectHelper.notNull((Object)this.repositoryName, (String)"RepositoryName");
        ObjectHelper.notNull((Object)this.transactionManager, (String)"TransactionManager");
        ObjectHelper.notNull((Object)this.dataSource, (String)"DataSource");
        int current = this.getKeys().size();
        int completed = this.scan(null).size();
        if (current > 0) {
            LOG.info("On startup there are " + current + " aggregate exchanges (not completed) in repository: " + this.getRepositoryName());
        } else {
            LOG.info("On startup there are no existing aggregate exchanges (not completed) in repository: {}", (Object)this.getRepositoryName());
        }
        if (completed > 0) {
            LOG.warn("On startup there are " + completed + " completed exchanges to be recovered in repository: " + this.getRepositoryNameCompleted());
        } else {
            LOG.info("On startup there are no completed exchanges to be recovered in repository: {}", (Object)this.getRepositoryNameCompleted());
        }
    }

    protected void doStop() throws Exception {
    }
}

