/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.support;

import org.apache.camel.CamelContext;
import org.apache.camel.CamelContextAware;
import org.apache.camel.Exchange;
import org.apache.camel.InvalidPayloadException;
import org.apache.camel.Message;
import org.apache.camel.TypeConverter;
import org.apache.camel.spi.DataType;
import org.apache.camel.spi.DataTypeAware;
import org.apache.camel.support.SimpleUuidGenerator;

public abstract class MessageSupport
implements Message,
CamelContextAware,
DataTypeAware {
    private CamelContext camelContext;
    private Exchange exchange;
    private Object body;
    private String messageId;
    private DataType dataType;

    public String toString() {
        return String.format("Message[%s]", this.messageId == null ? "" : this.messageId);
    }

    public Object getBody() {
        if (this.body == null) {
            this.body = this.createBody();
        }
        return this.body;
    }

    public <T> T getBody(Class<T> type) {
        return this.getBody(type, this.getBody());
    }

    public Object getMandatoryBody() throws InvalidPayloadException {
        Object answer = this.getBody();
        if (answer == null) {
            throw new InvalidPayloadException(this.getExchange(), Object.class, (Message)this);
        }
        return answer;
    }

    protected <T> T getBody(Class<T> type, Object body) {
        if (type.isInstance(body)) {
            return type.cast(body);
        }
        Exchange e = this.getExchange();
        if (e != null) {
            TypeConverter converter = e.getContext().getTypeConverter();
            Object answer = converter.convertTo(type, e, body);
            if (answer != null) {
                return (T)answer;
            }
            answer = converter.tryConvertTo(type, e, (Object)this);
            if (answer != null) {
                return (T)answer;
            }
        }
        return null;
    }

    public <T> T getMandatoryBody(Class<T> type) throws InvalidPayloadException {
        if (type.isInstance(this.body)) {
            return type.cast(this.body);
        }
        Exchange e = this.getExchange();
        if (e != null) {
            TypeConverter converter = e.getContext().getTypeConverter();
            try {
                return (T)converter.mandatoryConvertTo(type, e, this.getBody());
            }
            catch (Exception cause) {
                throw new InvalidPayloadException(e, type, (Message)this, (Throwable)cause);
            }
        }
        throw new InvalidPayloadException(e, type, (Message)this);
    }

    public void setBody(Object body) {
        this.body = body;
        if (body != null && this.camelContext != null && this.camelContext.isUseDataType().booleanValue()) {
            this.dataType = new DataType(body.getClass());
        }
    }

    public <T> void setBody(Object value, Class<T> type) {
        Object v;
        Exchange e = this.getExchange();
        if (e != null && (v = e.getContext().getTypeConverter().convertTo(type, e, value)) != null) {
            value = v;
        }
        this.setBody(value);
    }

    public void setBody(Object body, DataType type) {
        this.body = body;
        this.dataType = type;
    }

    public DataType getDataType() {
        return this.dataType;
    }

    public void setDataType(DataType type) {
        this.dataType = type;
    }

    public boolean hasDataType() {
        return this.dataType != null;
    }

    public Message copy() {
        Message answer = this.newInstance();
        if (answer instanceof CamelContextAware) {
            ((CamelContextAware)answer).setCamelContext(this.getCamelContext());
        }
        answer.copyFrom((Message)this);
        return answer;
    }

    public void copyFrom(Message that) {
        if (that == this) {
            return;
        }
        if (that instanceof CamelContextAware) {
            this.setCamelContext(((CamelContextAware)that).getCamelContext());
        }
        if (that instanceof DataTypeAware && ((DataTypeAware)that).hasDataType()) {
            this.setDataType(((DataTypeAware)that).getDataType());
        }
        if (this.getExchange() == null) {
            this.setExchange(that.getExchange());
        }
        this.copyFromWithNewBody(that, that.getBody());
    }

    public void copyFromWithNewBody(Message that, Object newBody) {
        if (that == this) {
            return;
        }
        if (that instanceof CamelContextAware) {
            this.setCamelContext(((CamelContextAware)that).getCamelContext());
        }
        if (this.getExchange() == null) {
            this.setExchange(that.getExchange());
        }
        this.setMessageId(that.getMessageId());
        this.setBody(newBody);
        this.setFault(that.isFault());
        boolean sameHeadersInstance = false;
        if (this.hasHeaders() && that.hasHeaders() && this.getHeaders() == that.getHeaders()) {
            sameHeadersInstance = true;
        }
        if (!sameHeadersInstance) {
            if (this.hasHeaders()) {
                this.getHeaders().clear();
            }
            if (that.hasHeaders()) {
                this.getHeaders().putAll(that.getHeaders());
            }
        }
        this.copyAttachments(that);
    }

    public Exchange getExchange() {
        return this.exchange;
    }

    public void setExchange(Exchange exchange) {
        this.exchange = exchange;
    }

    public CamelContext getCamelContext() {
        return this.camelContext;
    }

    public void setCamelContext(CamelContext camelContext) {
        this.camelContext = camelContext;
    }

    public void copyAttachments(Message that) {
        boolean sameAttachments = false;
        if (this.hasAttachments() && that.hasAttachments() && this.getAttachmentObjects() == that.getAttachmentObjects()) {
            sameAttachments = true;
        }
        if (!sameAttachments) {
            if (this.hasAttachments()) {
                this.getAttachmentObjects().clear();
            }
            if (that.hasAttachments()) {
                this.getAttachmentObjects().putAll(that.getAttachmentObjects());
            }
        }
    }

    public abstract Message newInstance();

    protected Object createBody() {
        return null;
    }

    public String getMessageId() {
        if (this.messageId == null) {
            this.messageId = this.createMessageId();
        }
        return this.messageId;
    }

    public void setMessageId(String messageId) {
        this.messageId = messageId;
    }

    protected String createMessageId() {
        String uuid = null;
        if (this.exchange != null) {
            uuid = this.exchange.getContext().getUuidGenerator().generateUuid();
        }
        if (uuid == null) {
            uuid = new SimpleUuidGenerator().generateUuid();
        }
        return uuid;
    }
}

