/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.support;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.camel.Component;
import org.apache.camel.LoggingLevel;
import org.apache.camel.PollingConsumer;
import org.apache.camel.ResolveEndpointFailedException;
import org.apache.camel.spi.PollingConsumerPollStrategy;
import org.apache.camel.spi.ScheduledPollConsumerScheduler;
import org.apache.camel.spi.UriParam;
import org.apache.camel.support.CamelContextHelper;
import org.apache.camel.support.DefaultEndpoint;
import org.apache.camel.support.DefaultPollingConsumerPollStrategy;
import org.apache.camel.support.IntrospectionSupport;

public abstract class ScheduledPollEndpoint
extends DefaultEndpoint {
    private static final String SPRING_SCHEDULER = "org.apache.camel.spring.pollingconsumer.SpringScheduledPollConsumerScheduler";
    private static final String QUARTZ_2_SCHEDULER = "org.apache.camel.pollconsumer.quartz2.QuartzScheduledPollConsumerScheduler";
    @UriParam(optionalPrefix="consumer.", defaultValue="true", label="consumer,scheduler", description="Whether the scheduler should be auto started.")
    private boolean startScheduler = true;
    @UriParam(optionalPrefix="consumer.", defaultValue="1000", label="consumer,scheduler", description="Milliseconds before the first poll starts. You can also specify time values using units, such as 60s (60 seconds), 5m30s (5 minutes and 30 seconds), and 1h (1 hour).")
    private long initialDelay = 1000L;
    @UriParam(optionalPrefix="consumer.", defaultValue="500", label="consumer,scheduler", description="Milliseconds before the next poll. You can also specify time values using units, such as 60s (60 seconds), 5m30s (5 minutes and 30 seconds), and 1h (1 hour).")
    private long delay = 500L;
    @UriParam(optionalPrefix="consumer.", defaultValue="MILLISECONDS", label="consumer,scheduler", description="Time unit for initialDelay and delay options.")
    private TimeUnit timeUnit = TimeUnit.MILLISECONDS;
    @UriParam(optionalPrefix="consumer.", defaultValue="true", label="consumer,scheduler", description="Controls if fixed delay or fixed rate is used. See ScheduledExecutorService in JDK for details.")
    private boolean useFixedDelay = true;
    @UriParam(optionalPrefix="consumer.", label="consumer,advanced", description="A pluggable org.apache.camel.PollingConsumerPollingStrategy allowing you to provide your custom implementation to control error handling usually occurred during the poll operation before an Exchange have been created and being routed in Camel.")
    private PollingConsumerPollStrategy pollStrategy = new DefaultPollingConsumerPollStrategy();
    @UriParam(optionalPrefix="consumer.", defaultValue="TRACE", label="consumer,scheduler", description="The consumer logs a start/complete log line when it polls. This option allows you to configure the logging level for that.")
    private LoggingLevel runLoggingLevel = LoggingLevel.TRACE;
    @UriParam(optionalPrefix="consumer.", label="consumer", description="If the polling consumer did not poll any files, you can enable this option to send an empty message (no body) instead.")
    private boolean sendEmptyMessageWhenIdle;
    @UriParam(optionalPrefix="consumer.", label="consumer,scheduler", description="If greedy is enabled, then the ScheduledPollConsumer will run immediately again, if the previous run polled 1 or more messages.")
    private boolean greedy;
    @UriParam(optionalPrefix="consumer.", enums="none,spring,quartz2", defaultValue="none", label="consumer,scheduler", description="To use a cron scheduler from either camel-spring or camel-quartz2 component")
    private ScheduledPollConsumerScheduler scheduler;
    private String schedulerName = "none";
    @UriParam(prefix="scheduler.", multiValue=true, label="consumer,scheduler", description="To configure additional properties when using a custom scheduler or any of the Quartz2, Spring based scheduler.")
    private Map<String, Object> schedulerProperties;
    @UriParam(optionalPrefix="consumer.", label="consumer,scheduler", description="Allows for configuring a custom/shared thread pool to use for the consumer. By default each consumer has its own single threaded thread pool.")
    private ScheduledExecutorService scheduledExecutorService;
    @UriParam(optionalPrefix="consumer.", label="consumer,scheduler", description="To let the scheduled polling consumer backoff if there has been a number of subsequent idles/errors in a row. The multiplier is then the number of polls that will be skipped before the next actual attempt is happening again. When this option is in use then backoffIdleThreshold and/or backoffErrorThreshold must also be configured.")
    private int backoffMultiplier;
    @UriParam(optionalPrefix="consumer.", label="consumer,scheduler", description="The number of subsequent idle polls that should happen before the backoffMultipler should kick-in.")
    private int backoffIdleThreshold;
    @UriParam(optionalPrefix="consumer.", label="consumer,scheduler", description="The number of subsequent error polls (failed due some error) that should happen before the backoffMultipler should kick-in.")
    private int backoffErrorThreshold;

    protected ScheduledPollEndpoint(String endpointUri, Component component) {
        super(endpointUri, component);
    }

    protected ScheduledPollEndpoint() {
    }

    @Override
    public void configureProperties(Map<String, Object> options) {
        super.configureProperties(options);
        this.configureScheduledPollConsumerProperties(options, this.getConsumerProperties());
    }

    protected void configureScheduledPollConsumerProperties(Map<String, Object> options, Map<String, Object> consumerProperties) {
        Map<String, Object> schedulerProperties = IntrospectionSupport.extractProperties(options, "scheduler.");
        if (schedulerProperties != null && !schedulerProperties.isEmpty()) {
            this.setSchedulerProperties(schedulerProperties);
        }
        if (this.scheduler == null && this.schedulerName != null) {
            if ("none".equals(this.schedulerName)) {
                this.scheduler = null;
            } else if ("spring".equals(this.schedulerName)) {
                try {
                    Class clazz = this.getCamelContext().getClassResolver().resolveMandatoryClass(SPRING_SCHEDULER, ScheduledPollConsumerScheduler.class);
                    this.setScheduler((ScheduledPollConsumerScheduler)this.getCamelContext().getInjector().newInstance(clazz));
                }
                catch (ClassNotFoundException e) {
                    throw new IllegalArgumentException("Cannot load org.apache.camel.spring.pollingconsumer.SpringScheduledPollConsumerScheduler from classpath. Make sure camel-spring.jar is on the classpath.", e);
                }
            } else if ("quartz2".equals(this.schedulerName)) {
                try {
                    Class clazz = this.getCamelContext().getClassResolver().resolveMandatoryClass(QUARTZ_2_SCHEDULER, ScheduledPollConsumerScheduler.class);
                    this.setScheduler((ScheduledPollConsumerScheduler)this.getCamelContext().getInjector().newInstance(clazz));
                }
                catch (ClassNotFoundException e) {
                    throw new IllegalArgumentException("Cannot load org.apache.camel.pollconsumer.quartz2.QuartzScheduledPollConsumerScheduler from classpath. Make sure camel-quartz2.jar is on the classpath.", e);
                }
            } else {
                this.setScheduler(CamelContextHelper.mandatoryLookup(this.getCamelContext(), this.schedulerName, ScheduledPollConsumerScheduler.class));
            }
        }
    }

    @Override
    protected void configurePollingConsumer(PollingConsumer consumer) throws Exception {
        HashMap<String, Object> copy = new HashMap<String, Object>(this.getConsumerProperties());
        HashMap<String, Object> throwaway = new HashMap<String, Object>();
        this.configureScheduledPollConsumerProperties(copy, throwaway);
        this.setProperties(consumer, copy);
        if (!this.isLenientProperties() && copy.size() > 0) {
            throw new ResolveEndpointFailedException(this.getEndpointUri(), "There are " + copy.size() + " parameters that couldn't be set on the endpoint polling consumer. Check the uri if the parameters are spelt correctly and that they are properties of the endpoint. Unknown consumer parameters=[" + copy + "]");
        }
    }

    protected void initConsumerProperties() {
        Map<String, Object> options = this.getConsumerProperties();
        if (!options.containsKey("startScheduler")) {
            options.put("startScheduler", this.isStartScheduler());
        }
        if (!options.containsKey("initialDelay")) {
            options.put("initialDelay", this.getInitialDelay());
        }
        if (!options.containsKey("delay")) {
            options.put("delay", this.getDelay());
        }
        if (!options.containsKey("timeUnit")) {
            options.put("timeUnit", (Object)this.getTimeUnit());
        }
        if (!options.containsKey("useFixedDelay")) {
            options.put("useFixedDelay", this.isUseFixedDelay());
        }
        if (!options.containsKey("pollStrategy")) {
            options.put("pollStrategy", this.getPollStrategy());
        }
        if (!options.containsKey("runLoggingLevel")) {
            options.put("runLoggingLevel", this.getRunLoggingLevel());
        }
        if (!options.containsKey("sendEmptyMessageWhenIdle")) {
            options.put("sendEmptyMessageWhenIdle", this.isSendEmptyMessageWhenIdle());
        }
        if (!options.containsKey("greedy")) {
            options.put("greedy", this.isGreedy());
        }
        if (!options.containsKey("scheduler")) {
            options.put("scheduler", this.getScheduler());
        }
        if (!options.containsKey("schedulerProperties")) {
            options.put("schedulerProperties", this.getSchedulerProperties());
        }
        if (!options.containsKey("scheduledExecutorService")) {
            options.put("scheduledExecutorService", this.getScheduledExecutorService());
        }
        if (!options.containsKey("backoffMultiplier")) {
            options.put("backoffMultiplier", this.getBackoffMultiplier());
        }
        if (!options.containsKey("backoffIdleThreshold")) {
            options.put("backoffIdleThreshold", this.getBackoffIdleThreshold());
        }
        if (!options.containsKey("backoffErrorThreshold")) {
            options.put("backoffErrorThreshold", this.getBackoffErrorThreshold());
        }
    }

    @Override
    protected void doStart() throws Exception {
        this.initConsumerProperties();
        super.doStart();
    }

    @Override
    protected void doStop() throws Exception {
        super.doStop();
    }

    public boolean isStartScheduler() {
        return this.startScheduler;
    }

    public void setStartScheduler(boolean startScheduler) {
        this.startScheduler = startScheduler;
    }

    public long getInitialDelay() {
        return this.initialDelay;
    }

    public void setInitialDelay(long initialDelay) {
        this.initialDelay = initialDelay;
    }

    public long getDelay() {
        return this.delay;
    }

    public void setDelay(long delay) {
        this.delay = delay;
    }

    public TimeUnit getTimeUnit() {
        return this.timeUnit;
    }

    public void setTimeUnit(TimeUnit timeUnit) {
        this.timeUnit = timeUnit;
    }

    public boolean isUseFixedDelay() {
        return this.useFixedDelay;
    }

    public void setUseFixedDelay(boolean useFixedDelay) {
        this.useFixedDelay = useFixedDelay;
    }

    public PollingConsumerPollStrategy getPollStrategy() {
        return this.pollStrategy;
    }

    public void setPollStrategy(PollingConsumerPollStrategy pollStrategy) {
        this.pollStrategy = pollStrategy;
    }

    public LoggingLevel getRunLoggingLevel() {
        return this.runLoggingLevel;
    }

    public void setRunLoggingLevel(LoggingLevel runLoggingLevel) {
        this.runLoggingLevel = runLoggingLevel;
    }

    public boolean isSendEmptyMessageWhenIdle() {
        return this.sendEmptyMessageWhenIdle;
    }

    public void setSendEmptyMessageWhenIdle(boolean sendEmptyMessageWhenIdle) {
        this.sendEmptyMessageWhenIdle = sendEmptyMessageWhenIdle;
    }

    public boolean isGreedy() {
        return this.greedy;
    }

    public void setGreedy(boolean greedy) {
        this.greedy = greedy;
    }

    public ScheduledPollConsumerScheduler getScheduler() {
        return this.scheduler;
    }

    public void setScheduler(ScheduledPollConsumerScheduler scheduler) {
        this.scheduler = scheduler;
    }

    public void setScheduler(String schedulerName) {
        this.schedulerName = schedulerName;
    }

    public Map<String, Object> getSchedulerProperties() {
        return this.schedulerProperties;
    }

    public void setSchedulerProperties(Map<String, Object> schedulerProperties) {
        this.schedulerProperties = schedulerProperties;
    }

    public ScheduledExecutorService getScheduledExecutorService() {
        return this.scheduledExecutorService;
    }

    public void setScheduledExecutorService(ScheduledExecutorService scheduledExecutorService) {
        this.scheduledExecutorService = scheduledExecutorService;
    }

    public int getBackoffMultiplier() {
        return this.backoffMultiplier;
    }

    public void setBackoffMultiplier(int backoffMultiplier) {
        this.backoffMultiplier = backoffMultiplier;
    }

    public int getBackoffIdleThreshold() {
        return this.backoffIdleThreshold;
    }

    public void setBackoffIdleThreshold(int backoffIdleThreshold) {
        this.backoffIdleThreshold = backoffIdleThreshold;
    }

    public int getBackoffErrorThreshold() {
        return this.backoffErrorThreshold;
    }

    public void setBackoffErrorThreshold(int backoffErrorThreshold) {
        this.backoffErrorThreshold = backoffErrorThreshold;
    }
}

