/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.support;

import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.concurrent.Callable;
import java.util.stream.Stream;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.Ordered;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.TypeConverter;
import org.apache.camel.util.Scanner;
import org.apache.camel.util.StringHelper;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public final class ObjectHelper {
    private static final String DEFAULT_DELIMITER = ",";

    private ObjectHelper() {
    }

    public static boolean typeCoerceEquals(TypeConverter converter, Object leftValue, Object rightValue) {
        return ObjectHelper.typeCoerceEquals(converter, leftValue, rightValue, false);
    }

    public static boolean typeCoerceEquals(TypeConverter converter, Object leftValue, Object rightValue, boolean ignoreCase) {
        if (leftValue == null && rightValue == null) {
            return true;
        }
        if (leftValue == null || rightValue == null) {
            return false;
        }
        boolean answer = org.apache.camel.util.ObjectHelper.equal((Object)leftValue, (Object)rightValue, (boolean)ignoreCase);
        if (answer) {
            return true;
        }
        if (leftValue.getClass().isInstance(rightValue)) {
            return false;
        }
        Object value = converter.tryConvertTo(rightValue.getClass(), leftValue);
        answer = org.apache.camel.util.ObjectHelper.equal((Object)value, (Object)rightValue, (boolean)ignoreCase);
        if (answer) {
            return true;
        }
        value = converter.tryConvertTo(leftValue.getClass(), rightValue);
        answer = org.apache.camel.util.ObjectHelper.equal((Object)leftValue, (Object)value, (boolean)ignoreCase);
        return answer;
    }

    public static boolean typeCoerceNotEquals(TypeConverter converter, Object leftValue, Object rightValue) {
        return !ObjectHelper.typeCoerceEquals(converter, leftValue, rightValue);
    }

    public static int typeCoerceCompare(TypeConverter converter, Object leftValue, Object rightValue) {
        Object value;
        Long leftNum = (Long)converter.tryConvertTo(Long.class, leftValue);
        Long rightNum = (Long)converter.tryConvertTo(Long.class, rightValue);
        if (leftNum != null && rightNum != null) {
            return leftNum.compareTo(rightNum);
        }
        Double leftDouble = (Double)converter.tryConvertTo(Double.class, leftValue);
        Double rightDouble = (Double)converter.tryConvertTo(Double.class, rightValue);
        if (leftDouble != null && rightDouble != null) {
            return leftDouble.compareTo(rightDouble);
        }
        if (rightValue instanceof String && !(leftValue instanceof String)) {
            return ObjectHelper.typeCoerceCompare(converter, rightValue, leftValue) * -1;
        }
        if (rightValue instanceof Comparable && (value = converter.tryConvertTo(rightValue.getClass(), leftValue)) != null) {
            return ((Comparable)rightValue).compareTo(value) * -1;
        }
        if (leftValue instanceof Comparable && (value = converter.tryConvertTo(leftValue.getClass(), rightValue)) != null) {
            return ((Comparable)leftValue).compareTo(value);
        }
        return ObjectHelper.compare(leftValue, rightValue);
    }

    public static Object invokeMethod(Method method, Object instance, Object ... parameters) {
        try {
            if (parameters != null) {
                return method.invoke(instance, parameters);
            }
            return method.invoke(instance, new Object[0]);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeCamelException((Throwable)e);
        }
        catch (InvocationTargetException e) {
            throw RuntimeCamelException.wrapRuntimeCamelException((Throwable)e.getCause());
        }
    }

    public static Object invokeMethodSafe(Method method, Object instance, Object ... parameters) throws InvocationTargetException, IllegalAccessException {
        method.setAccessible(true);
        Object answer = parameters != null ? method.invoke(instance, parameters) : method.invoke(instance, new Object[0]);
        return answer;
    }

    public static <T> T newInstance(Class<T> type) {
        try {
            return type.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw new RuntimeCamelException((Throwable)e);
        }
    }

    public static <T> T newInstance(Class<?> actualType, Class<T> expectedType) {
        try {
            Object value = actualType.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            return (T)org.apache.camel.util.ObjectHelper.cast(expectedType, value);
        }
        catch (Exception e) {
            throw new RuntimeCamelException((Throwable)e);
        }
    }

    public static int compare(Object a, Object b) {
        return ObjectHelper.compare(a, b, false);
    }

    public static int compare(Object a, Object b, boolean ignoreCase) {
        if (a == b) {
            return 0;
        }
        if (a == null) {
            return -1;
        }
        if (b == null) {
            return 1;
        }
        if (a instanceof Ordered && b instanceof Ordered) {
            return ((Ordered)a).getOrder() - ((Ordered)b).getOrder();
        }
        if (ignoreCase && a instanceof String && b instanceof String) {
            return ((String)a).compareToIgnoreCase((String)b);
        }
        if (a instanceof Comparable) {
            Comparable comparable = (Comparable)a;
            return comparable.compareTo(b);
        }
        int answer = a.getClass().getName().compareTo(b.getClass().getName());
        if (answer == 0) {
            answer = a.hashCode() - b.hashCode();
        }
        return answer;
    }

    public static Object callWithTCCL(Callable<?> call, Exchange exchange) throws Exception {
        ClassLoader apcl = null;
        if (exchange != null && exchange.getContext() != null) {
            apcl = exchange.getContext().getApplicationContextClassLoader();
        }
        return ObjectHelper.callWithTCCL(call, apcl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object callWithTCCL(Callable<?> call, ClassLoader classloader) throws Exception {
        ClassLoader tccl = Thread.currentThread().getContextClassLoader();
        try {
            if (classloader != null) {
                Thread.currentThread().setContextClassLoader(classloader);
            }
            Object obj = call.call();
            return obj;
        }
        finally {
            Thread.currentThread().setContextClassLoader(tccl);
        }
    }

    public static Iterable<?> createIterable(Object value) {
        return ObjectHelper.createIterable(value, DEFAULT_DELIMITER);
    }

    public static Iterable<?> createIterable(Object value, String delimiter) {
        return ObjectHelper.createIterable(value, delimiter, false);
    }

    public static Iterable<String> createIterable(String value) {
        return ObjectHelper.createIterable(value, DEFAULT_DELIMITER);
    }

    public static Iterable<String> createIterable(String value, String delimiter) {
        return ObjectHelper.createIterable(value, delimiter, false);
    }

    public static Iterable<String> createIterable(String value, String delimiter, boolean allowEmptyValues) {
        return ObjectHelper.createIterable(value, delimiter, allowEmptyValues, false);
    }

    public static Iterable<String> createIterable(String value, String delimiter, boolean allowEmptyValues, boolean pattern) {
        if (value == null) {
            return Collections.emptyList();
        }
        if (delimiter != null && (pattern || value.contains(delimiter))) {
            String del = DEFAULT_DELIMITER.equals(delimiter) ? ",(?!(?:[^\\(,]|[^\\)],[^\\)])+\\))" : delimiter;
            return () -> new Scanner(value, del);
        }
        if (allowEmptyValues || org.apache.camel.util.ObjectHelper.isNotEmpty((Object)value)) {
            return Collections.singletonList(value);
        }
        return Collections.emptyList();
    }

    public static Iterator<?> createIterator(Object value) {
        return ObjectHelper.createIterator(value, DEFAULT_DELIMITER);
    }

    public static Iterator<?> createIterator(Object value, String delimiter) {
        return ObjectHelper.createIterator(value, delimiter, false);
    }

    public static Iterator<?> createIterator(Object value, String delimiter, boolean allowEmptyValues) {
        if (value instanceof Stream) {
            return ((Stream)value).iterator();
        }
        return ObjectHelper.createIterable(value, delimiter, allowEmptyValues, false).iterator();
    }

    public static Iterator<?> createIterator(Object value, String delimiter, boolean allowEmptyValues, boolean pattern) {
        if (value instanceof Stream) {
            return ((Stream)value).iterator();
        }
        return ObjectHelper.createIterable(value, delimiter, allowEmptyValues, pattern).iterator();
    }

    public static Iterable<?> createIterable(Object value, String delimiter, boolean allowEmptyValues) {
        return ObjectHelper.createIterable(value, delimiter, allowEmptyValues, false);
    }

    public static Iterable<?> createIterable(Object value, String delimiter, final boolean allowEmptyValues, boolean pattern) {
        if (value instanceof Message) {
            value = ((Message)value).getBody();
        }
        if (value == null) {
            return Collections.emptyList();
        }
        if (value instanceof Iterator) {
            final Iterator iterator = (Iterator)value;
            return new Iterable<Object>(){

                @Override
                public Iterator<Object> iterator() {
                    return iterator;
                }
            };
        }
        if (value instanceof Iterable) {
            return (Iterable)value;
        }
        if (value.getClass().isArray()) {
            if (org.apache.camel.util.ObjectHelper.isPrimitiveArrayType(value.getClass())) {
                final Object array = value;
                return () -> new Iterator<Object>(){
                    private int idx;

                    @Override
                    public boolean hasNext() {
                        return this.idx < Array.getLength(array);
                    }

                    @Override
                    public Object next() {
                        if (!this.hasNext()) {
                            throw new NoSuchElementException("no more element available for '" + array + "' at the index " + this.idx);
                        }
                        return Array.get(array, this.idx++);
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }
            return Arrays.asList((Object[])value);
        }
        if (value instanceof NodeList) {
            final NodeList nodeList = (NodeList)value;
            return () -> new Iterator<Node>(){
                private int idx;

                @Override
                public boolean hasNext() {
                    return this.idx < nodeList.getLength();
                }

                @Override
                public Node next() {
                    if (!this.hasNext()) {
                        throw new NoSuchElementException("no more element available for '" + nodeList + "' at the index " + this.idx);
                    }
                    return nodeList.item(this.idx++);
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        }
        if (value instanceof String) {
            final String s = (String)value;
            if (delimiter != null && (pattern || s.contains(delimiter))) {
                String del = DEFAULT_DELIMITER.equals(delimiter) ? ",(?!(?:[^\\(,]|[^\\)],[^\\)])+\\))" : delimiter;
                return () -> new Scanner(s, del);
            }
            return () -> new Iterator<Object>(){
                private int idx;

                @Override
                public boolean hasNext() {
                    return this.idx == 0 && (allowEmptyValues || org.apache.camel.util.ObjectHelper.isNotEmpty((Object)s));
                }

                @Override
                public Object next() {
                    if (!this.hasNext()) {
                        throw new NoSuchElementException("no more element available for '" + s + "' at the index " + this.idx);
                    }
                    ++this.idx;
                    return s;
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        }
        return Collections.singletonList(value);
    }

    public static boolean contains(Object collectionOrArray, Object value) {
        if (collectionOrArray != null && (collectionOrArray instanceof StringBuffer || collectionOrArray instanceof StringBuilder)) {
            collectionOrArray = collectionOrArray.toString();
        }
        if (value != null && (value instanceof StringBuffer || value instanceof StringBuilder)) {
            value = value.toString();
        }
        if (collectionOrArray instanceof Collection) {
            Collection collection = (Collection)collectionOrArray;
            return collection.contains(value);
        }
        if (collectionOrArray instanceof String && value instanceof String) {
            String str = (String)collectionOrArray;
            String subStr = (String)value;
            return str.contains(subStr);
        }
        Iterator<?> iter = ObjectHelper.createIterator(collectionOrArray);
        while (iter.hasNext()) {
            if (!org.apache.camel.util.ObjectHelper.equal((Object)value, iter.next())) continue;
            return true;
        }
        return false;
    }

    public static boolean containsIgnoreCase(Object collectionOrArray, Object value) {
        if (collectionOrArray != null && (collectionOrArray instanceof StringBuffer || collectionOrArray instanceof StringBuilder)) {
            collectionOrArray = collectionOrArray.toString();
        }
        if (value != null && (value instanceof StringBuffer || value instanceof StringBuilder)) {
            value = value.toString();
        }
        if (collectionOrArray instanceof Collection) {
            Collection collection = (Collection)collectionOrArray;
            return collection.contains(value);
        }
        if (collectionOrArray instanceof String && value instanceof String) {
            String str = (String)collectionOrArray;
            String subStr = (String)value;
            return StringHelper.containsIgnoreCase((String)str, (String)subStr);
        }
        Iterator<?> iter = ObjectHelper.createIterator(collectionOrArray);
        while (iter.hasNext()) {
            if (!org.apache.camel.util.ObjectHelper.equalIgnoreCase((Object)value, iter.next())) continue;
            return true;
        }
        return false;
    }
}

