/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.support.cache;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Function;
import org.apache.camel.Endpoint;
import org.apache.camel.NonManagedService;
import org.apache.camel.Service;
import org.apache.camel.support.LRUCache;
import org.apache.camel.support.LRUCacheFactory;
import org.apache.camel.support.service.ServiceSupport;
import org.apache.camel.util.function.ThrowingFunction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class ServicePool<S extends Service>
extends ServiceSupport
implements NonManagedService {
    private static final Logger LOG = LoggerFactory.getLogger(ServicePool.class);
    private final ThrowingFunction<Endpoint, S, Exception> creator;
    private final Function<S, Endpoint> getEndpoint;
    private final ConcurrentMap<Endpoint, Pool<S>> pool = new ConcurrentHashMap<Endpoint, Pool<S>>();
    private final ConcurrentMap<Endpoint, Pool<S>> singlePoolEvicted = new ConcurrentHashMap<Endpoint, Pool<S>>();
    private int capacity;
    private Map<S, S> cache;

    public ServicePool(ThrowingFunction<Endpoint, S, Exception> creator, Function<S, Endpoint> getEndpoint, int capacity) {
        this.creator = creator;
        this.getEndpoint = getEndpoint;
        this.capacity = capacity;
        this.cache = capacity > 0 ? LRUCacheFactory.newLRUCache(capacity, this::onEvict) : null;
    }

    protected void onEvict(S s) {
        Endpoint e = this.getEndpoint.apply(s);
        Pool p = (Pool)this.pool.get(e);
        if (p != null) {
            p.evict(s);
        } else {
            ServicePool.stop(s);
            try {
                e.getCamelContext().removeService(s);
            }
            catch (Exception ex) {
                LOG.debug("Error removing service: {}. This exception is ignored.", s, (Object)ex);
            }
        }
    }

    public S acquire(Endpoint endpoint) throws Exception {
        if (!this.isStarted()) {
            return null;
        }
        Service s = (Service)this.getOrCreatePool(endpoint).acquire();
        if (s != null && this.cache != null) {
            this.cache.putIfAbsent(s, s);
        }
        return (S)s;
    }

    public void release(Endpoint endpoint, S s) {
        Pool p = (Pool)this.pool.get(endpoint);
        if (p != null) {
            p.release(s);
        }
    }

    private Pool<S> getOrCreatePool(Endpoint endpoint) {
        Pool answer = (Pool)this.pool.get(endpoint);
        if (answer == null) {
            boolean singleton = endpoint.isSingletonProducer();
            answer = singleton ? this.pool.computeIfAbsent(endpoint, x$0 -> new SinglePool((Endpoint)x$0)) : this.pool.computeIfAbsent(endpoint, x$0 -> new MultiplePool((Endpoint)x$0));
        }
        return answer;
    }

    public int size() {
        return this.pool.values().stream().mapToInt(Pool::size).sum();
    }

    public void cleanUp() {
        if (this.cache instanceof LRUCache) {
            ((LRUCache)this.cache).cleanUp();
        }
        this.pool.values().forEach(Pool::cleanUp);
    }

    protected void doBuild() throws Exception {
        SinglePool dummy = new SinglePool();
        LOG.trace("Loaded {}", (Object)dummy.getClass().getName());
        MultiplePool dummy2 = new MultiplePool();
        LOG.trace("Loaded {}", (Object)dummy2.getClass().getName());
    }

    protected void doStart() throws Exception {
    }

    protected void doStop() throws Exception {
        this.cleanUp();
        this.pool.values().forEach(Pool::stop);
        this.pool.clear();
        if (this.cache != null) {
            this.cache.values().forEach(ServicePool::stop);
            this.cache.clear();
        }
        this.singlePoolEvicted.values().forEach(Pool::stop);
        this.singlePoolEvicted.clear();
    }

    private static <S extends Service> void stop(S s) {
        try {
            s.stop();
        }
        catch (Exception e) {
            LOG.debug("Error stopping service: {}. This exception is ignored.", s, (Object)e);
        }
    }

    private class MultiplePool
    implements Pool<S> {
        private final Object lock = new Object();
        private final Endpoint endpoint;
        private final BlockingQueue<S> queue;
        private final List<S> evicts;

        private MultiplePool() {
            this.endpoint = null;
            this.queue = null;
            this.evicts = null;
        }

        MultiplePool(Endpoint endpoint) {
            this.endpoint = endpoint;
            this.queue = new ArrayBlockingQueue(ServicePool.this.capacity);
            this.evicts = new ArrayList();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void cleanupEvicts() {
            if (!this.evicts.isEmpty()) {
                Object object = this.lock;
                synchronized (object) {
                    if (!this.evicts.isEmpty()) {
                        for (Service evict : this.evicts) {
                            this.doStop(evict);
                            this.queue.remove(evict);
                        }
                        this.evicts.clear();
                        if (this.queue.isEmpty()) {
                            ServicePool.this.pool.remove(this.endpoint);
                        }
                    }
                }
            }
        }

        @Override
        public S acquire() throws Exception {
            this.cleanupEvicts();
            Service s = (Service)this.queue.poll();
            if (s == null) {
                s = (Service)ServicePool.this.creator.apply((Object)this.endpoint);
                s.start();
            }
            return s;
        }

        @Override
        public void release(S s) {
            this.cleanupEvicts();
            if (!this.queue.offer(s)) {
                this.doStop((Service)s);
            }
        }

        @Override
        public int size() {
            return this.queue.size();
        }

        @Override
        public void stop() {
            this.queue.forEach(this::doStop);
            this.queue.clear();
            ServicePool.this.pool.remove(this.endpoint);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void evict(S s) {
            Object object = this.lock;
            synchronized (object) {
                this.evicts.add(s);
            }
        }

        @Override
        public void cleanUp() {
            this.cleanupEvicts();
        }

        void doStop(Service s) {
            if (s != null) {
                ServicePool.stop(s);
                try {
                    this.endpoint.getCamelContext().removeService((Object)s);
                }
                catch (Exception e) {
                    LOG.debug("Error removing service: {}. This exception is ignored.", (Object)s, (Object)e);
                }
            }
        }
    }

    private class SinglePool
    implements Pool<S> {
        private final Endpoint endpoint;
        private volatile S s;

        private SinglePool() {
            this.endpoint = null;
        }

        SinglePool(Endpoint endpoint) {
            this.endpoint = endpoint;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public S acquire() throws Exception {
            this.cleanupEvicts();
            if (this.s == null) {
                SinglePool singlePool = this;
                synchronized (singlePool) {
                    if (this.s == null) {
                        LOG.trace("Creating service from endpoint: {}", (Object)this.endpoint);
                        Service tempS = (Service)ServicePool.this.creator.apply((Object)this.endpoint);
                        this.endpoint.getCamelContext().addService((Object)tempS, true, true);
                        this.s = tempS;
                    }
                }
            }
            LOG.trace("Acquired service: {}", this.s);
            return this.s;
        }

        @Override
        public void release(S s) {
            this.cleanupEvicts();
            LOG.trace("Released service: {}", s);
        }

        @Override
        public int size() {
            return this.s != null ? 1 : 0;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void stop() {
            Object toStop;
            SinglePool singlePool = this;
            synchronized (singlePool) {
                toStop = this.s;
                this.s = null;
            }
            this.doStop((Service)toStop);
            ServicePool.this.pool.remove(this.endpoint);
        }

        @Override
        public void evict(S s) {
            ServicePool.this.singlePoolEvicted.putIfAbsent(this.endpoint, this);
        }

        @Override
        public void cleanUp() {
            this.cleanupEvicts();
        }

        private void cleanupEvicts() {
            if (!ServicePool.this.singlePoolEvicted.isEmpty()) {
                for (Map.Entry entry : ServicePool.this.singlePoolEvicted.entrySet()) {
                    Endpoint e = (Endpoint)entry.getKey();
                    Pool p = (Pool)entry.getValue();
                    this.doStop((Service)e);
                    p.stop();
                    ServicePool.this.singlePoolEvicted.remove(e);
                }
            }
        }

        void doStop(Service s) {
            if (s != null) {
                ServicePool.stop(s);
                try {
                    this.endpoint.getCamelContext().removeService((Object)s);
                }
                catch (Exception e) {
                    LOG.debug("Error removing service: {}. This exception is ignored.", (Object)s, (Object)e);
                }
            }
        }
    }

    private static interface Pool<S> {
        public S acquire() throws Exception;

        public void release(S var1);

        public int size();

        public void stop();

        public void evict(S var1);

        public void cleanUp();
    }
}

