/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.support.task;

import java.util.function.BooleanSupplier;
import java.util.function.Predicate;
import org.apache.camel.support.task.AbstractTaskBuilder;
import org.apache.camel.support.task.BlockingTask;
import org.apache.camel.support.task.budget.IterationBudget;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ForegroundTask
implements BlockingTask {
    private static final Logger LOG = LoggerFactory.getLogger(ForegroundTask.class);
    private final String name;
    private IterationBudget budget;

    ForegroundTask(IterationBudget budget, String name) {
        this.budget = budget;
        this.name = name;
    }

    @Override
    public <T> boolean run(Predicate<T> predicate, T payload) {
        boolean completed = false;
        try {
            if (this.budget.initialDelay() > 0L) {
                Thread.sleep(this.budget.initialDelay());
            }
            while (this.budget.next()) {
                if (predicate.test(payload)) {
                    LOG.info("Task {} is complete after {} iterations and it is ready to continue", (Object)this.name, (Object)this.budget.iterations());
                    completed = true;
                    break;
                }
                if (!this.budget.canContinue()) continue;
                Thread.sleep(this.budget.interval());
            }
        }
        catch (InterruptedException e) {
            LOG.warn("Interrupted {} while waiting for the repeatable task to execute", (Object)this.name);
            Thread.currentThread().interrupt();
        }
        return completed;
    }

    @Override
    public boolean run(BooleanSupplier supplier) {
        boolean completed = false;
        try {
            if (this.budget.initialDelay() > 0L) {
                Thread.sleep(this.budget.initialDelay());
            }
            while (this.budget.next()) {
                if (supplier.getAsBoolean()) {
                    LOG.info("Task {} is complete after {} iterations and it is ready to continue", (Object)this.name, (Object)this.budget.iterations());
                    completed = true;
                    break;
                }
                if (!this.budget.canContinue()) continue;
                Thread.sleep(this.budget.interval());
            }
        }
        catch (InterruptedException e) {
            LOG.warn("Interrupted {} while waiting for the repeatable task to execute", (Object)this.name);
            Thread.currentThread().interrupt();
        }
        return completed;
    }

    public static class ForegroundTaskBuilder
    extends AbstractTaskBuilder<ForegroundTask> {
        private IterationBudget budget;

        public ForegroundTaskBuilder withBudget(IterationBudget budget) {
            this.budget = budget;
            return this;
        }

        @Override
        public ForegroundTask build() {
            return new ForegroundTask(this.budget, this.getName());
        }
    }
}

