/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.support;

import java.util.concurrent.ConcurrentHashMap;
import org.apache.camel.CamelContext;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.ExchangePattern;
import org.apache.camel.Message;
import org.apache.camel.PooledExchange;
import org.apache.camel.support.AbstractExchange;
import org.apache.camel.support.DefaultMessage;

public final class DefaultPooledExchange
extends AbstractExchange
implements PooledExchange {
    private PooledExchange.OnDoneTask onDone;
    private Class<?> originalInClassType;
    private Message originalOut;
    private final ExchangePattern originalPattern;
    private boolean autoRelease;

    public DefaultPooledExchange(CamelContext context) {
        super(context);
        this.originalPattern = this.getPattern();
        this.properties = new ConcurrentHashMap(8);
    }

    public DefaultPooledExchange(CamelContext context, ExchangePattern pattern) {
        super(context, pattern);
        this.originalPattern = pattern;
        this.properties = new ConcurrentHashMap(8);
    }

    public DefaultPooledExchange(Exchange parent) {
        super(parent);
        this.originalPattern = parent.getPattern();
        this.properties = new ConcurrentHashMap(8);
    }

    public DefaultPooledExchange(Endpoint fromEndpoint) {
        super(fromEndpoint);
        this.originalPattern = this.getPattern();
        this.properties = new ConcurrentHashMap(8);
    }

    public DefaultPooledExchange(Endpoint fromEndpoint, ExchangePattern pattern) {
        super(fromEndpoint, pattern);
        this.originalPattern = pattern;
        this.properties = new ConcurrentHashMap(8);
    }

    public boolean isAutoRelease() {
        return this.autoRelease;
    }

    public void setAutoRelease(boolean autoRelease) {
        this.autoRelease = autoRelease;
    }

    public void onDone(PooledExchange.OnDoneTask task) {
        this.onDone = task;
    }

    public void done() {
        if (this.created > 0L) {
            this.created = 0L;
            this.properties.clear();
            System.arraycopy(EMPTY_INTERNAL_PROPERTIES, 0, this.internalProperties, 0, INTERNAL_LENGTH);
            if (this.safeCopyProperties != null) {
                this.safeCopyProperties.clear();
            }
            this.exchangeId = null;
            if (this.in != null && this.in.getClass() == this.originalInClassType) {
                this.in.reset();
            } else {
                this.in = null;
            }
            if (this.out != null) {
                this.out.reset();
                this.out = null;
            }
            if (this.unitOfWork != null) {
                this.unitOfWork.reset();
            }
            this.exception = null;
            this.pattern = this.originalPattern;
            if (this.onCompletions != null) {
                this.onCompletions.clear();
            }
            this.externalRedelivered = null;
            this.historyNodeId = null;
            this.historyNodeLabel = null;
            this.transacted = false;
            this.routeStop = false;
            this.rollbackOnly = false;
            this.rollbackOnlyLast = false;
            this.notifyEvent = false;
            this.interrupted = false;
            this.interruptable = true;
            this.redeliveryExhausted = false;
            this.errorHandlerHandled = null;
            if (this.onDone != null) {
                this.onDone.onDone((Exchange)this);
            }
        }
    }

    public void reset(long created) {
        this.created = created;
    }

    @Override
    public Message getIn() {
        if (this.in == null) {
            this.in = new DefaultMessage(this.getContext());
            this.originalInClassType = this.in.getClass();
            this.configureMessage(this.in);
        }
        return this.in;
    }

    @Override
    public void setIn(Message in) {
        this.in = in;
        this.configureMessage(in);
        if (in != null) {
            this.originalInClassType = in.getClass();
        }
    }

    @Override
    public Message getOut() {
        if (this.out == null) {
            if (this.originalOut != null) {
                this.out = this.originalOut;
            } else {
                this.out = new DefaultMessage((Exchange)this);
                this.configureMessage(this.out);
                this.originalOut = this.out;
            }
        }
        return this.out;
    }

    @Override
    public void setOut(Message out) {
        this.out = out;
        if (out != null) {
            this.configureMessage(out);
            this.originalOut = null;
        }
    }
}

