/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.support.resume;

import org.apache.camel.resume.Offset;
import org.apache.camel.resume.Resumable;
import org.apache.camel.support.resume.Offsets;

public final class Resumables {
    private Resumables() {
    }

    public static <K, V> Resumable<K, V> of(K addressable, V offset) {
        return new AnonymousResumable<K, V>(addressable, offset);
    }

    private static class AnonymousResumable<K, V>
    implements Resumable<K, V> {
        private final K addressable;
        private V offset;

        public AnonymousResumable(K addressable) {
            this.addressable = addressable;
        }

        public AnonymousResumable(K addressable, V offset) {
            this.addressable = addressable;
            this.offset = offset;
        }

        public void updateLastOffset(V offset) {
            this.offset = offset;
        }

        public Offset<V> getLastOffset() {
            return Offsets.of(this.offset);
        }

        public K getAddressable() {
            return this.addressable;
        }
    }
}

