/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.support.cache;

import java.time.Duration;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.RejectedExecutionException;
import org.apache.camel.AsyncCallback;
import org.apache.camel.AsyncProcessor;
import org.apache.camel.AsyncProducer;
import org.apache.camel.CamelContext;
import org.apache.camel.Endpoint;
import org.apache.camel.EndpointAware;
import org.apache.camel.Exchange;
import org.apache.camel.ExchangePattern;
import org.apache.camel.ExchangePropertyKey;
import org.apache.camel.ExtendedCamelContext;
import org.apache.camel.FailedToCreateProducerException;
import org.apache.camel.Processor;
import org.apache.camel.Service;
import org.apache.camel.StatefulService;
import org.apache.camel.spi.EndpointUtilizationStatistics;
import org.apache.camel.spi.ProducerCache;
import org.apache.camel.spi.SharedInternalProcessor;
import org.apache.camel.support.CamelContextHelper;
import org.apache.camel.support.DefaultEndpointUtilizationStatistics;
import org.apache.camel.support.EventHelper;
import org.apache.camel.support.cache.EventNotifierCallback;
import org.apache.camel.support.cache.ProducerServicePool;
import org.apache.camel.support.service.ServiceHelper;
import org.apache.camel.support.service.ServiceSupport;
import org.apache.camel.support.task.ForegroundTask;
import org.apache.camel.support.task.Tasks;
import org.apache.camel.support.task.budget.Budgets;
import org.apache.camel.util.StopWatch;
import org.apache.camel.util.function.ThrowingFunction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultProducerCache
extends ServiceSupport
implements ProducerCache {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultProducerCache.class);
    private static final long ACQUIRE_WAIT_TIME = 30000L;
    private final ExtendedCamelContext camelContext;
    private final ProducerServicePool producers;
    private final Object source;
    private final SharedInternalProcessor sharedInternalProcessor;
    private EndpointUtilizationStatistics statistics;
    private boolean eventNotifierEnabled = true;
    private boolean extendedStatistics;
    private int maxCacheSize;

    public DefaultProducerCache(Object source, CamelContext camelContext, int cacheSize) {
        this.source = source;
        this.camelContext = (ExtendedCamelContext)camelContext;
        this.maxCacheSize = cacheSize <= 0 ? CamelContextHelper.getMaximumCachePoolSize(camelContext) : cacheSize;
        this.producers = cacheSize >= 0 ? this.createServicePool(camelContext, this.maxCacheSize) : null;
        this.extendedStatistics = camelContext.getManagementStrategy() != null && camelContext.getManagementStrategy().getManagementAgent() != null ? camelContext.getManagementStrategy().getManagementAgent().getStatisticsLevel().isExtended() : false;
        this.sharedInternalProcessor = this.camelContext.getInternalProcessorFactory().createSharedCamelInternalProcessor((CamelContext)this.camelContext);
    }

    protected ProducerServicePool createServicePool(CamelContext camelContext, int cacheSize) {
        return new ProducerServicePool((ThrowingFunction<Endpoint, AsyncProducer, Exception>)((ThrowingFunction)Endpoint::createAsyncProducer), EndpointAware::getEndpoint, cacheSize);
    }

    public boolean isEventNotifierEnabled() {
        return this.eventNotifierEnabled;
    }

    public void setEventNotifierEnabled(boolean eventNotifierEnabled) {
        this.eventNotifierEnabled = eventNotifierEnabled;
    }

    public boolean isExtendedStatistics() {
        return this.extendedStatistics;
    }

    public void setExtendedStatistics(boolean extendedStatistics) {
        this.extendedStatistics = extendedStatistics;
    }

    public CamelContext getCamelContext() {
        return this.camelContext;
    }

    public Object getSource() {
        return this.source;
    }

    private void waitForService(StatefulService service) {
        ForegroundTask task = Tasks.foregroundTask().withBudget(Budgets.iterationTimeBudget().withMaxIterations(-1).withMaxDuration(Duration.ofMillis(30000L)).withInterval(Duration.ofMillis(5L)).build()).build();
        if (!task.run(() -> ((StatefulService)service).isStarting())) {
            LOG.warn("The producer: {} did not finish starting in {} ms", (Object)service, (Object)30000L);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Waited {} ms for producer to finish starting: {} state: {}", new Object[]{task.elapsed().toMillis(), service, service.getStatus()});
        }
    }

    public AsyncProducer acquireProducer(Endpoint endpoint) {
        try {
            StatefulService ss;
            AsyncProducer producer = (AsyncProducer)this.producers.acquire(endpoint);
            if (this.statistics != null) {
                this.statistics.onHit(endpoint.getEndpointUri());
            }
            if (producer instanceof StatefulService && (ss = (StatefulService)producer).isStarting()) {
                LOG.trace("Waiting for producer to finish starting: {}", (Object)producer);
                this.waitForService(ss);
            }
            return producer;
        }
        catch (Throwable e) {
            throw new FailedToCreateProducerException(endpoint, e);
        }
    }

    public void releaseProducer(Endpoint endpoint, AsyncProducer producer) {
        this.producers.release(endpoint, (Service)producer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Exchange send(Endpoint endpoint, Exchange exchange, Processor resultProcessor) {
        if (this.camelContext.isStopped()) {
            exchange.setException((Throwable)new RejectedExecutionException("CamelContext is stopped"));
            return exchange;
        }
        AsyncProducer producer = this.acquireProducer(endpoint);
        try {
            LOG.debug(">>>> {} {}", (Object)endpoint, (Object)exchange);
            exchange.setProperty(ExchangePropertyKey.TO_ENDPOINT, (Object)endpoint.getEndpointUri());
            StopWatch watch = null;
            try {
                boolean sending;
                if (this.eventNotifierEnabled && this.camelContext.isEventNotificationApplicable() && (sending = EventHelper.notifyExchangeSending(exchange.getContext(), exchange, endpoint))) {
                    watch = new StopWatch();
                }
                this.sharedInternalProcessor.process(exchange, (AsyncProcessor)producer, resultProcessor);
            }
            catch (Throwable e) {
                exchange.setException(e);
            }
            finally {
                if (watch != null) {
                    long timeTaken = watch.taken();
                    EventHelper.notifyExchangeSent(exchange.getContext(), exchange, endpoint, timeTaken);
                }
            }
            Exchange exchange2 = exchange;
            return exchange2;
        }
        finally {
            this.releaseProducer(endpoint, producer);
        }
    }

    @Deprecated
    public CompletableFuture<Exchange> asyncSend(Endpoint endpoint, ExchangePattern pattern, Processor processor, Processor resultProcessor, CompletableFuture<Exchange> future) {
        return this.asyncSendExchange(endpoint, pattern, processor, resultProcessor, null, future);
    }

    public CompletableFuture<Exchange> asyncSendExchange(Endpoint endpoint, ExchangePattern pattern, Processor processor, Processor resultProcessor, Exchange exchange, CompletableFuture<Exchange> future) {
        if (exchange == null) {
            exchange = pattern != null ? endpoint.createExchange(pattern) : endpoint.createExchange();
        }
        return this.doAsyncSendExchange(endpoint, processor, resultProcessor, exchange, future);
    }

    protected CompletableFuture<Exchange> doAsyncSendExchange(Endpoint endpoint, Processor processor, Processor resultProcessor, Exchange exchange, CompletableFuture<Exchange> f) {
        CompletableFuture<Exchange> future = f != null ? f : new CompletableFuture<Exchange>();
        ProducerCache.AsyncProducerCallback cb = (p, e, c) -> this.asyncDispatchExchange(endpoint, p, resultProcessor, e, c);
        try {
            if (processor instanceof AsyncProcessor) {
                ((AsyncProcessor)processor).process(exchange, doneSync -> this.doInAsyncProducer(endpoint, exchange, ds -> future.complete(exchange), cb));
            } else {
                if (processor != null) {
                    processor.process(exchange);
                }
                this.doInAsyncProducer(endpoint, exchange, ds -> future.complete(exchange), cb);
            }
        }
        catch (Throwable e2) {
            exchange.setException(e2);
            future.complete(exchange);
        }
        return future;
    }

    public boolean doInAsyncProducer(Endpoint endpoint, Exchange exchange, AsyncCallback callback, ProducerCache.AsyncProducerCallback producerCallback) {
        AsyncProducer producer;
        try {
            producer = this.acquireProducer(endpoint);
            if (producer == null) {
                if (this.isStopped()) {
                    LOG.warn("Ignoring exchange sent after processor is stopped: {}", (Object)exchange);
                    callback.done(true);
                    return true;
                }
                exchange.setException((Throwable)new IllegalStateException("No producer, this processor has not been started: " + this));
                callback.done(true);
                return true;
            }
        }
        catch (Throwable e) {
            exchange.setException(e);
            callback.done(true);
            return true;
        }
        try {
            boolean sending;
            StopWatch watch = this.eventNotifierEnabled && this.camelContext.isEventNotificationApplicable() ? ((sending = EventHelper.notifyExchangeSending(exchange.getContext(), exchange, endpoint)) ? new StopWatch() : null) : null;
            return producerCallback.doInAsyncProducer(producer, exchange, doneSync -> {
                try {
                    if (watch != null) {
                        long timeTaken = watch.taken();
                        EventHelper.notifyExchangeSent(exchange.getContext(), exchange, endpoint, timeTaken);
                    }
                    this.releaseProducer(endpoint, producer);
                }
                finally {
                    callback.done(doneSync);
                }
            });
        }
        catch (Throwable e) {
            if (exchange != null) {
                exchange.setException(e);
            }
            callback.done(true);
            return true;
        }
    }

    protected boolean asyncDispatchExchange(Endpoint endpoint, AsyncProducer producer, Processor resultProcessor, Exchange exchange, AsyncCallback callback) {
        LOG.debug(">>>> {} {}", (Object)endpoint, (Object)exchange);
        exchange.setProperty(ExchangePropertyKey.TO_ENDPOINT, (Object)endpoint.getEndpointUri());
        try {
            if (this.eventNotifierEnabled && this.camelContext.isEventNotificationApplicable()) {
                callback = new EventNotifierCallback(callback, exchange, endpoint);
            }
            return this.sharedInternalProcessor.process(exchange, callback, (AsyncProcessor)producer, resultProcessor);
        }
        catch (Throwable e) {
            exchange.setException(e);
            callback.done(true);
            return true;
        }
    }

    protected void doBuild() throws Exception {
        ServiceHelper.buildService((Object)((Object)this.producers));
    }

    protected void doInit() throws Exception {
        if (this.extendedStatistics) {
            int max = this.maxCacheSize == 0 ? CamelContextHelper.getMaximumCachePoolSize((CamelContext)this.camelContext) : this.maxCacheSize;
            this.statistics = new DefaultEndpointUtilizationStatistics(max);
        }
        ServiceHelper.initService((Object)((Object)this.producers));
    }

    protected void doStart() throws Exception {
        if (this.statistics != null) {
            this.statistics.clear();
        }
        ServiceHelper.startService((Object)((Object)this.producers));
    }

    protected void doStop() throws Exception {
        ServiceHelper.stopService((Object)((Object)this.producers));
    }

    protected void doShutdown() throws Exception {
        ServiceHelper.stopAndShutdownServices((Object[])new Object[]{this.producers});
    }

    public int size() {
        int size = this.producers != null ? this.producers.size() : 0;
        LOG.trace("size = {}", (Object)size);
        return size;
    }

    public int getCapacity() {
        return this.maxCacheSize;
    }

    public synchronized void purge() {
        try {
            if (this.producers != null) {
                this.producers.stop();
                this.producers.start();
            }
        }
        catch (Exception e) {
            LOG.debug("Error restarting producers", (Throwable)e);
        }
        if (this.statistics != null) {
            this.statistics.clear();
        }
    }

    public void cleanUp() {
        if (this.producers != null) {
            this.producers.cleanUp();
        }
    }

    public EndpointUtilizationStatistics getEndpointUtilizationStatistics() {
        return this.statistics;
    }

    public String toString() {
        return "ProducerCache for source: " + this.source + ", capacity: " + this.getCapacity();
    }
}

