/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.camel.converter.stream;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.OutputStream;

import org.apache.camel.Exchange;
import org.apache.camel.StreamCache;

/**
 * A {@link StreamCache} for caching using an in-memory byte array.
 *
 * @see StreamCache
 */
public final class InputStreamCache extends ByteArrayInputStream implements StreamCache {

    public InputStreamCache(byte[] data) {
        super(data);
    }

    public InputStreamCache(byte[] data, int count) {
        super(data);
        super.count = count;
    }

    @Override
    public void writeTo(OutputStream os) throws IOException {
        os.write(buf, pos, count - pos);
    }

    @Override
    public StreamCache copy(Exchange exchange) {
        return new InputStreamCache(buf, count);
    }

    @Override
    public boolean inMemory() {
        return true;
    }

    @Override
    public long length() {
        return count;
    }
}
