/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.support;

import org.apache.camel.AsyncCallback;
import org.apache.camel.AsyncProducer;
import org.apache.camel.DelegateProcessor;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.support.AsyncProcessorConverterHelper;
import org.apache.camel.support.DefaultAsyncProducer;
import org.apache.camel.support.service.ServiceHelper;

public final class LazyStartProducer
extends DefaultAsyncProducer
implements DelegateProcessor {
    private volatile AsyncProducer delegate;

    public LazyStartProducer(Endpoint endpoint) {
        super(endpoint);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean process(Exchange exchange, AsyncCallback callback) {
        block7: {
            try {
                if (this.delegate != null) break block7;
                Object object = this.lock;
                synchronized (object) {
                    if (this.delegate == null) {
                        this.delegate = AsyncProcessorConverterHelper.convert(this.getEndpoint().createProducer());
                    }
                    if (!ServiceHelper.isStarted((Object)this.delegate)) {
                        ServiceHelper.startService((Object)this.delegate);
                    }
                }
            }
            catch (Throwable e) {
                exchange.setException(e);
                callback.done(true);
                return true;
            }
        }
        return this.delegate.process(exchange, callback);
    }

    @Override
    public boolean isSingleton() {
        if (this.delegate != null) {
            return this.delegate.isSingleton();
        }
        return this.getEndpoint().isSingleton();
    }

    protected void doInit() throws Exception {
    }

    @Override
    protected void doStart() throws Exception {
    }

    @Override
    protected void doStop() throws Exception {
        ServiceHelper.stopService((Object)this.delegate);
    }

    protected void doSuspend() throws Exception {
        ServiceHelper.suspendService((Object)this.delegate);
    }

    protected void doResume() throws Exception {
        ServiceHelper.resumeService((Object)this.delegate);
    }

    protected void doShutdown() throws Exception {
        ServiceHelper.stopAndShutdownService((Object)this.delegate);
    }

    public Processor getProcessor() {
        return this.delegate;
    }
}

