/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.support;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelExecutionException;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.ExchangePattern;
import org.apache.camel.ExchangePropertyKey;
import org.apache.camel.Message;
import org.apache.camel.SafeCopyProperty;
import org.apache.camel.spi.HeadersMapFactory;
import org.apache.camel.spi.UnitOfWork;
import org.apache.camel.support.DefaultExchange;
import org.apache.camel.support.DefaultMessage;
import org.apache.camel.support.ExchangeHelper;
import org.apache.camel.support.ExtendedExchangeExtension;
import org.apache.camel.support.MessageHelper;
import org.apache.camel.support.MessageSupport;
import org.apache.camel.support.PatternHelper;
import org.apache.camel.util.ObjectHelper;

class AbstractExchange
implements Exchange {
    protected static final int INTERNAL_LENGTH = ExchangePropertyKey.values().length;
    protected static final Object[] EMPTY_INTERNAL_PROPERTIES = new Object[INTERNAL_LENGTH];
    protected final CamelContext context;
    protected Map<String, Object> properties;
    protected final Object[] internalProperties = new Object[INTERNAL_LENGTH];
    protected long created;
    protected Message in;
    protected Message out;
    protected Exception exception;
    protected String exchangeId;
    protected ExchangePattern pattern;
    protected Boolean externalRedelivered;
    protected boolean routeStop;
    protected boolean rollbackOnly;
    protected boolean rollbackOnlyLast;
    protected Map<String, SafeCopyProperty> safeCopyProperties;
    private final ExtendedExchangeExtension privateExtension;

    public AbstractExchange(CamelContext context) {
        this(context, ExchangePattern.InOnly);
    }

    public AbstractExchange(CamelContext context, ExchangePattern pattern) {
        this.context = context;
        this.pattern = pattern;
        this.created = System.currentTimeMillis();
        this.privateExtension = new ExtendedExchangeExtension(this);
    }

    public AbstractExchange(Exchange parent) {
        this.context = parent.getContext();
        this.pattern = parent.getPattern();
        this.created = parent.getCreated();
        this.privateExtension = new ExtendedExchangeExtension(this);
        this.privateExtension.setFromEndpoint(parent.getFromEndpoint());
        this.privateExtension.setFromRouteId(parent.getFromRouteId());
        this.privateExtension.setUnitOfWork(parent.getUnitOfWork());
    }

    public AbstractExchange(Endpoint fromEndpoint) {
        this.context = fromEndpoint.getCamelContext();
        this.pattern = fromEndpoint.getExchangePattern();
        this.created = System.currentTimeMillis();
        this.privateExtension = new ExtendedExchangeExtension(this);
        this.privateExtension.setFromEndpoint(fromEndpoint);
    }

    public AbstractExchange(Endpoint fromEndpoint, ExchangePattern pattern) {
        this.context = fromEndpoint.getCamelContext();
        this.pattern = pattern;
        this.created = System.currentTimeMillis();
        this.privateExtension = new ExtendedExchangeExtension(this);
        this.privateExtension.setFromEndpoint(fromEndpoint);
    }

    public long getCreated() {
        return this.created;
    }

    public Exchange copy() {
        List history;
        DefaultExchange exchange = new DefaultExchange(this);
        exchange.setIn(this.getIn().copy());
        MessageHelper.copyBody(this.getIn(), exchange.getIn());
        if (this.getIn().hasHeaders()) {
            exchange.getIn().setHeaders(this.safeCopyHeaders(this.getIn().getHeaders()));
        }
        if (this.hasOut()) {
            exchange.setOut(this.getOut().copy());
            MessageHelper.copyBody(this.getOut(), exchange.getOut());
            if (this.getOut().hasHeaders()) {
                exchange.getOut().setHeaders(this.safeCopyHeaders(this.getOut().getHeaders()));
            }
        }
        exchange.setException(this.exception);
        exchange.setRouteStop(this.routeStop);
        exchange.setRollbackOnly(this.rollbackOnly);
        exchange.setRollbackOnlyLast(this.rollbackOnlyLast);
        ExtendedExchangeExtension newExchangeExtension = exchange.getExchangeExtension();
        newExchangeExtension.setNotifyEvent(this.getExchangeExtension().isNotifyEvent());
        newExchangeExtension.setRedeliveryExhausted(this.getExchangeExtension().isRedeliveryExhausted());
        newExchangeExtension.setErrorHandlerHandled(this.getExchangeExtension().getErrorHandlerHandled());
        newExchangeExtension.setStreamCacheDisabled(this.getExchangeExtension().isStreamCacheDisabled());
        if (this.hasProperties()) {
            this.copyProperties(this.getProperties(), exchange.getProperties());
        }
        if (this.hasSafeCopyProperties()) {
            this.safeCopyProperties(this.safeCopyProperties, exchange.getSafeCopyProperties());
        }
        System.arraycopy(this.internalProperties, 0, exchange.internalProperties, 0, this.internalProperties.length);
        if (this.getContext().isMessageHistory().booleanValue() && (history = (List)exchange.internalProperties[ExchangePropertyKey.MESSAGE_HISTORY.ordinal()]) != null) {
            exchange.internalProperties[ExchangePropertyKey.MESSAGE_HISTORY.ordinal()] = new CopyOnWriteArrayList(history);
        }
        return exchange;
    }

    private Map<String, Object> safeCopyHeaders(Map<String, Object> headers) {
        HeadersMapFactory factory;
        if (headers == null) {
            return null;
        }
        if (this.context != null && (factory = this.context.getCamelContextExtension().getHeadersMapFactory()) != null) {
            return factory.newMap(headers);
        }
        return new HashMap<String, Object>(headers);
    }

    private void copyProperties(Map<String, Object> source, Map<String, Object> target) {
        target.putAll(source);
    }

    private void safeCopyProperties(Map<String, SafeCopyProperty> source, Map<String, SafeCopyProperty> target) {
        source.entrySet().stream().forEach(entry -> target.put((String)entry.getKey(), ((SafeCopyProperty)entry.getValue()).safeCopy()));
    }

    public CamelContext getContext() {
        return this.context;
    }

    public Object getProperty(ExchangePropertyKey key) {
        return this.internalProperties[key.ordinal()];
    }

    public <T> T getProperty(ExchangePropertyKey key, Class<T> type) {
        Object value = this.getProperty(key);
        if (value == null) {
            if (Boolean.TYPE == type) {
                return (T)Boolean.FALSE;
            }
            return null;
        }
        if (type.isInstance(value)) {
            return (T)value;
        }
        return ExchangeHelper.convertToType(this, type, value);
    }

    public <T> T getProperty(ExchangePropertyKey key, Object defaultValue, Class<T> type) {
        Object value = this.getProperty(key);
        if (value == null) {
            value = defaultValue;
        }
        if (value == null) {
            if (Boolean.TYPE == type) {
                return (T)Boolean.FALSE;
            }
            return null;
        }
        if (type.isInstance(value)) {
            return (T)value;
        }
        return ExchangeHelper.convertToType(this, type, value);
    }

    public void setProperty(ExchangePropertyKey key, Object value) {
        this.internalProperties[key.ordinal()] = value;
    }

    public Object removeProperty(ExchangePropertyKey key) {
        Object old = this.internalProperties[key.ordinal()];
        this.internalProperties[key.ordinal()] = null;
        return old;
    }

    public Object getProperty(String name) {
        Object answer = null;
        ExchangePropertyKey key = ExchangePropertyKey.asExchangePropertyKey((String)name);
        if (key != null) {
            answer = this.internalProperties[key.ordinal()];
        }
        if (answer == null && this.properties != null) {
            answer = this.properties.get(name);
        }
        return answer;
    }

    public <T> T getProperty(String name, Class<T> type) {
        Object value = this.getProperty(name);
        if (value == null) {
            if (Boolean.TYPE == type) {
                return (T)Boolean.FALSE;
            }
            return null;
        }
        if (type.isInstance(value)) {
            return (T)value;
        }
        return ExchangeHelper.convertToType(this, type, value);
    }

    public <T> T getProperty(String name, Object defaultValue, Class<T> type) {
        Object value = this.getProperty(name);
        if (value == null) {
            value = defaultValue;
        }
        if (value == null) {
            if (Boolean.TYPE == type) {
                return (T)Boolean.FALSE;
            }
            return null;
        }
        if (type.isInstance(value)) {
            return (T)value;
        }
        return ExchangeHelper.convertToType(this, type, value);
    }

    public void setProperty(String name, Object value) {
        ExchangePropertyKey key = ExchangePropertyKey.asExchangePropertyKey((String)name);
        if (key != null) {
            this.setProperty(key, value);
        } else if (value != null) {
            if (this.properties == null) {
                this.properties = new ConcurrentHashMap<String, Object>(8);
            }
            this.properties.put(name, value);
        } else if (this.properties != null) {
            this.properties.remove(name);
        }
    }

    void setProperties(Map<String, Object> properties) {
        if (this.properties == null) {
            this.properties = new ConcurrentHashMap<String, Object>(8);
        } else {
            this.properties.clear();
        }
        this.properties.putAll(properties);
    }

    public Object removeProperty(String name) {
        ExchangePropertyKey key = ExchangePropertyKey.asExchangePropertyKey((String)name);
        if (key != null) {
            return this.removeProperty(key);
        }
        if (!this.hasProperties()) {
            return null;
        }
        return this.properties.remove(name);
    }

    public boolean removeProperties(String pattern) {
        return this.removeProperties(pattern, null);
    }

    public boolean removeProperties(String pattern, String ... excludePatterns) {
        if (excludePatterns == null && "*".equals(pattern)) {
            if (this.properties != null) {
                this.properties.clear();
            }
            System.arraycopy(EMPTY_INTERNAL_PROPERTIES, 0, this.internalProperties, 0, INTERNAL_LENGTH);
            return true;
        }
        boolean matches = false;
        for (ExchangePropertyKey epk : ExchangePropertyKey.values()) {
            String key = epk.getName();
            if (!PatternHelper.matchPattern(key, pattern) || excludePatterns != null && PatternHelper.isExcludePatternMatch(key, excludePatterns)) continue;
            matches = true;
            this.internalProperties[epk.ordinal()] = null;
        }
        if (this.properties != null) {
            HashSet<String> toBeRemoved = null;
            for (String key : this.properties.keySet()) {
                if (!PatternHelper.matchPattern(key, pattern) || excludePatterns != null && PatternHelper.isExcludePatternMatch(key, excludePatterns)) continue;
                matches = true;
                if (toBeRemoved == null) {
                    toBeRemoved = new HashSet<String>();
                }
                toBeRemoved.add(key);
            }
            if (matches && toBeRemoved != null) {
                if (toBeRemoved.size() == this.properties.size()) {
                    this.properties.clear();
                } else {
                    for (String key : toBeRemoved) {
                        this.properties.remove(key);
                    }
                }
            }
        }
        return matches;
    }

    public Map<String, Object> getProperties() {
        if (this.properties == null) {
            this.properties = new ConcurrentHashMap<String, Object>(8);
        }
        return this.properties;
    }

    Map<String, SafeCopyProperty> getSafeCopyProperties() {
        if (this.safeCopyProperties == null) {
            this.safeCopyProperties = new ConcurrentHashMap<String, SafeCopyProperty>(2);
        }
        return this.safeCopyProperties;
    }

    public Map<String, Object> getAllProperties() {
        Map<String, Object> map = this.getInternalProperties();
        if (this.properties != null && !this.properties.isEmpty()) {
            map.putAll(this.properties);
        }
        return map;
    }

    public boolean hasProperties() {
        return this.properties != null && !this.properties.isEmpty();
    }

    private boolean hasSafeCopyProperties() {
        return this.safeCopyProperties != null && !this.safeCopyProperties.isEmpty();
    }

    public Message getIn() {
        if (this.in == null) {
            this.in = new DefaultMessage(this.getContext());
            this.configureMessage(this.in);
        }
        return this.in;
    }

    public <T> T getIn(Class<T> type) {
        Message in = this.getIn();
        if (type.isInstance(in)) {
            return type.cast(in);
        }
        return (T)this.context.getTypeConverter().convertTo(type, (Exchange)this, (Object)in);
    }

    <T> T getInOrNull(Class<T> type) {
        if (this.in == null) {
            return null;
        }
        if (type.isInstance(this.in)) {
            return type.cast(this.in);
        }
        return null;
    }

    public void setIn(Message in) {
        this.in = in;
        this.configureMessage(in);
    }

    public Message getOut() {
        if (this.out == null) {
            this.out = this.in instanceof MessageSupport ? ((MessageSupport)this.in).newInstance() : new DefaultMessage(this.getContext());
            this.configureMessage(this.out);
        }
        return this.out;
    }

    public <T> T getOut(Class<T> type) {
        if (!this.hasOut()) {
            return null;
        }
        Message out = this.getOut();
        if (type.isInstance(out)) {
            return type.cast(out);
        }
        return (T)this.context.getTypeConverter().convertTo(type, (Exchange)this, (Object)out);
    }

    public boolean hasOut() {
        return this.out != null;
    }

    public void setOut(Message out) {
        this.out = out;
        this.configureMessage(out);
    }

    public Message getMessage() {
        return this.hasOut() ? this.getOut() : this.getIn();
    }

    public <T> T getMessage(Class<T> type) {
        return this.hasOut() ? this.getOut(type) : this.getIn(type);
    }

    public void setMessage(Message message) {
        if (this.hasOut()) {
            this.setOut(message);
        } else {
            this.setIn(message);
        }
    }

    public Exception getException() {
        return this.exception;
    }

    public <T> T getException(Class<T> type) {
        return (T)ObjectHelper.getException(type, (Throwable)this.exception);
    }

    public void setException(Throwable t) {
        this.exception = t == null ? null : (t instanceof Exception ? (Exception)t : CamelExecutionException.wrapCamelExecutionException((Exchange)this, (Throwable)t));
        if (t instanceof InterruptedException) {
            this.privateExtension.setInterrupted(true);
        }
    }

    public ExchangePattern getPattern() {
        return this.pattern;
    }

    public void setPattern(ExchangePattern pattern) {
        this.pattern = pattern;
    }

    public Endpoint getFromEndpoint() {
        return this.privateExtension.getFromEndpoint();
    }

    public String getFromRouteId() {
        return this.privateExtension.getFromRouteId();
    }

    public String getExchangeId() {
        if (this.exchangeId == null) {
            this.exchangeId = this.createExchangeId();
        }
        return this.exchangeId;
    }

    public void setExchangeId(String id) {
        this.exchangeId = id;
    }

    public boolean isFailed() {
        return this.exception != null;
    }

    public boolean isTransacted() {
        return this.privateExtension.isTransacted();
    }

    public boolean isRouteStop() {
        return this.routeStop;
    }

    public void setRouteStop(boolean routeStop) {
        this.routeStop = routeStop;
    }

    public boolean isExternalRedelivered() {
        if (this.externalRedelivered == null) {
            Message msg = this.getIn();
            if (msg instanceof DefaultMessage) {
                this.externalRedelivered = ((DefaultMessage)msg).isTransactedRedelivered();
            }
            if (this.externalRedelivered == null) {
                this.externalRedelivered = false;
            }
        }
        return this.externalRedelivered;
    }

    public boolean isRollbackOnly() {
        return this.rollbackOnly;
    }

    public void setRollbackOnly(boolean rollbackOnly) {
        this.rollbackOnly = rollbackOnly;
    }

    public boolean isRollbackOnlyLast() {
        return this.rollbackOnlyLast;
    }

    public void setRollbackOnlyLast(boolean rollbackOnlyLast) {
        this.rollbackOnlyLast = rollbackOnlyLast;
    }

    public UnitOfWork getUnitOfWork() {
        return this.privateExtension.getUnitOfWork();
    }

    protected void configureMessage(Message message) {
        if (message instanceof MessageSupport) {
            MessageSupport messageSupport = (MessageSupport)message;
            messageSupport.setExchange(this);
            messageSupport.setCamelContext(this.getContext());
        }
    }

    void copyInternalProperties(Exchange target) {
        AbstractExchange ae = (AbstractExchange)target;
        System.arraycopy(this.internalProperties, 0, ae.internalProperties, 0, INTERNAL_LENGTH);
    }

    Map<String, Object> getInternalProperties() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        for (ExchangePropertyKey key : ExchangePropertyKey.values()) {
            Object value = this.internalProperties[key.ordinal()];
            if (value == null) continue;
            map.put(key.getName(), value);
        }
        return map;
    }

    protected String createExchangeId() {
        return this.context.getUuidGenerator().generateExchangeUuid();
    }

    public String toString() {
        if (this.exchangeId != null) {
            return "Exchange[" + this.exchangeId + "]";
        }
        return "Exchange[]";
    }

    void setSafeCopyProperty(String key, SafeCopyProperty value) {
        if (value != null) {
            if (this.safeCopyProperties == null) {
                this.safeCopyProperties = new ConcurrentHashMap<String, SafeCopyProperty>(2);
            }
            this.safeCopyProperties.put(key, value);
        } else if (this.safeCopyProperties != null) {
            this.safeCopyProperties.remove(key);
        }
    }

    <T> T getSafeCopyProperty(String key, Class<T> type) {
        if (!this.hasSafeCopyProperties()) {
            return null;
        }
        SafeCopyProperty value = this.getSafeCopyProperties().get(key);
        if (type.isInstance(value)) {
            return (T)value;
        }
        return ExchangeHelper.convertToType(this, type, value);
    }

    public ExtendedExchangeExtension getExchangeExtension() {
        return this.privateExtension;
    }
}

