/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.support;

import java.io.Closeable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.function.Supplier;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelContextAware;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.spi.BeanRepository;
import org.apache.camel.spi.LocalBeanRepositoryAware;
import org.apache.camel.spi.Registry;
import org.apache.camel.support.ObjectHelper;
import org.apache.camel.support.SimpleRegistry;
import org.apache.camel.support.SupplierRegistry;
import org.apache.camel.support.service.ServiceHelper;
import org.apache.camel.support.service.ServiceSupport;
import org.apache.camel.util.IOHelper;
import org.apache.camel.util.KeyValueHolder;
import org.apache.camel.util.function.Suppliers;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultRegistry
extends ServiceSupport
implements Registry,
LocalBeanRepositoryAware,
CamelContextAware {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultRegistry.class);
    protected CamelContext camelContext;
    protected final Stack<BeanRepository> localRepository = new Stack();
    protected List<BeanRepository> repositories;
    protected Registry fallbackRegistry = new SimpleRegistry();
    protected Registry supplierRegistry = new SupplierRegistry();
    protected final Map<String, KeyValueHolder<Object, String>> beansToDestroy = new LinkedHashMap<String, KeyValueHolder<Object, String>>();

    public DefaultRegistry() {
    }

    public DefaultRegistry(BeanRepository ... repositories) {
        if (repositories != null) {
            this.repositories = new ArrayList<BeanRepository>(Arrays.asList(repositories));
        }
    }

    public DefaultRegistry(Collection<BeanRepository> repositories) {
        if (repositories != null) {
            this.repositories = new ArrayList<BeanRepository>(repositories);
        }
    }

    public void setLocalBeanRepository(BeanRepository repository) {
        BeanRepository old;
        if (repository != null) {
            this.localRepository.push(repository);
        } else if (!this.localRepository.isEmpty() && (old = this.localRepository.pop()) != null) {
            ServiceHelper.stopService((Object)old);
        }
    }

    public BeanRepository getLocalBeanRepository() {
        if (this.localRepository.isEmpty()) {
            return null;
        }
        return this.localRepository.peek();
    }

    public Registry getFallbackRegistry() {
        return this.fallbackRegistry;
    }

    public void setFallbackRegistry(Registry fallbackRegistry) {
        this.fallbackRegistry = fallbackRegistry;
    }

    public Registry getSupplierRegistry() {
        return this.supplierRegistry;
    }

    public void setSupplierRegistry(Registry supplierRegistry) {
        this.supplierRegistry = supplierRegistry;
    }

    public CamelContext getCamelContext() {
        return this.camelContext;
    }

    public void setCamelContext(CamelContext camelContext) {
        this.camelContext = camelContext;
    }

    public List<BeanRepository> getRepositories() {
        if (this.repositories == null) {
            return null;
        }
        return Collections.unmodifiableList(this.repositories);
    }

    public void addBeanRepository(BeanRepository repository) {
        if (repository == null) {
            this.repositories = new ArrayList<BeanRepository>();
        }
        this.repositories.add(repository);
    }

    public void bind(String id, Class<?> type, Object bean) throws RuntimeCamelException {
        this.bind(id, type, bean, null, null);
    }

    public void bind(String id, Class<?> type, Object bean, String initMethod, String destroyMethod) throws RuntimeCamelException {
        if (bean != null) {
            CamelContextAware.trySetCamelContext((Object)bean, (CamelContext)this.camelContext);
            if (org.apache.camel.util.ObjectHelper.isNotEmpty((String)initMethod)) {
                try {
                    ObjectHelper.invokeMethodSafe(initMethod, bean, new Object[0]);
                }
                catch (Exception e) {
                    throw RuntimeCamelException.wrapRuntimeCamelException((Throwable)e);
                }
            }
            this.fallbackRegistry.bind(id, type, bean);
            if (org.apache.camel.util.ObjectHelper.isNotEmpty((String)destroyMethod)) {
                this.beansToDestroy.put(id, (KeyValueHolder<Object, String>)new KeyValueHolder(bean, (Object)destroyMethod));
            }
        }
    }

    public void bind(String id, Class<?> type, Supplier<Object> bean) throws RuntimeCamelException {
        if (bean != null) {
            this.supplierRegistry.bind(id, type, Suppliers.memorize(bean));
        }
    }

    public void bindAsPrototype(String id, Class<?> type, Supplier<Object> bean) throws RuntimeCamelException {
        if (bean != null) {
            this.supplierRegistry.bind(id, type, bean);
        }
    }

    public void unbind(String id) {
        this.supplierRegistry.unbind(id);
        this.fallbackRegistry.unbind(id);
        this.destroyBean(id, true);
    }

    protected void destroyBean(String name, boolean remove) {
        KeyValueHolder<Object, String> holder;
        KeyValueHolder<Object, String> keyValueHolder = holder = remove ? this.beansToDestroy.remove(name) : this.beansToDestroy.get(name);
        if (holder != null) {
            String destroyMethod = (String)holder.getValue();
            Object target = holder.getKey();
            try {
                ObjectHelper.invokeMethodSafe(destroyMethod, target, new Object[0]);
            }
            catch (Exception e) {
                LOG.warn("Error invoking destroy method: {} on bean: {} due to: {}. This exception is ignored.", new Object[]{destroyMethod, target, e.getMessage(), e});
            }
        }
    }

    public Object lookupByName(String name) {
        Object answer;
        try {
            if (this.camelContext != null && !name.equals("properties")) {
                name = this.camelContext.resolvePropertyPlaceholders(name);
            }
        }
        catch (Exception e) {
            throw RuntimeCamelException.wrapRuntimeCamelException((Throwable)e);
        }
        BeanRepository local = this.getLocalBeanRepository();
        if (local != null && (answer = local.lookupByName(name)) != null) {
            return this.unwrap(answer);
        }
        if (this.repositories != null) {
            for (BeanRepository r : this.repositories) {
                answer = r.lookupByName(name);
                if (answer == null) continue;
                return this.unwrap(answer);
            }
        }
        if ((answer = this.supplierRegistry.lookupByName(name)) == null) {
            answer = this.fallbackRegistry.lookupByName(name);
        }
        if (answer != null) {
            answer = this.unwrap(answer);
        }
        return answer;
    }

    public <T> T lookupByNameAndType(String name, Class<T> type) {
        Object answer;
        try {
            if (this.camelContext != null && !name.equals("properties")) {
                name = this.camelContext.resolvePropertyPlaceholders(name);
            }
        }
        catch (Exception e) {
            throw RuntimeCamelException.wrapRuntimeCamelException((Throwable)e);
        }
        BeanRepository local = this.getLocalBeanRepository();
        if (local != null && (answer = local.lookupByNameAndType(name, type)) != null) {
            return (T)this.unwrap(answer);
        }
        if (this.repositories != null) {
            for (BeanRepository r : this.repositories) {
                answer = r.lookupByNameAndType(name, type);
                if (answer == null) continue;
                return (T)this.unwrap(answer);
            }
        }
        if ((answer = this.supplierRegistry.lookupByNameAndType(name, type)) == null) {
            answer = this.fallbackRegistry.lookupByNameAndType(name, type);
        }
        if (answer != null) {
            answer = this.unwrap(answer);
        }
        return (T)answer;
    }

    public <T> Map<String, T> findByTypeWithName(Class<T> type) {
        Object found;
        LinkedHashMap answer = new LinkedHashMap();
        BeanRepository local = this.getLocalBeanRepository();
        if (local != null && (found = local.findByTypeWithName(type)) != null && !found.isEmpty()) {
            answer.putAll(found);
        }
        if (this.repositories != null) {
            found = this.repositories.iterator();
            while (found.hasNext()) {
                BeanRepository r = (BeanRepository)found.next();
                Map found2 = r.findByTypeWithName(type);
                if (found2 == null || found2.isEmpty()) continue;
                answer.putAll(found2);
            }
        }
        if ((found = this.supplierRegistry.findByTypeWithName(type)) != null && !found.isEmpty()) {
            answer.putAll(found);
        }
        if ((found = this.fallbackRegistry.findByTypeWithName(type)) != null && !found.isEmpty()) {
            answer.putAll(found);
        }
        return answer;
    }

    public <T> Set<T> findByType(Class<T> type) {
        Object found;
        LinkedHashSet answer = new LinkedHashSet();
        BeanRepository local = this.getLocalBeanRepository();
        if (local != null && (found = local.findByType(type)) != null && !found.isEmpty()) {
            answer.addAll(found);
        }
        if (this.repositories != null) {
            found = this.repositories.iterator();
            while (found.hasNext()) {
                BeanRepository r = (BeanRepository)found.next();
                Set found2 = r.findByType(type);
                if (found2 == null || found2.isEmpty()) continue;
                answer.addAll(found2);
            }
        }
        if ((found = this.supplierRegistry.findByType(type)) != null && !found.isEmpty()) {
            answer.addAll(found);
        }
        if ((found = this.fallbackRegistry.findByType(type)) != null && !found.isEmpty()) {
            answer.addAll(found);
        }
        return answer;
    }

    public <T> T findSingleByType(Class<T> type) {
        Object found = null;
        BeanRepository local = this.getLocalBeanRepository();
        if (local != null) {
            found = local.findSingleByType(type);
        }
        if (found == null && this.repositories != null) {
            BeanRepository r;
            Iterator<BeanRepository> iterator = this.repositories.iterator();
            while (iterator.hasNext() && (found = (r = iterator.next()).findSingleByType(type)) == null) {
            }
        }
        if (found == null) {
            found = this.supplierRegistry.findSingleByType(type);
        }
        if (found == null) {
            found = this.fallbackRegistry.findSingleByType(type);
        }
        return (T)found;
    }

    protected void doStop() throws Exception {
        Closeable closeable;
        super.doStop();
        Registry registry = this.supplierRegistry;
        if (registry instanceof Closeable) {
            closeable = (Closeable)registry;
            IOHelper.close((Closeable)closeable);
        }
        if ((registry = this.fallbackRegistry) instanceof Closeable) {
            closeable = (Closeable)registry;
            IOHelper.close((Closeable)closeable);
        }
        ServiceHelper.stopAndShutdownServices((Object[])new Object[]{this.supplierRegistry, this.fallbackRegistry});
        for (String name : this.beansToDestroy.keySet()) {
            this.destroyBean(name, false);
        }
        this.beansToDestroy.clear();
    }
}

