/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.support;

import java.util.Comparator;
import org.apache.camel.Ordered;

public final class OrderedComparator
implements Comparator<Object> {
    private static final OrderedComparator INSTANCE = new OrderedComparator();
    private static final OrderedComparator INSTANCE_REVERSE = new OrderedComparator(true);
    private final boolean reverse;

    public OrderedComparator() {
        this(false);
    }

    public OrderedComparator(boolean reverse) {
        this.reverse = reverse;
    }

    public static OrderedComparator get() {
        return INSTANCE;
    }

    public static OrderedComparator getReverse() {
        return INSTANCE_REVERSE;
    }

    @Override
    public int compare(Object o1, Object o2) {
        int num1 = 0;
        int num2 = 0;
        if (o1 instanceof Ordered) {
            Ordered ordered1 = (Ordered)o1;
            num1 = ordered1.getOrder();
        }
        if (o2 instanceof Ordered) {
            Ordered ordered2 = (Ordered)o2;
            num2 = ordered2.getOrder();
        }
        int answer = Integer.compare(num1, num2);
        return this.reverse ? -1 * answer : answer;
    }
}

