/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.support.scan;

import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import org.apache.camel.CamelContextAware;
import org.apache.camel.NonManagedService;
import org.apache.camel.spi.PackageScanResourceResolver;
import org.apache.camel.spi.Resource;
import org.apache.camel.spi.ResourceLoader;
import org.apache.camel.support.PluginHelper;
import org.apache.camel.support.ResourceHelper;
import org.apache.camel.support.scan.BasePackageScanResolver;
import org.apache.camel.support.scan.PackageScanJarResource;
import org.apache.camel.util.AntPathMatcher;
import org.apache.camel.util.IOHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultPackageScanResourceResolver
extends BasePackageScanResolver
implements PackageScanResourceResolver,
NonManagedService,
CamelContextAware {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultPackageScanResourceResolver.class);
    private static final AntPathMatcher PATH_MATCHER = AntPathMatcher.INSTANCE;

    public Collection<Resource> findResources(String location) throws Exception {
        HashSet<Resource> answer = new HashSet<Resource>();
        this.doFindResources(location, answer);
        return answer;
    }

    protected void doFindResources(String location, Set<Resource> resources) throws Exception {
        if (PATH_MATCHER.isPattern(location)) {
            String root = PATH_MATCHER.determineRootDir(location);
            String subPattern = location.substring(root.length());
            String scheme = ResourceHelper.getScheme(location);
            if ("file:".equals(scheme)) {
                root = root.substring(scheme.length());
                this.findInFileSystem(new File(root), resources, subPattern);
            } else {
                if ("classpath:".equals(scheme)) {
                    root = root.substring(scheme.length());
                }
                this.findInClasspath(root, resources, subPattern);
            }
        } else {
            ResourceLoader loader = PluginHelper.getResourceLoader(this.getCamelContext());
            resources.add(loader.resolveResource(location));
        }
    }

    protected void findInFileSystem(File dir, Set<Resource> resources, String subPattern) throws Exception {
        ResourceLoader loader = PluginHelper.getResourceLoader(this.getCamelContext());
        for (Path path : ResourceHelper.findInFileSystem(dir.toPath(), subPattern)) {
            resources.add(loader.resolveResource("file:" + path.toString()));
        }
    }

    protected void findInClasspath(String packageName, Set<Resource> resources, String subPattern) {
        if (!((String)(packageName = ".".equals(packageName) ? "" : ((String)packageName).replace('.', '/'))).isEmpty() && !((String)packageName).endsWith("/")) {
            packageName = (String)packageName + "/";
        }
        Set<ClassLoader> set = this.getClassLoaders();
        for (ClassLoader classLoader : set) {
            this.doFind((String)packageName, classLoader, resources, subPattern);
        }
    }

    protected void doFind(String packageName, ClassLoader classLoader, Set<Resource> resources, String subPattern) {
        Enumeration<URL> urls = this.getUrls(packageName, classLoader);
        if (urls == null) {
            return;
        }
        while (urls.hasMoreElements()) {
            URL url = null;
            try {
                InputStream stream;
                url = urls.nextElement();
                LOG.trace("URL from classloader: {}", (Object)url);
                url = this.customResourceLocator(url);
                String urlPath = this.parseUrlPath(url);
                if (urlPath == null) continue;
                LOG.trace("Scanning for resources in: {} matching pattern: {}", (Object)urlPath, (Object)subPattern);
                File file = new File(urlPath);
                if (file.isDirectory()) {
                    LOG.trace("Loading from directory using file: {}", (Object)file);
                    this.loadImplementationsInDirectory(subPattern, packageName, file, resources);
                    continue;
                }
                if (urlPath.startsWith("http:") || urlPath.startsWith("https:") || urlPath.startsWith("sonicfs:") || this.isAcceptableScheme(urlPath)) {
                    LOG.trace("Loading from jar using url: {}", (Object)urlPath);
                    URL urlStream = new URL(urlPath);
                    URLConnection con = urlStream.openConnection();
                    con.setUseCaches(false);
                    stream = con.getInputStream();
                } else {
                    LOG.trace("Loading from jar using file: {}", (Object)file);
                    stream = new FileInputStream(file);
                }
                this.loadImplementationsInJar(url, packageName, subPattern, stream, urlPath, resources);
            }
            catch (IOException e) {
                LOG.debug("Cannot read entries in url: {}", (Object)url, (Object)e);
            }
        }
    }

    protected void loadImplementationsInJar(URL url, String packageName, String subPattern, InputStream stream, String urlPath, Set<Resource> resources) {
        List<String> entries = this.doLoadImplementationsInJar(packageName, stream, urlPath);
        for (String name : entries) {
            String shortName = name.substring(packageName.length());
            boolean match = PATH_MATCHER.match(subPattern, shortName);
            LOG.debug("Found resource: {} matching pattern: {} -> {}", new Object[]{shortName, subPattern, match});
            if (!match) continue;
            PackageScanJarResource resource = new PackageScanJarResource("jar", url, name);
            resources.add(resource);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<String> doLoadImplementationsInJar(String packageName, InputStream stream, String urlPath) {
        ArrayList<String> entries = new ArrayList<String>();
        JarInputStream jarStream = null;
        try {
            JarEntry entry;
            jarStream = new JarInputStream(stream);
            while ((entry = jarStream.getNextJarEntry()) != null) {
                String name = entry.getName().trim();
                if (entry.isDirectory() || name.endsWith(".class") || !name.startsWith(packageName)) continue;
                entries.add(name);
            }
        }
        catch (IOException ioe) {
            LOG.warn("Cannot search jar file '{} due to an IOException: {}", new Object[]{urlPath, ioe.getMessage(), ioe});
        }
        finally {
            IOHelper.close((Closeable)jarStream, (String)urlPath, (Logger)LOG);
        }
        return entries;
    }

    private void loadImplementationsInDirectory(String subPattern, String parent, File location, Set<Resource> resources) {
        File[] files = location.listFiles();
        if (files == null || files.length == 0) {
            return;
        }
        for (File file : files) {
            String packageOrClass;
            StringBuilder builder = new StringBuilder(100);
            String name = file.getName();
            name = name.trim();
            builder.append(parent).append("/").append(name);
            String string = packageOrClass = parent == null ? name : builder.toString();
            if (file.isDirectory()) {
                this.loadImplementationsInDirectory(subPattern, packageOrClass, file, resources);
                continue;
            }
            if (!file.isFile() || !file.exists() || name.endsWith(".class")) continue;
            boolean match = PATH_MATCHER.match(subPattern, name);
            LOG.debug("Found resource: {} matching pattern: {} -> {}", new Object[]{name, subPattern, match});
            if (!match) continue;
            ResourceLoader loader = PluginHelper.getResourceLoader(this.getCamelContext());
            resources.add(loader.resolveResource("file:" + file.getPath()));
        }
    }
}

