/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.swagger;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import io.swagger.jaxrs.config.BeanConfig;
import io.swagger.models.Contact;
import io.swagger.models.Info;
import io.swagger.models.License;
import io.swagger.models.Scheme;
import io.swagger.models.Swagger;
import io.swagger.util.Json;
import io.swagger.util.Yaml;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.lang.management.ManagementFactory;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.management.AttributeNotFoundException;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.camel.CamelContext;
import org.apache.camel.NamedNode;
import org.apache.camel.model.ModelCamelContext;
import org.apache.camel.model.ModelHelper;
import org.apache.camel.model.rest.RestDefinition;
import org.apache.camel.model.rest.RestsDefinition;
import org.apache.camel.spi.ClassResolver;
import org.apache.camel.spi.RestConfiguration;
import org.apache.camel.support.PatternHelper;
import org.apache.camel.swagger.RestApiResponseAdapter;
import org.apache.camel.swagger.RestSwaggerReader;
import org.apache.camel.swagger.SwaggerHelper;
import org.apache.camel.util.CamelVersionHelper;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.URISupport;
import org.apache.camel.util.XmlLineNumberParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;

public class RestSwaggerSupport {
    static final String HEADER_X_FORWARDED_PREFIX = "X-Forwarded-Prefix";
    static final String HEADER_X_FORWARDED_HOST = "X-Forwarded-Host";
    static final String HEADER_X_FORWARDED_PROTO = "X-Forwarded-Proto";
    static final String HEADER_HOST = "Host";
    private static final Logger LOG = LoggerFactory.getLogger(RestSwaggerSupport.class);
    private RestSwaggerReader reader = new RestSwaggerReader();
    private boolean cors;

    public void initSwagger(BeanConfig swaggerConfig, Map<String, Object> config) {
        String s = (String)config.get("swagger.version");
        if (s != null) {
            swaggerConfig.setVersion(s);
        }
        if ((s = (String)config.get("base.path")) != null) {
            swaggerConfig.setBasePath(s);
        }
        if ((s = (String)config.get("host")) != null) {
            swaggerConfig.setHost(s);
        }
        if ((s = (String)config.get("cors")) != null) {
            this.cors = "true".equalsIgnoreCase(s);
        }
        if ((s = (String)config.get("schemes")) == null) {
            s = (String)config.get("schemas");
        }
        if (s != null) {
            String[] schemes = s.split(",");
            swaggerConfig.setSchemes(schemes);
        } else {
            swaggerConfig.setSchemes(new String[]{"http"});
        }
        String version = (String)config.get("api.version");
        String title = (String)config.get("api.title");
        String description = (String)config.get("api.description");
        String termsOfService = (String)config.get("api.termsOfService");
        String licenseName = (String)config.get("api.license.name");
        String licenseUrl = (String)config.get("api.license.url");
        String contactName = (String)config.get("api.contact.name");
        String contactUrl = (String)config.get("api.contact.url");
        String contactEmail = (String)config.get("api.contact.email");
        Info info = new Info();
        info.setVersion(version);
        info.setTitle(title);
        info.setDescription(description);
        info.setTermsOfService(termsOfService);
        if (licenseName != null || licenseUrl != null) {
            License license = new License();
            license.setName(licenseName);
            license.setUrl(licenseUrl);
            info.setLicense(license);
        }
        if (contactName != null || contactUrl != null || contactEmail != null) {
            Contact contact = new Contact();
            contact.setName(contactName);
            contact.setUrl(contactUrl);
            contact.setEmail(contactEmail);
            info.setContact(contact);
        }
        swaggerConfig.setInfo(info);
    }

    public List<RestDefinition> getRestDefinitions(CamelContext camelContext) throws Exception {
        RestsDefinition model;
        final ModelCamelContext context = (ModelCamelContext)camelContext.adapt(ModelCamelContext.class);
        List rests = context.getRestDefinitions();
        if (rests.isEmpty()) {
            return null;
        }
        RestsDefinition def = new RestsDefinition();
        def.setRests(rests);
        String xml = ModelHelper.dumpModelAsXml((CamelContext)context, (NamedNode)def);
        final AtomicBoolean changed = new AtomicBoolean();
        ByteArrayInputStream is = new ByteArrayInputStream(xml.getBytes(StandardCharsets.UTF_8));
        Document dom = XmlLineNumberParser.parseXml((InputStream)is, (XmlLineNumberParser.XmlTextTransformer)new XmlLineNumberParser.XmlTextTransformer(){

            public String transform(String text) {
                try {
                    String after = context.resolvePropertyPlaceholders(text);
                    if (!changed.get()) {
                        changed.set(!text.equals(after));
                    }
                    return after;
                }
                catch (Exception e) {
                    return text;
                }
            }
        });
        if (changed.get() && (model = (RestsDefinition)ModelHelper.createModelFromXml((CamelContext)context, (String)(xml = (String)context.getTypeConverter().mandatoryConvertTo(String.class, (Object)dom)), RestsDefinition.class)) != null) {
            return model.getRests();
        }
        return rests;
    }

    public List<RestDefinition> getRestDefinitions(String camelId) throws Exception {
        String xml;
        ObjectName found = null;
        boolean supportResolvePlaceholder = false;
        MBeanServer server = ManagementFactory.getPlatformMBeanServer();
        Set<ObjectName> names = server.queryNames(new ObjectName("org.apache.camel:type=context,*"), null);
        for (ObjectName on : names) {
            String id = on.getKeyProperty("name");
            if (id.startsWith("\"") && id.endsWith("\"")) {
                id = id.substring(1, id.length() - 1);
            }
            if (camelId != null && !camelId.equals(id)) continue;
            String version = (String)server.getAttribute(on, "CamelVersion");
            if (CamelVersionHelper.isGE((String)"2.15.0", (String)version)) {
                found = on;
            }
            if (!CamelVersionHelper.isGE((String)"2.15.3", (String)version)) continue;
            supportResolvePlaceholder = true;
        }
        if (found != null && (xml = supportResolvePlaceholder ? (String)server.invoke(found, "dumpRestsAsXml", new Object[]{true}, new String[]{"boolean"}) : (String)server.invoke(found, "dumpRestsAsXml", null, null)) != null) {
            LOG.debug("DumpRestAsXml:\n{}", (Object)xml);
            RestsDefinition rests = (RestsDefinition)ModelHelper.createModelFromXml(null, (String)xml, RestsDefinition.class);
            if (rests != null) {
                return rests.getRests();
            }
        }
        return null;
    }

    public List<String> findCamelContexts() throws Exception {
        ArrayList<String> answer = new ArrayList<String>();
        MBeanServer server = ManagementFactory.getPlatformMBeanServer();
        Set<ObjectName> names = server.queryNames(new ObjectName("*:type=context,*"), null);
        for (ObjectName on : names) {
            String id = on.getKeyProperty("name");
            if (id.startsWith("\"") && id.endsWith("\"")) {
                id = id.substring(1, id.length() - 1);
            }
            try {
                String version = (String)server.getAttribute(on, "CamelVersion");
                if (!CamelVersionHelper.isGE((String)"2.15.0", (String)version)) continue;
                answer.add(id);
            }
            catch (AttributeNotFoundException attributeNotFoundException) {}
        }
        return answer;
    }

    public void renderResourceListing(CamelContext camelContext, RestApiResponseAdapter response, BeanConfig swaggerConfig, String contextId, String route, boolean json, boolean yaml, Map<String, Object> headers, ClassResolver classResolver, RestConfiguration configuration) throws Exception {
        LOG.trace("renderResourceListing");
        if (this.cors) {
            RestSwaggerSupport.setupCorsHeaders(response, configuration.getCorsHeaders());
        }
        List<RestDefinition> rests = null;
        rests = camelContext != null && camelContext.getName().equals(contextId) ? this.getRestDefinitions(camelContext) : this.getRestDefinitions(contextId);
        if (rests != null) {
            Map apiProperties;
            Map map = apiProperties = configuration.getApiProperties() != null ? configuration.getApiProperties() : new HashMap();
            if (json) {
                response.setHeader("Content-Type", apiProperties.getOrDefault("api.specification.contentType.json", "application/json"));
                Swagger swagger = this.reader.read(rests, route, swaggerConfig, contextId, classResolver);
                if (configuration.isUseXForwardHeaders()) {
                    RestSwaggerSupport.setupXForwardedHeaders(swagger, headers);
                }
                if (!configuration.isApiVendorExtension()) {
                    SwaggerHelper.clearVendorExtensions(swagger);
                }
                ObjectMapper mapper = Json.mapper();
                mapper.enable(SerializationFeature.INDENT_OUTPUT);
                mapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
                byte[] bytes = mapper.writeValueAsBytes((Object)swagger);
                int len = bytes.length;
                response.setHeader("Content-Length", "" + len);
                response.writeBytes(bytes);
            } else {
                response.setHeader("Content-Type", apiProperties.getOrDefault("api.specification.contentType.yaml", "text/yaml"));
                Swagger swagger = this.reader.read(rests, route, swaggerConfig, contextId, classResolver);
                if (configuration.isUseXForwardHeaders()) {
                    RestSwaggerSupport.setupXForwardedHeaders(swagger, headers);
                }
                if (!configuration.isApiVendorExtension()) {
                    SwaggerHelper.clearVendorExtensions(swagger);
                }
                ObjectMapper mapper = Yaml.mapper();
                mapper.enable(SerializationFeature.INDENT_OUTPUT);
                mapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
                byte[] jsonData = mapper.writeValueAsBytes((Object)swagger);
                JsonNode node = mapper.readTree(jsonData);
                byte[] bytes = Yaml.mapper().writerWithDefaultPrettyPrinter().writeValueAsBytes((Object)node);
                int len = bytes.length;
                response.setHeader("Content-Length", "" + len);
                response.writeBytes(bytes);
            }
        } else {
            response.noContent();
        }
    }

    public void renderCamelContexts(RestApiResponseAdapter response, String contextId, String contextIdPattern, boolean json, boolean yaml, RestConfiguration configuration) throws Exception {
        int i;
        LOG.trace("renderCamelContexts");
        if (this.cors) {
            RestSwaggerSupport.setupCorsHeaders(response, configuration.getCorsHeaders());
        }
        List<String> contexts = this.findCamelContexts();
        if (contextIdPattern != null) {
            Iterator<String> it = contexts.iterator();
            while (it.hasNext()) {
                String name = it.next();
                boolean match = "#name#".equals(contextIdPattern) ? name.equals(contextId) : PatternHelper.matchPattern((String)name, (String)contextIdPattern);
                if (match) continue;
                it.remove();
            }
        }
        StringBuffer sb = new StringBuffer();
        if (json) {
            response.setHeader("Content-Type", "application/json");
            sb.append("[\n");
            for (i = 0; i < contexts.size(); ++i) {
                String name = contexts.get(i);
                sb.append("{\"name\": \"").append(name).append("\"}");
                if (i >= contexts.size() - 1) continue;
                sb.append(",\n");
            }
            sb.append("\n]");
        } else {
            response.setHeader("Content-Type", "text/yaml");
            for (i = 0; i < contexts.size(); ++i) {
                String name = contexts.get(i);
                sb.append("- \"").append(name).append("\"\n");
            }
        }
        int len = sb.length();
        response.setHeader("Content-Length", "" + len);
        response.writeBytes(sb.toString().getBytes());
    }

    private static void setupCorsHeaders(RestApiResponseAdapter response, Map<String, String> corsHeaders) {
        String maxAge;
        String allowHeaders;
        String allowMethods;
        String allowOrigin;
        String string = allowOrigin = corsHeaders != null ? corsHeaders.get("Access-Control-Allow-Origin") : null;
        if (allowOrigin == null) {
            allowOrigin = "*";
        }
        String string2 = allowMethods = corsHeaders != null ? corsHeaders.get("Access-Control-Allow-Methods") : null;
        if (allowMethods == null) {
            allowMethods = "GET, HEAD, POST, PUT, DELETE, TRACE, OPTIONS, CONNECT, PATCH";
        }
        String string3 = allowHeaders = corsHeaders != null ? corsHeaders.get("Access-Control-Allow-Headers") : null;
        if (allowHeaders == null) {
            allowHeaders = "Origin, Accept, X-Requested-With, Content-Type, Access-Control-Request-Method, Access-Control-Request-Headers";
        }
        String string4 = maxAge = corsHeaders != null ? corsHeaders.get("Access-Control-Max-Age") : null;
        if (maxAge == null) {
            maxAge = "3600";
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace("Using CORS headers[");
            LOG.trace("  Access-Control-Allow-Origin={}", (Object)allowOrigin);
            LOG.trace("  Access-Control-Allow-Methods={}", (Object)allowMethods);
            LOG.trace("  Access-Control-Allow-Headers={}", (Object)allowHeaders);
            LOG.trace("  Access-Control-Max-Age={}", (Object)maxAge);
            LOG.trace("]");
        }
        response.setHeader("Access-Control-Allow-Origin", allowOrigin);
        response.setHeader("Access-Control-Allow-Methods", allowMethods);
        response.setHeader("Access-Control-Allow-Headers", allowHeaders);
        response.setHeader("Access-Control-Max-Age", maxAge);
    }

    static void setupXForwardedHeaders(Swagger swagger, Map<String, Object> headers) {
        String proto;
        String forwardedHost;
        String forwardedPrefix;
        String host = (String)headers.get(HEADER_HOST);
        if (ObjectHelper.isNotEmpty((Object)host)) {
            swagger.setHost(host);
        }
        if (ObjectHelper.isNotEmpty((Object)(forwardedPrefix = (String)headers.get(HEADER_X_FORWARDED_PREFIX)))) {
            swagger.setBasePath(URISupport.joinPaths((String[])new String[]{forwardedPrefix, swagger.getBasePath()}));
        }
        if (ObjectHelper.isNotEmpty((Object)(forwardedHost = (String)headers.get(HEADER_X_FORWARDED_HOST)))) {
            swagger.setHost(forwardedHost);
        }
        if (ObjectHelper.isNotEmpty((Object)(proto = (String)headers.get(HEADER_X_FORWARDED_PROTO)))) {
            String[] schemes;
            for (String scheme : schemes = proto.split(",")) {
                String trimmedScheme = scheme.trim();
                if (!ObjectHelper.isNotEmpty((Object)trimmedScheme)) continue;
                swagger.addScheme(Scheme.forValue((String)trimmedScheme));
            }
        }
    }
}

