/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.generator.swagger;

import io.swagger.models.Operation;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.camel.generator.swagger.DestinationGenerator;

public final class DirectToOperationId
implements DestinationGenerator {
    private final AtomicInteger directRouteCount = new AtomicInteger(0);

    @Override
    public String generateDestinationFor(Operation operation) {
        return "direct:" + Optional.ofNullable(operation.getOperationId()).orElseGet(this::generateDirectName);
    }

    String generateDirectName() {
        return "rest" + this.directRouteCount.incrementAndGet();
    }
}

