/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.generator.swagger;

import io.swagger.models.Swagger;
import java.io.StringReader;
import java.io.StringWriter;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.camel.CamelContext;
import org.apache.camel.NamedNode;
import org.apache.camel.generator.swagger.PathVisitor;
import org.apache.camel.generator.swagger.RestDefinitionEmitter;
import org.apache.camel.generator.swagger.RestDslGenerator;
import org.apache.camel.model.ModelHelper;
import org.apache.camel.model.rest.RestsDefinition;
import org.apache.camel.util.ObjectHelper;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class RestDslXmlGenerator
extends RestDslGenerator<RestDslXmlGenerator> {
    private boolean blueprint;

    RestDslXmlGenerator(Swagger swagger) {
        super(swagger);
    }

    public String generate(CamelContext context) throws Exception {
        RestDefinitionEmitter emitter = new RestDefinitionEmitter(context);
        PathVisitor<RestsDefinition> restDslStatement = new PathVisitor<RestsDefinition>(this.swagger.getBasePath(), emitter, this.filter, this.destinationGenerator());
        this.swagger.getPaths().forEach(restDslStatement::visit);
        RestsDefinition rests = emitter.result();
        String xml = ModelHelper.dumpModelAsXml((CamelContext)context, (NamedNode)rests);
        DocumentBuilderFactory builderFactory = DocumentBuilderFactory.newInstance();
        builderFactory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
        builderFactory.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
        builderFactory.setNamespaceAware(true);
        DocumentBuilder builder = builderFactory.newDocumentBuilder();
        Document document = builder.parse(new InputSource(new StringReader(xml)));
        Element root = document.getDocumentElement();
        if (this.blueprint) {
            document.renameNode(root, "http://camel.apache.org/schema/blueprint", root.getTagName());
        }
        NodeList elements = document.getElementsByTagName("*");
        for (int i = 0; i < elements.getLength(); ++i) {
            Element element = (Element)elements.item(i);
            element.removeAttribute("customId");
        }
        if (this.restComponent != null) {
            Element configuration = document.createElement("restConfiguration");
            configuration.setAttribute("component", this.restComponent);
            if (this.restContextPath != null) {
                configuration.setAttribute("contextPath", this.restContextPath);
            }
            if (ObjectHelper.isNotEmpty((Object)this.apiContextPath)) {
                configuration.setAttribute("apiContextPath", this.apiContextPath);
            }
            root.insertBefore(configuration, root.getFirstChild());
        }
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        transformerFactory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", Boolean.TRUE);
        Transformer transformer = transformerFactory.newTransformer();
        StringWriter writer = new StringWriter();
        transformer.transform(new DOMSource(document), new StreamResult(writer));
        return writer.toString();
    }

    public RestDslXmlGenerator withBlueprint() {
        this.blueprint = true;
        return this;
    }
}

