/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.dataformat.tarfile;

import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.camel.Exchange;
import org.apache.camel.dataformat.tarfile.TarIterator;
import org.apache.camel.spi.DataFormat;
import org.apache.camel.spi.DataFormatName;
import org.apache.camel.support.ServiceSupport;
import org.apache.camel.util.IOHelper;
import org.apache.camel.util.StringHelper;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.ArchiveStreamFactory;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveInputStream;
import org.apache.commons.compress.archivers.tar.TarArchiveOutputStream;

public class TarFileDataFormat
extends ServiceSupport
implements DataFormat,
DataFormatName {
    private boolean usingIterator;

    public String getDataFormatName() {
        return "tarfile";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void marshal(Exchange exchange, Object graph, OutputStream stream) throws Exception {
        String filename = (String)exchange.getIn().getHeader("CamelFileName", String.class);
        Long filelength = (Long)exchange.getIn().getHeader("CamelFileLength", Long.class);
        filename = filename != null ? new File(filename).getName() : StringHelper.sanitize((String)exchange.getIn().getMessageId());
        TarArchiveOutputStream tos = new TarArchiveOutputStream(stream);
        tos.setLongFileMode(3);
        tos.setBigNumberMode(2);
        InputStream is = (InputStream)exchange.getContext().getTypeConverter().mandatoryConvertTo(InputStream.class, graph);
        if (filelength == null) {
            filelength = is.available();
        }
        TarArchiveEntry entry = new TarArchiveEntry(filename);
        entry.setSize(filelength.longValue());
        tos.putArchiveEntry((ArchiveEntry)entry);
        try {
            IOHelper.copy((InputStream)is, (OutputStream)tos);
        }
        catch (Throwable throwable) {
            tos.closeArchiveEntry();
            IOHelper.close((Closeable[])new Closeable[]{is, tos});
            throw throwable;
        }
        tos.closeArchiveEntry();
        IOHelper.close((Closeable[])new Closeable[]{is, tos});
        String newFilename = filename + ".tar";
        exchange.getOut().setHeader("CamelFileName", (Object)newFilename);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object unmarshal(Exchange exchange, InputStream stream) throws Exception {
        byte[] byArray;
        if (this.usingIterator) {
            return new TarIterator(exchange, stream);
        }
        InputStream is = (InputStream)exchange.getIn().getMandatoryBody(InputStream.class);
        TarArchiveInputStream tis = (TarArchiveInputStream)new ArchiveStreamFactory().createArchiveInputStream("tar", (InputStream)new BufferedInputStream(is));
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            TarArchiveEntry entry = tis.getNextTarEntry();
            if (entry != null) {
                exchange.getOut().setHeader("CamelFileName", (Object)entry.getName());
                IOHelper.copy((InputStream)tis, (OutputStream)baos);
            }
            if ((entry = tis.getNextTarEntry()) != null) {
                throw new IllegalStateException("Tar file has more than 1 entry.");
            }
            byArray = baos.toByteArray();
        }
        catch (Throwable throwable) {
            IOHelper.close((Closeable[])new Closeable[]{tis, baos});
            throw throwable;
        }
        IOHelper.close((Closeable[])new Closeable[]{tis, baos});
        return byArray;
    }

    public boolean isUsingIterator() {
        return this.usingIterator;
    }

    public void setUsingIterator(boolean usingIterator) {
        this.usingIterator = usingIterator;
    }

    protected void doStart() throws Exception {
    }

    protected void doStop() throws Exception {
    }
}

