/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor.aggregate.tarfile;

import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.camel.Exchange;
import org.apache.camel.component.file.FileConsumer;
import org.apache.camel.component.file.GenericFile;
import org.apache.camel.component.file.GenericFileMessage;
import org.apache.camel.component.file.GenericFileOperationFailedException;
import org.apache.camel.processor.aggregate.AggregationStrategy;
import org.apache.camel.spi.Synchronization;
import org.apache.camel.util.FileUtil;
import org.apache.camel.util.IOHelper;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.ArchiveException;
import org.apache.commons.compress.archivers.ArchiveStreamFactory;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveInputStream;
import org.apache.commons.compress.archivers.tar.TarArchiveOutputStream;
import org.apache.commons.compress.utils.IOUtils;

public class TarAggregationStrategy
implements AggregationStrategy {
    private String filePrefix;
    private String fileSuffix = ".tar";
    private boolean preserveFolderStructure;
    private boolean useFilenameHeader;

    public TarAggregationStrategy() {
        this(false, false);
    }

    public TarAggregationStrategy(boolean preserveFolderStructure) {
        this(preserveFolderStructure, false);
    }

    public TarAggregationStrategy(boolean preserveFolderStructure, boolean useFilenameHeader) {
        this.preserveFolderStructure = preserveFolderStructure;
        this.useFilenameHeader = useFilenameHeader;
    }

    public String getFilePrefix() {
        return this.filePrefix;
    }

    public void setFilePrefix(String filePrefix) {
        this.filePrefix = filePrefix;
    }

    public String getFileSuffix() {
        return this.fileSuffix;
    }

    public void setFileSuffix(String fileSuffix) {
        this.fileSuffix = fileSuffix;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Exchange aggregate(Exchange oldExchange, Exchange newExchange) {
        File tarFile;
        Exchange answer = oldExchange;
        if (newExchange == null) {
            return oldExchange;
        }
        if (oldExchange == null) {
            try {
                tarFile = FileUtil.createTempFile((String)this.filePrefix, (String)this.fileSuffix, (File)new File(System.getProperty("java.io.tmpdir")));
            }
            catch (IOException e) {
                throw new GenericFileOperationFailedException(e.getMessage(), (Throwable)e);
            }
            answer = newExchange;
            answer.addOnCompletion((Synchronization)new DeleteTarFileOnCompletion(tarFile));
        } else {
            tarFile = (File)oldExchange.getIn().getBody(File.class);
        }
        if (GenericFileMessage.class.isAssignableFrom(newExchange.getIn().getClass())) {
            try {
                File appendFile = (File)newExchange.getIn().getMandatoryBody(File.class);
                if (appendFile == null) return answer;
                TarAggregationStrategy.addFileToTar(tarFile, appendFile, this.preserveFolderStructure ? newExchange.getIn().toString() : null);
                GenericFile genericFile = FileConsumer.asGenericFile((String)tarFile.getParent(), (File)tarFile, null);
                genericFile.bindToExchange(answer);
                return answer;
            }
            catch (Exception e) {
                throw new GenericFileOperationFailedException(e.getMessage(), (Throwable)e);
            }
        }
        try {
            byte[] buffer = (byte[])newExchange.getIn().getMandatoryBody(byte[].class);
            String entryName = this.useFilenameHeader ? (String)newExchange.getIn().getHeader("CamelFileName", String.class) : newExchange.getIn().getMessageId();
            TarAggregationStrategy.addEntryToTar(tarFile, entryName, buffer, buffer.length);
            GenericFile genericFile = FileConsumer.asGenericFile((String)tarFile.getParent(), (File)tarFile, null);
            genericFile.bindToExchange(answer);
            return answer;
        }
        catch (Exception e) {
            throw new GenericFileOperationFailedException(e.getMessage(), (Throwable)e);
        }
    }

    private static void addFileToTar(File source, File file, String fileName) throws IOException, ArchiveException {
        ArchiveEntry nextEntry;
        File tmpTar = File.createTempFile(source.getName(), null);
        tmpTar.delete();
        if (!source.renameTo(tmpTar)) {
            throw new IOException("Could not make temp file (" + source.getName() + ")");
        }
        TarArchiveInputStream tin = (TarArchiveInputStream)new ArchiveStreamFactory().createArchiveInputStream("tar", (InputStream)new FileInputStream(tmpTar));
        TarArchiveOutputStream tos = new TarArchiveOutputStream((OutputStream)new FileOutputStream(source));
        tos.setLongFileMode(3);
        tos.setBigNumberMode(2);
        FileInputStream in = new FileInputStream(file);
        while ((nextEntry = tin.getNextEntry()) != null) {
            tos.putArchiveEntry(nextEntry);
            IOUtils.copy((InputStream)tin, (OutputStream)tos);
            tos.closeArchiveEntry();
        }
        TarArchiveEntry entry = new TarArchiveEntry(fileName == null ? file.getName() : fileName);
        entry.setSize(file.length());
        tos.putArchiveEntry((ArchiveEntry)entry);
        IOUtils.copy((InputStream)in, (OutputStream)tos);
        tos.closeArchiveEntry();
        IOHelper.close((Closeable)in);
        IOHelper.close((Closeable)tin);
        IOHelper.close((Closeable)tos);
    }

    private static void addEntryToTar(File source, String entryName, byte[] buffer, int length) throws IOException, ArchiveException {
        ArchiveEntry nextEntry;
        File tmpTar = File.createTempFile(source.getName(), null);
        tmpTar.delete();
        if (!source.renameTo(tmpTar)) {
            throw new IOException("Cannot create temp file: " + source.getName());
        }
        TarArchiveInputStream tin = (TarArchiveInputStream)new ArchiveStreamFactory().createArchiveInputStream("tar", (InputStream)new FileInputStream(tmpTar));
        TarArchiveOutputStream tos = new TarArchiveOutputStream((OutputStream)new FileOutputStream(source));
        tos.setLongFileMode(3);
        tos.setBigNumberMode(2);
        while ((nextEntry = tin.getNextEntry()) != null) {
            tos.putArchiveEntry(nextEntry);
            IOUtils.copy((InputStream)tin, (OutputStream)tos);
            tos.closeArchiveEntry();
        }
        TarArchiveEntry entry = new TarArchiveEntry(entryName);
        entry.setSize((long)length);
        tos.putArchiveEntry((ArchiveEntry)entry);
        tos.write(buffer, 0, length);
        tos.closeArchiveEntry();
        IOHelper.close((Closeable)tin);
        IOHelper.close((Closeable)tos);
    }

    private class DeleteTarFileOnCompletion
    implements Synchronization {
        private final File fileToDelete;

        public DeleteTarFileOnCompletion(File fileToDelete) {
            this.fileToDelete = fileToDelete;
        }

        public void onFailure(Exchange exchange) {
        }

        public void onComplete(Exchange exchange) {
            FileUtil.deleteFile((File)this.fileToDelete);
        }
    }
}

