/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor.aggregate.tarfile;

import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.camel.Exchange;
import org.apache.camel.component.file.FileConsumer;
import org.apache.camel.component.file.GenericFile;
import org.apache.camel.component.file.GenericFileMessage;
import org.apache.camel.component.file.GenericFileOperationFailedException;
import org.apache.camel.processor.aggregate.AggregationStrategy;
import org.apache.camel.spi.Synchronization;
import org.apache.camel.util.FileUtil;
import org.apache.camel.util.IOHelper;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.ArchiveException;
import org.apache.commons.compress.archivers.ArchiveStreamFactory;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveInputStream;
import org.apache.commons.compress.archivers.tar.TarArchiveOutputStream;
import org.apache.commons.compress.utils.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TarAggregationStrategy
implements AggregationStrategy {
    private static final Logger LOG = LoggerFactory.getLogger(TarAggregationStrategy.class);
    private String filePrefix;
    private String fileSuffix = ".tar";
    private boolean preserveFolderStructure;
    private boolean useFilenameHeader;
    private File parentDir = new File(System.getProperty("java.io.tmpdir"));

    public TarAggregationStrategy() {
        this(false, false);
    }

    public TarAggregationStrategy(boolean preserveFolderStructure) {
        this(preserveFolderStructure, false);
    }

    public TarAggregationStrategy(boolean preserveFolderStructure, boolean useFilenameHeader) {
        this.preserveFolderStructure = preserveFolderStructure;
        this.useFilenameHeader = useFilenameHeader;
    }

    public String getFilePrefix() {
        return this.filePrefix;
    }

    public void setFilePrefix(String filePrefix) {
        this.filePrefix = filePrefix;
    }

    public String getFileSuffix() {
        return this.fileSuffix;
    }

    public void setFileSuffix(String fileSuffix) {
        this.fileSuffix = fileSuffix;
    }

    public File getParentDir() {
        return this.parentDir;
    }

    public void setParentDir(File parentDir) {
        this.parentDir = parentDir;
    }

    public void setParentDir(String parentDir) {
        this.parentDir = new File(parentDir);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Exchange aggregate(Exchange oldExchange, Exchange newExchange) {
        File tarFile;
        Exchange answer = oldExchange;
        if (newExchange == null) {
            return oldExchange;
        }
        if (oldExchange == null) {
            try {
                tarFile = FileUtil.createTempFile((String)this.filePrefix, (String)this.fileSuffix, (File)this.parentDir);
                LOG.trace("Created temporary file: {}", (Object)tarFile);
            }
            catch (IOException e) {
                throw new GenericFileOperationFailedException(e.getMessage(), (Throwable)e);
            }
            answer = newExchange;
            answer.addOnCompletion((Synchronization)new DeleteTarFileOnCompletion(tarFile));
        } else {
            tarFile = (File)oldExchange.getIn().getBody(File.class);
        }
        if (GenericFileMessage.class.isAssignableFrom(newExchange.getIn().getClass())) {
            try {
                File appendFile = (File)newExchange.getIn().getMandatoryBody(File.class);
                if (appendFile == null) return answer;
                this.addFileToTar(tarFile, appendFile, this.preserveFolderStructure ? newExchange.getIn().toString() : null);
                GenericFile genericFile = FileConsumer.asGenericFile((String)tarFile.getParent(), (File)tarFile, null, (boolean)false);
                genericFile.bindToExchange(answer);
                return answer;
            }
            catch (Exception e) {
                throw new GenericFileOperationFailedException(e.getMessage(), (Throwable)e);
            }
        }
        try {
            byte[] buffer = (byte[])newExchange.getIn().getMandatoryBody(byte[].class);
            String entryName = this.useFilenameHeader ? (String)newExchange.getIn().getHeader("CamelFileName", String.class) : newExchange.getIn().getMessageId();
            this.addEntryToTar(tarFile, entryName, buffer, buffer.length);
            GenericFile genericFile = FileConsumer.asGenericFile((String)tarFile.getParent(), (File)tarFile, null, (boolean)false);
            genericFile.bindToExchange(answer);
            return answer;
        }
        catch (Exception e) {
            throw new GenericFileOperationFailedException(e.getMessage(), (Throwable)e);
        }
    }

    private void addFileToTar(File source, File file, String fileName) throws IOException, ArchiveException {
        ArchiveEntry nextEntry;
        File tmpTar = File.createTempFile(source.getName(), null, this.parentDir);
        tmpTar.delete();
        if (!source.renameTo(tmpTar)) {
            throw new IOException("Could not make temp file (" + source.getName() + ")");
        }
        FileInputStream fis = new FileInputStream(tmpTar);
        TarArchiveInputStream tin = (TarArchiveInputStream)new ArchiveStreamFactory().createArchiveInputStream("tar", (InputStream)fis);
        TarArchiveOutputStream tos = new TarArchiveOutputStream((OutputStream)new FileOutputStream(source));
        tos.setLongFileMode(3);
        tos.setBigNumberMode(2);
        FileInputStream in = new FileInputStream(file);
        while ((nextEntry = tin.getNextEntry()) != null) {
            tos.putArchiveEntry(nextEntry);
            IOUtils.copy((InputStream)tin, (OutputStream)tos);
            tos.closeArchiveEntry();
        }
        TarArchiveEntry entry = new TarArchiveEntry(fileName == null ? file.getName() : fileName);
        entry.setSize(file.length());
        tos.putArchiveEntry((ArchiveEntry)entry);
        IOUtils.copy((InputStream)in, (OutputStream)tos);
        tos.closeArchiveEntry();
        IOHelper.close((Closeable[])new Closeable[]{fis, in, tin, tos});
        LOG.trace("Deleting temporary file: {}", (Object)tmpTar);
        FileUtil.deleteFile((File)tmpTar);
    }

    private void addEntryToTar(File source, String entryName, byte[] buffer, int length) throws IOException, ArchiveException {
        ArchiveEntry nextEntry;
        File tmpTar = File.createTempFile(source.getName(), null, this.parentDir);
        tmpTar.delete();
        if (!source.renameTo(tmpTar)) {
            throw new IOException("Cannot create temp file: " + source.getName());
        }
        FileInputStream fis = new FileInputStream(tmpTar);
        TarArchiveInputStream tin = (TarArchiveInputStream)new ArchiveStreamFactory().createArchiveInputStream("tar", (InputStream)fis);
        TarArchiveOutputStream tos = new TarArchiveOutputStream((OutputStream)new FileOutputStream(source));
        tos.setLongFileMode(3);
        tos.setBigNumberMode(2);
        while ((nextEntry = tin.getNextEntry()) != null) {
            tos.putArchiveEntry(nextEntry);
            IOUtils.copy((InputStream)tin, (OutputStream)tos);
            tos.closeArchiveEntry();
        }
        TarArchiveEntry entry = new TarArchiveEntry(entryName);
        entry.setSize((long)length);
        tos.putArchiveEntry((ArchiveEntry)entry);
        tos.write(buffer, 0, length);
        tos.closeArchiveEntry();
        IOHelper.close((Closeable[])new Closeable[]{fis, tin, tos});
        LOG.trace("Deleting temporary file: {}", (Object)tmpTar);
        FileUtil.deleteFile((File)tmpTar);
    }

    private class DeleteTarFileOnCompletion
    implements Synchronization {
        private final File fileToDelete;

        public DeleteTarFileOnCompletion(File fileToDelete) {
            this.fileToDelete = fileToDelete;
        }

        public void onFailure(Exchange exchange) {
        }

        public void onComplete(Exchange exchange) {
            LOG.debug("Deleting tar file on completion: {} ", (Object)this.fileToDelete);
            FileUtil.deleteFile((File)this.fileToDelete);
        }
    }
}

