/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.telegram.model;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.Serializable;
import java.util.Objects;
import org.apache.camel.component.telegram.model.CallbackGame;
import org.apache.camel.component.telegram.model.LoginUrl;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public class InlineKeyboardButton
implements Serializable {
    private static final long serialVersionUID = -5386858930543292655L;
    private String text;
    private String url;
    @JsonProperty(value="login_url")
    private LoginUrl loginUrl;
    @JsonProperty(value="callback_data")
    private String callbackData;
    @JsonProperty(value="callback_game")
    private CallbackGame callbackGame;

    public InlineKeyboardButton() {
    }

    public InlineKeyboardButton(String text, String url, LoginUrl loginUrl, String callbackData, CallbackGame callbackGame) {
        this.text = text;
        this.url = url;
        this.callbackData = callbackData;
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public LoginUrl getLoginUrl() {
        return this.loginUrl;
    }

    public void setLoginUrl(LoginUrl loginUrl) {
        this.loginUrl = loginUrl;
    }

    public String getCallbackData() {
        return this.callbackData;
    }

    public void setCallbackData(String callbackData) {
        this.callbackData = callbackData;
    }

    public CallbackGame getCallbackGame() {
        return this.callbackGame;
    }

    public void setCallbackGame(CallbackGame callbackGame) {
        this.callbackGame = callbackGame;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("InlineKeyboardButton{");
        sb.append("text='").append(this.text).append('\'');
        sb.append(", url='").append(this.url).append('\'');
        sb.append(", loginUrl=").append(this.loginUrl);
        sb.append(", callbackData='").append(this.callbackData).append('\'');
        sb.append(", callbackGame=").append(this.callbackGame);
        sb.append('}');
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        InlineKeyboardButton that = (InlineKeyboardButton)o;
        return Objects.equals(this.text, that.text) && Objects.equals(this.url, that.url) && Objects.equals(this.loginUrl, that.loginUrl) && Objects.equals(this.callbackData, that.callbackData) && Objects.equals(this.callbackGame, that.callbackGame);
    }

    public int hashCode() {
        return Objects.hash(this.text, this.url, this.loginUrl, this.callbackData, this.callbackGame);
    }

    public static class Builder {
        private String text;
        private String url;
        private String callbackData;
        private LoginUrl loginUrl;
        private CallbackGame callbackGame;

        public Builder text(String text) {
            this.text = text;
            return this;
        }

        public Builder url(String url) {
            this.url = url;
            return this;
        }

        public Builder callbackData(String callbackData) {
            this.callbackData = callbackData;
            return this;
        }

        public Builder callbackGame(CallbackGame callbackGame) {
            this.callbackGame = callbackGame;
            return this;
        }

        public Builder loginUrl(LoginUrl loginUrl) {
            this.loginUrl = loginUrl;
            return this;
        }

        public InlineKeyboardButton build() {
            return new InlineKeyboardButton(this.text, this.url, this.loginUrl, this.callbackData, this.callbackGame);
        }
    }
}

