/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.telegram.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.camel.component.telegram.model.InlineKeyboardMarkup;
import org.apache.camel.component.telegram.model.InlineQueryResult;
import org.apache.camel.component.telegram.model.InputMessageContent;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class InlineQueryResultVideo
extends InlineQueryResult {
    private static final String TYPE = "video";
    @JsonProperty(value="video_url")
    private String videoUrl;
    @JsonProperty(value="video_width")
    private String videoWidth;
    @JsonProperty(value="video_height")
    private Integer videoHeight;
    @JsonProperty(value="video_duration")
    private Integer duration;
    @JsonProperty(value="mime_type")
    private String mimeType;
    @JsonProperty(value="thumb_url")
    private String thumbUrl;
    private String title;
    private String caption;
    private String description;
    @JsonProperty(value="parse_mode")
    private String parseMode;
    @JsonProperty(value="input_message_content")
    private InputMessageContent inputMessageContext;

    public InlineQueryResultVideo() {
        super(TYPE);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getViedoUrl() {
        return this.videoUrl;
    }

    public String getVideoWidth() {
        return this.videoWidth;
    }

    public Integer getVideoHeight() {
        return this.videoHeight;
    }

    public Integer getDuration() {
        return this.duration;
    }

    public String getMimeType() {
        return this.mimeType;
    }

    public String getThumbUrl() {
        return this.thumbUrl;
    }

    public String getTitle() {
        return this.title;
    }

    public String getCaption() {
        return this.caption;
    }

    public String getDescription() {
        return this.description;
    }

    public String getParseMode() {
        return this.parseMode;
    }

    public InputMessageContent getInputMessageContext() {
        return this.inputMessageContext;
    }

    public void setVideoUrl(String videoUrl) {
        this.videoUrl = videoUrl;
    }

    public void setVideoWidth(String videoWidth) {
        this.videoWidth = videoWidth;
    }

    public void setVideoHeight(Integer videoHeight) {
        this.videoHeight = videoHeight;
    }

    public void setDuration(Integer duration) {
        this.duration = duration;
    }

    public void setMimeType(String mimeType) {
        this.mimeType = mimeType;
    }

    public void setThumbUrl(String thumbUrl) {
        this.thumbUrl = thumbUrl;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public void setCaption(String caption) {
        this.caption = caption;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setParseMode(String parseMode) {
        this.parseMode = parseMode;
    }

    public void setInputMessageContext(InputMessageContent inputMessageContext) {
        this.inputMessageContext = inputMessageContext;
    }

    public static final class Builder {
        private String id;
        private InlineKeyboardMarkup replyMarkup;
        private String videoUrl;
        private String videoWidth;
        private Integer videoHeight;
        private Integer duration;
        private String mimeType;
        private String thumbUrl;
        private String title;
        private String caption;
        private String description;
        private String parseMode;
        private InputMessageContent inputMessageContext;

        private Builder() {
        }

        public Builder id(String id) {
            this.id = id;
            return this;
        }

        public Builder replyMarkup(InlineKeyboardMarkup replyMarkup) {
            this.replyMarkup = replyMarkup;
            return this;
        }

        public Builder videoUrl(String videoUrl) {
            this.videoUrl = videoUrl;
            return this;
        }

        public Builder videoWidth(String videoWidth) {
            this.videoWidth = videoWidth;
            return this;
        }

        public Builder videoHeight(Integer videoHeight) {
            this.videoHeight = videoHeight;
            return this;
        }

        public Builder duration(Integer duration) {
            this.duration = duration;
            return this;
        }

        public Builder mimeType(String mimeType) {
            this.mimeType = mimeType;
            return this;
        }

        public Builder thumbUrl(String thumbUrl) {
            this.thumbUrl = thumbUrl;
            return this;
        }

        public Builder title(String title) {
            this.title = title;
            return this;
        }

        public Builder caption(String caption) {
            this.caption = caption;
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            return this;
        }

        public Builder parseMode(String parseMode) {
            this.parseMode = parseMode;
            return this;
        }

        public Builder inputMessageContext(InputMessageContent inputMessageContext) {
            this.inputMessageContext = inputMessageContext;
            return this;
        }

        public InlineQueryResultVideo build() {
            InlineQueryResultVideo inlineQueryResultVideo = new InlineQueryResultVideo();
            inlineQueryResultVideo.setType(InlineQueryResultVideo.TYPE);
            inlineQueryResultVideo.setId(this.id);
            inlineQueryResultVideo.setReplyMarkup(this.replyMarkup);
            inlineQueryResultVideo.mimeType = this.mimeType;
            inlineQueryResultVideo.videoWidth = this.videoWidth;
            inlineQueryResultVideo.caption = this.caption;
            inlineQueryResultVideo.videoHeight = this.videoHeight;
            inlineQueryResultVideo.duration = this.duration;
            inlineQueryResultVideo.inputMessageContext = this.inputMessageContext;
            inlineQueryResultVideo.videoUrl = this.videoUrl;
            inlineQueryResultVideo.description = this.description;
            inlineQueryResultVideo.parseMode = this.parseMode;
            inlineQueryResultVideo.title = this.title;
            inlineQueryResultVideo.thumbUrl = this.thumbUrl;
            return inlineQueryResultVideo;
        }
    }
}

