/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.telemetry;

import java.util.HashMap;
import org.apache.camel.CamelContext;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.NamedNode;
import org.apache.camel.Route;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.Service;
import org.apache.camel.StaticService;
import org.apache.camel.api.management.ManagedAttribute;
import org.apache.camel.spi.CamelEvent;
import org.apache.camel.spi.CamelLogger;
import org.apache.camel.spi.CamelTracingService;
import org.apache.camel.spi.EventNotifier;
import org.apache.camel.spi.InterceptStrategy;
import org.apache.camel.spi.LogListener;
import org.apache.camel.spi.RoutePolicy;
import org.apache.camel.spi.RoutePolicyFactory;
import org.apache.camel.support.EndpointHelper;
import org.apache.camel.support.EventNotifierSupport;
import org.apache.camel.support.RoutePolicySupport;
import org.apache.camel.support.service.ServiceHelper;
import org.apache.camel.support.service.ServiceSupport;
import org.apache.camel.telemetry.Op;
import org.apache.camel.telemetry.Span;
import org.apache.camel.telemetry.SpanDecorator;
import org.apache.camel.telemetry.SpanDecoratorManager;
import org.apache.camel.telemetry.SpanDecoratorManagerImpl;
import org.apache.camel.telemetry.SpanLifecycleManager;
import org.apache.camel.telemetry.SpanStorageManager;
import org.apache.camel.telemetry.SpanStorageManagerExchange;
import org.apache.camel.telemetry.TraceProcessorsInterceptStrategy;
import org.apache.camel.util.ObjectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class Tracer
extends ServiceSupport
implements CamelTracingService,
RoutePolicyFactory,
StaticService {
    private static final Logger LOG = LoggerFactory.getLogger(Tracer.class);
    private CamelContext camelContext;
    private String excludePatterns;
    private boolean traceProcessors;
    private final TracingEventNotifier eventNotifier = new TracingEventNotifier();
    private final SpanStorageManager spanStorageManager = new SpanStorageManagerExchange();
    private final SpanDecoratorManager spanDecoratorManager = new SpanDecoratorManagerImpl();
    private SpanLifecycleManager spanLifecycleManager;

    protected abstract void initTracer();

    public CamelContext getCamelContext() {
        return this.camelContext;
    }

    public void setCamelContext(CamelContext camelContext) {
        this.camelContext = camelContext;
    }

    @ManagedAttribute
    public String getExcludePatterns() {
        return this.excludePatterns;
    }

    public void setExcludePatterns(String excludePatterns) {
        this.excludePatterns = excludePatterns;
    }

    @ManagedAttribute
    public boolean isTraceProcessors() {
        return this.traceProcessors;
    }

    public void setTraceProcessors(boolean traceProcessors) {
        this.traceProcessors = traceProcessors;
    }

    public SpanLifecycleManager getSpanLifecycleManager() {
        return this.spanLifecycleManager;
    }

    public void setSpanLifecycleManager(SpanLifecycleManager spanLifecycleManager) {
        this.spanLifecycleManager = spanLifecycleManager;
    }

    public RoutePolicy createRoutePolicy(CamelContext camelContext, String routeId, NamedNode route) {
        this.init(camelContext);
        return new TracingRoutePolicy();
    }

    public void init(CamelContext camelContext) {
        if (this.hasOtherTracerType(camelContext)) {
            LOG.warn("Could not add {} tracer type. Another tracer type, {}, was already registered. Make sure to include only one tracing dependency type.", ((Object)((Object)this)).getClass(), ((Object)((Object)((Tracer)((Object)camelContext.hasService(Tracer.class))))).getClass());
            return;
        }
        if (!camelContext.hasService((Object)this)) {
            try {
                camelContext.addService((Object)this, true, true);
            }
            catch (Exception e) {
                throw RuntimeCamelException.wrapRuntimeCamelException((Throwable)e);
            }
        }
    }

    private boolean hasOtherTracerType(CamelContext camelContext) {
        Tracer t = (Tracer)((Object)camelContext.hasService(Tracer.class));
        if (t == null) {
            return false;
        }
        return !((Object)((Object)this)).getClass().equals(((Object)((Object)t)).getClass());
    }

    protected void doInit() {
        ObjectHelper.notNull((Object)this.camelContext, (String)"CamelContext", (Object)((Object)this));
        this.camelContext.getManagementStrategy().addEventNotifier((EventNotifier)this.eventNotifier);
        if (!this.camelContext.getRoutePolicyFactories().contains((Object)this)) {
            this.camelContext.addRoutePolicyFactory((RoutePolicyFactory)this);
        }
        this.camelContext.getCamelContextExtension().addLogListener((LogListener)new TracingLogListener());
        if (this.isTraceProcessors()) {
            TraceProcessorsInterceptStrategy traceProcessorsStrategy = new TraceProcessorsInterceptStrategy(this);
            this.camelContext.getCamelContextExtension().addInterceptStrategy((InterceptStrategy)traceProcessorsStrategy);
        }
        this.initTracer();
        ServiceHelper.startService((Service)this.eventNotifier);
    }

    protected void doShutdown() {
        this.camelContext.getManagementStrategy().removeEventNotifier((EventNotifier)this.eventNotifier);
        ServiceHelper.stopService((Service)this.eventNotifier);
        this.camelContext.getRoutePolicyFactories().remove((Object)this);
    }

    public boolean exclude(String endpointUri, CamelContext context) {
        if (endpointUri != null && this.excludePatterns != null) {
            for (String pattern : this.excludePatterns.split(",")) {
                if (!EndpointHelper.matchEndpoint((CamelContext)context, (String)endpointUri, (String)(pattern = pattern.trim()))) continue;
                return true;
            }
        }
        return false;
    }

    protected void beginEventSpan(Exchange exchange, Endpoint endpoint, Op op) throws Exception {
        SpanDecorator spanDecorator = this.spanDecoratorManager.get(endpoint);
        Span parentSpan = this.spanStorageManager.peek(exchange);
        String spanName = spanDecorator.getOperationName(exchange, endpoint);
        Span span = this.spanLifecycleManager.create(spanName, parentSpan, spanDecorator.getExtractor(exchange));
        span.setTag("op", op.toString());
        spanDecorator.beforeTracingEvent(span, exchange, endpoint);
        this.spanLifecycleManager.activate(span);
        this.spanStorageManager.push(exchange, span);
        this.spanLifecycleManager.inject(span, spanDecorator.getInjector(exchange));
        LOG.debug("Started event span: {}", (Object)span);
    }

    protected void beginProcessorSpan(Exchange exchange, String processorName) throws Exception {
        SpanDecorator spanDecorator = this.spanDecoratorManager.get(processorName);
        Span parentSpan = this.spanStorageManager.peek(exchange);
        if (parentSpan == null) {
            LOG.warn("Processor tracing parent should not be null!");
        }
        Span span = this.spanLifecycleManager.create(processorName, parentSpan, spanDecorator.getExtractor(exchange));
        span.setTag("op", Op.EVENT_PROCESS.toString());
        spanDecorator.beforeTracingEvent(span, exchange, null);
        this.spanLifecycleManager.activate(span);
        this.spanStorageManager.push(exchange, span);
        LOG.debug("Started processor span: {}", (Object)span);
    }

    protected void endEventSpan(Exchange exchange, Endpoint endpoint) throws Exception {
        Span span = this.spanStorageManager.pull(exchange);
        if (span == null) {
            LOG.warn("Could not find managed span for event: {}", (Object)endpoint);
            return;
        }
        SpanDecorator spanDecorator = this.spanDecoratorManager.get(endpoint);
        spanDecorator.afterTracingEvent(span, exchange);
        this.spanLifecycleManager.deactivate(span);
        this.spanLifecycleManager.close(span);
        LOG.debug("Stopped event span: {}", (Object)span);
    }

    protected void endProcessorSpan(Exchange exchange, String processorName) throws Exception {
        Span span = this.spanStorageManager.pull(exchange);
        if (span == null) {
            LOG.warn("Could not find managed span for processor: {}", (Object)processorName);
            return;
        }
        SpanDecorator spanDecorator = this.spanDecoratorManager.get(processorName);
        spanDecorator.afterTracingEvent(span, exchange);
        this.spanLifecycleManager.deactivate(span);
        this.spanLifecycleManager.close(span);
        LOG.debug("Stopped processor span: {}", (Object)span);
    }

    private final class TracingEventNotifier
    extends EventNotifierSupport {
        public TracingEventNotifier() {
            this.setIgnoreCamelContextEvents(true);
            this.setIgnoreCamelContextInitEvents(true);
            this.setIgnoreRouteEvents(true);
        }

        public void notify(CamelEvent event) throws Exception {
            try {
                if (event instanceof CamelEvent.ExchangeSendingEvent) {
                    CamelEvent.ExchangeSendingEvent ese = (CamelEvent.ExchangeSendingEvent)event;
                    if (Tracer.this.exclude(ese.getEndpoint().getEndpointUri(), ese.getExchange().getContext())) {
                        LOG.debug("Tracing: endpoint {} is explicitly excluded, skipping.", (Object)ese.getEndpoint());
                    } else {
                        Tracer.this.beginEventSpan(ese.getExchange(), ese.getEndpoint(), Op.EVENT_SENT);
                    }
                } else if (event instanceof CamelEvent.ExchangeSentEvent) {
                    CamelEvent.ExchangeSentEvent ese = (CamelEvent.ExchangeSentEvent)event;
                    if (Tracer.this.exclude(ese.getEndpoint().getEndpointUri(), ese.getExchange().getContext())) {
                        LOG.debug("Tracing: endpoint {} is explicitly excluded, skipping.", (Object)ese.getEndpoint());
                    } else {
                        Tracer.this.endEventSpan(ese.getExchange(), ese.getEndpoint());
                    }
                }
            }
            catch (Exception t) {
                LOG.warn("Tracing: Failed to capture tracing data. This exception is ignored.", (Throwable)t);
            }
        }
    }

    private final class TracingRoutePolicy
    extends RoutePolicySupport {
        private TracingRoutePolicy() {
        }

        public void onExchangeBegin(Route route, Exchange exchange) {
            try {
                if (Tracer.this.exclude(route.getEndpoint().getEndpointUri(), exchange.getContext())) {
                    LOG.debug("Tracing: endpoint {} is explicitly excluded, skipping.", (Object)route.getEndpoint());
                } else {
                    Tracer.this.beginEventSpan(exchange, route.getEndpoint(), Op.EVENT_RECEIVED);
                }
            }
            catch (Exception t) {
                LOG.warn("Tracing: Failed to capture tracing data. This exception is ignored.", (Throwable)t);
            }
        }

        public void onExchangeDone(Route route, Exchange exchange) {
            try {
                if (Tracer.this.exclude(route.getEndpoint().getEndpointUri(), exchange.getContext())) {
                    LOG.debug("Tracing: endpoint {} is explicitly excluded, skipping.", (Object)route.getEndpoint());
                } else {
                    Tracer.this.endEventSpan(exchange, route.getEndpoint());
                }
            }
            catch (Exception t) {
                LOG.warn("Tracing: Failed to capture tracing data. This exception is ignored.", (Throwable)t);
            }
        }
    }

    private final class TracingLogListener
    implements LogListener {
        private TracingLogListener() {
        }

        public String onLog(Exchange exchange, CamelLogger camelLogger, String message) {
            try {
                Span span = Tracer.this.spanStorageManager.peek(exchange);
                if (span != null) {
                    HashMap<String, String> fields = new HashMap<String, String>();
                    fields.put("message", message);
                    span.log(fields);
                }
            }
            catch (Exception t) {
                LOG.warn("Tracing: Failed to capture tracing data. This exception is ignored.", (Throwable)t);
            }
            return message;
        }
    }
}

