/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.telemetry.decorators;

import java.net.URI;
import java.util.Map;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.telemetry.Span;
import org.apache.camel.telemetry.decorators.AbstractSpanDecorator;

public class CqlSpanDecorator
extends AbstractSpanDecorator {
    public static final String CASSANDRA_DB_TYPE = "cassandra";
    protected static final String CAMEL_CQL_QUERY = "CamelCqlQuery";

    @Override
    public String getComponent() {
        return "cql";
    }

    @Override
    public String getComponentClassName() {
        return "org.apache.camel.component.cassandra.CassandraComponent";
    }

    @Override
    public void beforeTracingEvent(Span span, Exchange exchange, Endpoint endpoint) {
        String cql;
        super.beforeTracingEvent(span, exchange, endpoint);
        span.setTag("db.system", CASSANDRA_DB_TYPE);
        URI uri = URI.create(endpoint.getEndpointUri());
        if (uri.getPath() != null && !uri.getPath().isEmpty()) {
            span.setTag("db.name", uri.getPath().substring(1));
        }
        if ((cql = (String)exchange.getIn().getHeader(CAMEL_CQL_QUERY, String.class)) != null) {
            span.setTag("db.statement", cql);
        } else {
            Map<String, String> queryParameters = CqlSpanDecorator.toQueryParameters(endpoint.getEndpointUri());
            if (queryParameters.containsKey("cql")) {
                span.setTag("db.statement", queryParameters.get("cql"));
            }
        }
    }
}

