/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.test.blueprint;

import java.util.Properties;
import org.apache.camel.CamelContext;
import org.apache.camel.component.properties.PropertiesComponent;
import org.apache.camel.model.ModelCamelContext;
import org.apache.camel.test.blueprint.CamelBlueprintHelper;
import org.apache.camel.test.junit4.CamelTestSupport;
import org.junit.After;
import org.junit.Before;
import org.osgi.framework.BundleContext;
import org.osgi.service.blueprint.container.BlueprintContainer;

public abstract class CamelBlueprintTestSupport
extends CamelTestSupport {
    private BundleContext bundleContext;

    @Before
    public void setUp() throws Exception {
        String symbolicName = ((Object)((Object)this)).getClass().getSimpleName();
        this.bundleContext = CamelBlueprintHelper.createBundleContext(symbolicName, this.getBlueprintDescriptor(), true, this.getBundleFilter(), this.getBundleVersion(), this.getBundleDirectives());
        Properties extra = this.useOverridePropertiesWithPropertiesComponent();
        if (extra != null) {
            this.bundleContext.registerService(PropertiesComponent.OVERRIDE_PROPERTIES, (Object)extra, null);
        }
        super.setUp();
        this.log.debug("Waiting for BlueprintContainer to be published with symbolicName: {}", (Object)symbolicName);
        this.getOsgiService(BlueprintContainer.class, "(osgi.blueprint.container.symbolicname=" + symbolicName + ")");
    }

    @After
    public void tearDown() throws Exception {
        super.tearDown();
        CamelBlueprintHelper.disposeBundleContext(this.bundleContext);
    }

    protected BundleContext getBundleContext() {
        return this.bundleContext;
    }

    protected String getBlueprintDescriptor() {
        return null;
    }

    protected String getBundleFilter() {
        return "(Bundle-SymbolicName=*)";
    }

    protected String getBundleVersion() {
        return "1.0.0";
    }

    protected String getBundleDirectives() {
        return null;
    }

    protected CamelContext createCamelContext() throws Exception {
        CamelContext answer = CamelBlueprintHelper.getOsgiService(this.bundleContext, CamelContext.class);
        this.context = (ModelCamelContext)answer;
        return answer;
    }

    protected <T> T getOsgiService(Class<T> type) {
        return CamelBlueprintHelper.getOsgiService(this.bundleContext, type);
    }

    protected <T> T getOsgiService(Class<T> type, long timeout) {
        return CamelBlueprintHelper.getOsgiService(this.bundleContext, type, timeout);
    }

    protected <T> T getOsgiService(Class<T> type, String filter) {
        return CamelBlueprintHelper.getOsgiService(this.bundleContext, type, filter);
    }

    protected <T> T getOsgiService(Class<T> type, String filter, long timeout) {
        return CamelBlueprintHelper.getOsgiService(this.bundleContext, type, filter, timeout);
    }
}

