/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.test.blueprint;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Arrays;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.camel.CamelContext;
import org.apache.camel.component.properties.PropertiesComponent;
import org.apache.camel.model.ModelCamelContext;
import org.apache.camel.test.blueprint.CamelBlueprintHelper;
import org.apache.camel.test.junit4.CamelTestSupport;
import org.apache.camel.util.KeyValueHolder;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Before;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.cm.Configuration;
import org.osgi.service.cm.ConfigurationAdmin;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public abstract class CamelBlueprintTestSupport
extends CamelTestSupport {
    public static final String SPROP_CAMEL_CONTEXT_CREATION_TIMEOUT = "org.apache.camel.test.blueprint.camelContextCreationTimeout";
    private static ThreadLocal<BundleContext> threadLocalBundleContext = new ThreadLocal();
    private volatile BundleContext bundleContext;
    private final Set<ServiceRegistration<?>> services = new LinkedHashSet();

    protected boolean includeTestBundle() {
        return true;
    }

    protected boolean useAsynchronousBlueprintStartup() {
        return true;
    }

    protected BundleContext createBundleContext() throws Exception {
        Properties initialConfiguration;
        String pid;
        System.setProperty("org.apache.aries.blueprint.synchronous", Boolean.toString(!this.useAsynchronousBlueprintStartup()));
        String[] file = this.loadConfigAdminConfigurationFile();
        String[][] configAdminPidFiles = new String[0][0];
        if (file != null) {
            if (file.length % 2 != 0) {
                throw new IllegalArgumentException("The length of the String[] returned from loadConfigAdminConfigurationFile must divisible by 2, was " + file.length);
            }
            configAdminPidFiles = new String[file.length / 2][2];
            int pair = 0;
            for (int i = 0; i < file.length; i += 2) {
                String fileName = file[i];
                String pid2 = file[i + 1];
                if (!new File(fileName).exists()) {
                    throw new IllegalArgumentException("The provided file \"" + fileName + "\" from loadConfigAdminConfigurationFile doesn't exist");
                }
                configAdminPidFiles[pair][0] = fileName;
                configAdminPidFiles[pair][1] = pid2;
                ++pair;
            }
        }
        if ((pid = this.setConfigAdminInitialConfiguration(initialConfiguration = new Properties())) != null) {
            configAdminPidFiles = new String[][]{{this.prepareInitialConfigFile(initialConfiguration), pid}};
        }
        String symbolicName = ((Object)((Object)this)).getClass().getSimpleName();
        BundleContext answer = CamelBlueprintHelper.createBundleContext(symbolicName, this.getBlueprintDescriptor(), this.includeTestBundle(), this.getBundleFilter(), this.getBundleVersion(), this.getBundleDirectives(), configAdminPidFiles);
        boolean expectReload = this.expectBlueprintContainerReloadOnConfigAdminUpdate();
        Properties extra = this.useOverridePropertiesWithPropertiesComponent();
        if (extra != null) {
            answer.registerService(PropertiesComponent.OVERRIDE_PROPERTIES, (Object)extra, null);
        }
        LinkedHashMap<String, KeyValueHolder<Object, Dictionary>> map = new LinkedHashMap<String, KeyValueHolder<Object, Dictionary>>();
        this.addServicesOnStartup(map);
        LinkedList<KeyValueHolder<String, KeyValueHolder<Object, Dictionary>>> servicesList = new LinkedList<KeyValueHolder<String, KeyValueHolder<Object, Dictionary>>>();
        for (Map.Entry entry : map.entrySet()) {
            servicesList.add(this.asKeyValueService((String)entry.getKey(), ((KeyValueHolder)entry.getValue()).getKey(), (Dictionary)((KeyValueHolder)entry.getValue()).getValue()));
        }
        this.addServicesOnStartup(servicesList);
        for (KeyValueHolder keyValueHolder : servicesList) {
            String clazz = (String)keyValueHolder.getKey();
            Object service = ((KeyValueHolder)keyValueHolder.getValue()).getKey();
            Dictionary dict = (Dictionary)((KeyValueHolder)keyValueHolder.getValue()).getValue();
            this.log.debug("Registering service {} -> {}", (Object)clazz, service);
            ServiceRegistration reg = answer.registerService(clazz, service, dict);
            if (reg == null) continue;
            this.services.add(reg);
        }
        HashSet<Long> bpEvents = new HashSet<Long>();
        CamelBlueprintHelper.waitForBlueprintContainer(bpEvents, answer, symbolicName, 2, null);
        Properties properties = new Properties();
        pid = this.useOverridePropertiesWithConfigAdmin(properties);
        if (pid != null) {
            ConfigurationAdmin configAdmin = CamelBlueprintHelper.getOsgiService(answer, ConfigurationAdmin.class);
            final Configuration config = configAdmin.getConfiguration(pid, null);
            if (config == null) {
                throw new IllegalArgumentException("Cannot find configuration with pid " + pid + " in OSGi ConfigurationAdmin service.");
            }
            Dictionary currentProperties = config.getProperties();
            final Properties newProps = new Properties();
            if (currentProperties == null) {
                currentProperties = newProps;
            }
            Enumeration ek = currentProperties.keys();
            while (ek.hasMoreElements()) {
                String k = (String)ek.nextElement();
                ((Dictionary)newProps).put(k, currentProperties.get(k));
            }
            for (String p : properties.stringPropertyNames()) {
                ((Dictionary)newProps).put(p, properties.getProperty(p));
            }
            this.log.info("Updating ConfigAdmin {} by overriding properties {}", (Object)config, (Object)newProps);
            if (expectReload) {
                CamelBlueprintHelper.waitForBlueprintContainer(bpEvents, answer, symbolicName, 2, new Runnable(){

                    @Override
                    public void run() {
                        try {
                            config.update(newProps);
                        }
                        catch (IOException e) {
                            throw new RuntimeException(e.getMessage(), e);
                        }
                    }
                });
            } else {
                config.update((Dictionary)newProps);
            }
        }
        return answer;
    }

    @Before
    public void setUp() throws Exception {
        System.setProperty("skipStartingCamelContext", "true");
        System.setProperty("registerBlueprintCamelContextEager", "true");
        String symbolicName = ((Object)((Object)this)).getClass().getSimpleName();
        if (this.isCreateCamelContextPerClass()) {
            boolean first;
            boolean bl = first = threadLocalBundleContext.get() == null;
            if (first) {
                threadLocalBundleContext.set(this.createBundleContext());
            }
            this.bundleContext = threadLocalBundleContext.get();
        } else {
            this.bundleContext = this.createBundleContext();
        }
        super.setUp();
        this.log.debug("Starting CamelContext: {}", (Object)this.context.getName());
        this.context.start();
    }

    protected void addServicesOnStartup(Map<String, KeyValueHolder<Object, Dictionary>> services) {
    }

    protected boolean expectBlueprintContainerReloadOnConfigAdminUpdate() {
        boolean expectedReload = false;
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setNamespaceAware(true);
        try {
            HashSet<String> cmNamesaces = new HashSet<String>(Arrays.asList("http://aries.apache.org/blueprint/xmlns/blueprint-cm/v1.1.0", "http://aries.apache.org/blueprint/xmlns/blueprint-cm/v1.2.0", "http://aries.apache.org/blueprint/xmlns/blueprint-cm/v1.3.0"));
            block11: for (URL descriptor : CamelBlueprintHelper.getBlueprintDescriptors(this.getBlueprintDescriptor())) {
                DocumentBuilder db = dbf.newDocumentBuilder();
                InputStream is = descriptor.openStream();
                Throwable throwable = null;
                try {
                    Document doc = db.parse(is);
                    NodeList nl = doc.getDocumentElement().getChildNodes();
                    for (int i = 0; i < nl.getLength(); ++i) {
                        String us;
                        Element pp;
                        Node node = nl.item(i);
                        if (!(node instanceof Element) || !cmNamesaces.contains((pp = (Element)node).getNamespaceURI()) || (us = pp.getAttribute("update-strategy")) == null || !us.equals("reload")) continue;
                        expectedReload = true;
                        continue block11;
                    }
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (is == null) continue;
                    if (throwable != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    is.close();
                }
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        return expectedReload;
    }

    protected void addServicesOnStartup(List<KeyValueHolder<String, KeyValueHolder<Object, Dictionary>>> services) {
    }

    protected KeyValueHolder<Object, Dictionary> asService(Object service, Dictionary dict) {
        return new KeyValueHolder(service, (Object)dict);
    }

    protected KeyValueHolder<String, KeyValueHolder<Object, Dictionary>> asKeyValueService(String name, Object service, Dictionary dict) {
        return new KeyValueHolder((Object)name, (Object)new KeyValueHolder(service, (Object)dict));
    }

    protected KeyValueHolder<Object, Dictionary> asService(Object service, String key, String value) {
        Properties prop = new Properties();
        if (key != null && value != null) {
            prop.put(key, value);
        }
        return new KeyValueHolder(service, (Object)prop);
    }

    protected String useOverridePropertiesWithConfigAdmin(Dictionary<String, String> props) throws Exception {
        return null;
    }

    protected String[] loadConfigAdminConfigurationFile() {
        return null;
    }

    protected String setConfigAdminInitialConfiguration(Properties props) {
        return null;
    }

    @After
    public void tearDown() throws Exception {
        System.clearProperty("skipStartingCamelContext");
        System.clearProperty("registerBlueprintCamelContextEager");
        super.tearDown();
        if (this.isCreateCamelContextPerClass()) {
            return;
        }
        if (this.bundleContext != null) {
            for (ServiceRegistration<?> reg : this.services) {
                this.bundleContext.ungetService(reg.getReference());
            }
        }
        CamelBlueprintHelper.disposeBundleContext(this.bundleContext);
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        if (threadLocalBundleContext.get() != null) {
            CamelBlueprintHelper.disposeBundleContext(threadLocalBundleContext.get());
            threadLocalBundleContext.remove();
        }
        CamelTestSupport.tearDownAfterClass();
    }

    protected BundleContext getBundleContext() {
        return this.bundleContext;
    }

    protected String getBlueprintDescriptor() {
        return null;
    }

    protected String getBundleFilter() {
        return "(Bundle-SymbolicName=*)";
    }

    protected String getBundleVersion() {
        return "1.0.0";
    }

    protected String getBundleDirectives() {
        return null;
    }

    protected Long getCamelContextCreationTimeout() {
        String tm = System.getProperty(SPROP_CAMEL_CONTEXT_CREATION_TIMEOUT);
        if (tm == null) {
            return null;
        }
        try {
            Long val = Long.valueOf(tm);
            if (val < 0L) {
                throw new IllegalArgumentException("Value of org.apache.camel.test.blueprint.camelContextCreationTimeout cannot be negative.");
            }
            return val;
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("Value of org.apache.camel.test.blueprint.camelContextCreationTimeout has wrong format.", e);
        }
    }

    protected CamelContext createCamelContext() throws Exception {
        CamelContext answer = null;
        Long timeout = this.getCamelContextCreationTimeout();
        if (timeout == null) {
            answer = CamelBlueprintHelper.getOsgiService(this.bundleContext, CamelContext.class);
        } else if (timeout >= 0L) {
            answer = CamelBlueprintHelper.getOsgiService(this.bundleContext, CamelContext.class, timeout);
        } else {
            throw new IllegalArgumentException("getCamelContextCreationTimeout cannot return a negative value.");
        }
        this.context = (ModelCamelContext)answer;
        return answer;
    }

    protected <T> T getOsgiService(Class<T> type) {
        return CamelBlueprintHelper.getOsgiService(this.bundleContext, type);
    }

    protected <T> T getOsgiService(Class<T> type, long timeout) {
        return CamelBlueprintHelper.getOsgiService(this.bundleContext, type, timeout);
    }

    protected <T> T getOsgiService(Class<T> type, String filter) {
        return CamelBlueprintHelper.getOsgiService(this.bundleContext, type, filter);
    }

    protected <T> T getOsgiService(Class<T> type, String filter, long timeout) {
        return CamelBlueprintHelper.getOsgiService(this.bundleContext, type, filter, timeout);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String prepareInitialConfigFile(Properties initialConfiguration) throws IOException {
        File dir = new File("target/etc");
        dir.mkdirs();
        File cfg = File.createTempFile("properties-", ".cfg", dir);
        try (FileWriter writer = new FileWriter(cfg);){
            initialConfiguration.store(writer, null);
        }
        return cfg.getAbsolutePath();
    }
}

