/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.test.blueprint;

import java.util.LinkedList;
import org.apache.camel.CamelContext;
import org.apache.camel.ProducerTemplate;
import org.apache.camel.main.MainCommandLineSupport;
import org.apache.camel.main.MainSupport;
import org.apache.camel.test.blueprint.CamelBlueprintHelper;
import org.osgi.framework.BundleContext;

public class Main
extends MainCommandLineSupport {
    protected static Main instance;
    private BundleContext bundleContext;
    private String descriptors = "OSGI-INF/blueprint/*.xml";
    private String bundleName = "MyBundle";
    private boolean includeSelfAsBundle;
    private String configAdminPid;
    private String configAdminFileName;
    private ClassLoader loader;

    public Main() {
        this.addOption((MainSupport.Option)new MainCommandLineSupport.ParameterOption("ac", "applicationContext", "Sets the classpath based OSGi Blueprint", "applicationContext"){

            protected void doProcess(String arg, String parameter, LinkedList<String> remainingArgs) {
                Main.this.setDescriptors(parameter);
            }
        });
        this.addOption((MainSupport.Option)new MainCommandLineSupport.ParameterOption("fa", "fileApplicationContext", "Sets the filesystem based OSGi Blueprint", "fileApplicationContext"){

            protected void doProcess(String arg, String parameter, LinkedList<String> remainingArgs) {
                Main.this.setDescriptors(parameter);
            }
        });
        this.addOption((MainSupport.Option)new MainCommandLineSupport.ParameterOption("pid", "configAdminPid", "Sets the ConfigAdmin persistentId", "configAdminPid"){

            protected void doProcess(String arg, String parameter, LinkedList<String> remainingArgs) {
                Main.this.setConfigAdminPid(parameter);
            }
        });
        this.addOption((MainSupport.Option)new MainCommandLineSupport.ParameterOption("pf", "configAdminFileName", "Sets the ConfigAdmin persistent file name", "configAdminFileName"){

            protected void doProcess(String arg, String parameter, LinkedList<String> remainingArgs) {
                Main.this.setConfigAdminFileName(parameter);
            }
        });
    }

    public static void main(String ... args) throws Exception {
        Main main = new Main();
        main.run(args);
    }

    public static Main getInstance() {
        return instance;
    }

    protected CamelContext createCamelContext() {
        return CamelBlueprintHelper.getOsgiService(this.bundleContext, CamelContext.class);
    }

    protected void doStart() throws Exception {
        if (this.bundleContext == null) {
            String descriptors = this.getDescriptors();
            if (descriptors == null) {
                throw new IllegalArgumentException("Descriptors must be provided, with the name of the blueprint XML file");
            }
            LOG.debug("Starting Blueprint XML file: " + descriptors);
            this.bundleContext = this.configAdminPid != null && this.configAdminFileName != null ? this.createBundleContext(this.bundleName, new String[][]{{this.configAdminFileName, this.configAdminPid}}) : this.createBundleContext(this.bundleName, new String[0][]);
        }
        try {
            super.doStart();
            this.initCamelContext();
        }
        finally {
            if (this.getCamelContext() != null && this.getCamelContext().isVetoStarted()) {
                this.completed();
            }
        }
    }

    protected void doStop() throws Exception {
        if (this.getCamelContext() != null) {
            this.getCamelContext().stop();
        }
        LOG.debug("Stopping Blueprint XML file: {}", (Object)this.descriptors);
        CamelBlueprintHelper.disposeBundleContext(this.bundleContext);
        this.completed();
    }

    protected ProducerTemplate findOrCreateCamelTemplate() {
        if (this.getCamelContext() != null) {
            return this.getCamelContext().createProducerTemplate();
        }
        return null;
    }

    protected BundleContext createBundleContext() throws Exception {
        return this.createBundleContext(((Object)((Object)this)).getClass().getSimpleName(), new String[0][]);
    }

    protected BundleContext createBundleContext(String name, String[] ... configAdminPidFiles) throws Exception {
        return this.createBundleContext(name, this.loader, configAdminPidFiles);
    }

    protected BundleContext createBundleContext(String name, ClassLoader loader, String[] ... configAdminPidFiles) throws Exception {
        return CamelBlueprintHelper.createBundleContext(name, this.descriptors, this.isIncludeSelfAsBundle(), "(Bundle-SymbolicName=*)", "1.0.0", null, loader, configAdminPidFiles);
    }

    public String getDescriptors() {
        return this.descriptors;
    }

    public void setDescriptors(String descriptors) {
        this.descriptors = descriptors;
    }

    public String getBundleName() {
        return this.bundleName;
    }

    public void setBundleName(String bundleName) {
        this.bundleName = bundleName;
    }

    public boolean isIncludeSelfAsBundle() {
        return this.includeSelfAsBundle;
    }

    public void setIncludeSelfAsBundle(boolean includeSelfAsBundle) {
        this.includeSelfAsBundle = includeSelfAsBundle;
    }

    public String getConfigAdminPid() {
        return this.configAdminPid;
    }

    public void setConfigAdminPid(String pid) {
        this.configAdminPid = pid;
    }

    public String getConfigAdminFileName() {
        return this.configAdminFileName;
    }

    public void setConfigAdminFileName(String fileName) {
        this.configAdminFileName = fileName;
    }

    public void setLoader(ClassLoader loader) {
        this.loader = loader;
    }
}

