/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.test.infra.arangodb.services;

import org.apache.camel.test.infra.arangodb.services.ArangoDBLocalContainerService;
import org.apache.camel.test.infra.arangodb.services.ArangoDBRemoteService;
import org.apache.camel.test.infra.arangodb.services.ArangoDBService;
import org.apache.camel.test.infra.common.services.InfrastructureService;
import org.apache.camel.test.infra.common.services.SimpleTestServiceBuilder;
import org.apache.camel.test.infra.common.services.SingletonService;

public final class ArangoDBServiceFactory {
    private ArangoDBServiceFactory() {
    }

    public static SimpleTestServiceBuilder<ArangoDBService> builder() {
        return new SimpleTestServiceBuilder("arangodb");
    }

    public static ArangoDBService createService() {
        return (ArangoDBService)ArangoDBServiceFactory.builder().addLocalMapping(ArangoDBLocalContainerService::new).addRemoteMapping(ArangoDBRemoteService::new).build();
    }

    public static ArangoDBService createSingletonService() {
        return SingletonServiceHolder.INSTANCE;
    }

    private static class SingletonServiceHolder {
        static final ArangoDBService INSTANCE;

        private SingletonServiceHolder() {
        }

        static {
            SimpleTestServiceBuilder<ArangoDBService> instance = ArangoDBServiceFactory.builder();
            instance.addLocalMapping(() -> new SingletonArangoDBService(new ArangoDBLocalContainerService(), "arangoDB")).addRemoteMapping(ArangoDBRemoteService::new).build();
            INSTANCE = (ArangoDBService)instance.build();
        }
    }

    private static class SingletonArangoDBService
    extends SingletonService<ArangoDBService>
    implements ArangoDBService {
        public SingletonArangoDBService(ArangoDBService service, String name) {
            super((InfrastructureService)service, name);
        }

        @Override
        public int getPort() {
            return ((ArangoDBService)this.getService()).getPort();
        }

        @Override
        public String getHost() {
            return ((ArangoDBService)this.getService()).getHost();
        }

        @Override
        public int port() {
            return ((ArangoDBService)this.getService()).port();
        }

        @Override
        public String host() {
            return ((ArangoDBService)this.getService()).host();
        }
    }
}

