/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.test.infra.cassandra.services;

import org.apache.camel.spi.annotations.InfraService;
import org.apache.camel.test.infra.cassandra.services.CassandraInfraService;
import org.apache.camel.test.infra.common.LocalPropertyResolver;
import org.apache.camel.test.infra.common.services.ContainerService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testcontainers.containers.CassandraContainer;
import org.testcontainers.utility.DockerImageName;

@InfraService(service=CassandraInfraService.class, description="Apache Cassandra NoSQL Database", serviceAlias={"cassandra"})
public class CassandraLocalContainerInfraService
implements CassandraInfraService,
ContainerService<CassandraContainer> {
    private static final Logger LOG = LoggerFactory.getLogger(CassandraLocalContainerInfraService.class);
    private final CassandraContainer container;

    public CassandraLocalContainerInfraService() {
        this(LocalPropertyResolver.getProperty(CassandraLocalContainerInfraService.class, (String)"cassandra.container"));
    }

    public CassandraLocalContainerInfraService(String imageName) {
        this.container = this.initContainer(imageName);
    }

    public CassandraLocalContainerInfraService(CassandraContainer container) {
        this.container = container;
    }

    protected CassandraContainer initContainer(String imageName) {
        return new CassandraContainer(DockerImageName.parse((String)imageName).asCompatibleSubstituteFor("cassandra"));
    }

    @Override
    public int getCQL3Port() {
        return this.port();
    }

    @Override
    public String getCassandraHost() {
        return this.hosts();
    }

    @Override
    public String hosts() {
        return this.container.getHost();
    }

    @Override
    public int port() {
        return this.container.getMappedPort(CassandraContainer.CQL_PORT.intValue());
    }

    public void registerProperties() {
        System.setProperty("cassandra.host", this.getCassandraHost());
        System.setProperty("cassandra.cql3.port", String.valueOf(this.getCQL3Port()));
    }

    public void initialize() {
        this.container.start();
        this.registerProperties();
        LOG.info("Cassandra server running at address {}", (Object)this.getCQL3Endpoint());
    }

    public void shutdown() {
        LOG.info("Stopping the Cassandra container");
        this.container.stop();
    }

    public CassandraContainer getContainer() {
        return this.container;
    }
}

