/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.test.infra.common.services;

import java.util.function.BiConsumer;
import org.apache.camel.test.infra.common.services.TestService;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.extension.AfterAllCallback;
import org.junit.jupiter.api.extension.BeforeAllCallback;
import org.junit.jupiter.api.extension.ExtensionContext;

public abstract class AbstractTestService
implements TestService,
BeforeAllCallback,
AfterAllCallback {
    protected ExtensionContext context;

    @Override
    public void registerProperties() {
        ExtensionContext.Store store = this.context.getStore(ExtensionContext.Namespace.GLOBAL);
        this.registerProperties((arg_0, arg_1) -> ((ExtensionContext.Store)store).put(arg_0, arg_1));
    }

    @Override
    public void initialize() {
        try {
            this.setUp();
            this.registerProperties();
        }
        catch (Exception e) {
            Assertions.fail((String)("Unable to initialize the service " + e.getMessage()), (Throwable)e);
        }
    }

    @Override
    public void shutdown() {
        try {
            this.tearDown();
        }
        catch (Exception e) {
            Assertions.fail((String)("Unable to terminate the service " + e.getMessage()), (Throwable)e);
        }
    }

    protected void registerProperties(BiConsumer<String, String> store) {
    }

    protected void setUp() throws Exception {
    }

    protected void tearDown() throws Exception {
    }

    public void beforeAll(ExtensionContext extensionContext) throws Exception {
        this.context = extensionContext;
        this.initialize();
    }

    public void afterAll(ExtensionContext extensionContext) throws Exception {
        this.shutdown();
        this.context = null;
    }
}

