/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.test.infra.common;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;

public class LocalPropertyResolver {
    public static final String CONTAINER_PROPERTIES_FILE_NAME = "container.properties";

    public static String getProperty(Class<?> clazz, String propertyName) {
        return System.getProperty(propertyName, LocalPropertyResolver.getPropertyFromContainersPropertiesFile(clazz, propertyName));
    }

    private static String getPropertyFromContainersPropertiesFile(Class<?> clazz, String propertyName) {
        Properties properties = new Properties();
        try (InputStream inputStream = clazz.getResourceAsStream(CONTAINER_PROPERTIES_FILE_NAME);){
            properties.load(inputStream);
        }
        catch (IOException e) {
            String errorMessage = "Error when reading file container.properties for class " + clazz.getCanonicalName();
            throw new RuntimeException(errorMessage, e);
        }
        return properties.getProperty(propertyName);
    }
}

