/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.test.infra.couchbase.services;

import org.apache.camel.test.infra.common.services.InfrastructureService;
import org.apache.camel.test.infra.common.services.SimpleTestServiceBuilder;
import org.apache.camel.test.infra.common.services.SingletonService;
import org.apache.camel.test.infra.couchbase.services.CouchbaseLocalContainerInfraService;
import org.apache.camel.test.infra.couchbase.services.CouchbaseRemoteInfraService;
import org.apache.camel.test.infra.couchbase.services.CouchbaseService;

public final class CouchbaseServiceFactory {
    private CouchbaseServiceFactory() {
    }

    public static SimpleTestServiceBuilder<CouchbaseService> builder() {
        return new SimpleTestServiceBuilder("couchbase");
    }

    public static CouchbaseService createService() {
        return (CouchbaseService)CouchbaseServiceFactory.builder().addLocalMapping(CouchbaseLocalContainerTestService::new).addRemoteMapping(CouchbaseRemoteTestService::new).build();
    }

    public static CouchbaseService createSingletonService() {
        return SingletonServiceHolder.INSTANCE;
    }

    @Deprecated
    public static CouchbaseService getService() {
        return CouchbaseServiceFactory.createService();
    }

    private static class SingletonServiceHolder {
        static final CouchbaseService INSTANCE;

        private SingletonServiceHolder() {
        }

        static {
            SimpleTestServiceBuilder<CouchbaseService> instance = CouchbaseServiceFactory.builder();
            instance.addLocalMapping(() -> new SingletonCouchbaseService(new CouchbaseLocalContainerTestService(), "couchbase")).addRemoteMapping(CouchbaseRemoteTestService::new);
            INSTANCE = (CouchbaseService)instance.build();
        }
    }

    public static class CouchbaseRemoteTestService
    extends CouchbaseRemoteInfraService
    implements CouchbaseService {
    }

    public static class CouchbaseLocalContainerTestService
    extends CouchbaseLocalContainerInfraService
    implements CouchbaseService {
    }

    static class SingletonCouchbaseService
    extends SingletonService<CouchbaseService>
    implements CouchbaseService {
        public SingletonCouchbaseService(CouchbaseService service, String name) {
            super((InfrastructureService)service, name);
        }

        @Override
        public String getConnectionString() {
            return ((CouchbaseService)this.getService()).getConnectionString();
        }

        @Override
        public String getUsername() {
            return ((CouchbaseService)this.getService()).getUsername();
        }

        @Override
        public String getPassword() {
            return ((CouchbaseService)this.getService()).getPassword();
        }

        @Override
        public String getHostname() {
            return ((CouchbaseService)this.getService()).getHostname();
        }

        @Override
        public int getPort() {
            return ((CouchbaseService)this.getService()).getPort();
        }

        @Override
        public String protocol() {
            return ((CouchbaseService)this.getService()).protocol();
        }

        @Override
        public String hostname() {
            return ((CouchbaseService)this.getService()).hostname();
        }

        @Override
        public int port() {
            return ((CouchbaseService)this.getService()).port();
        }

        @Override
        public String username() {
            return ((CouchbaseService)this.getService()).username();
        }

        @Override
        public String password() {
            return ((CouchbaseService)this.getService()).password();
        }

        @Override
        public String bucket() {
            return ((CouchbaseService)this.getService()).bucket();
        }

        @Override
        public String viewName() {
            return ((CouchbaseService)this.getService()).viewName();
        }

        @Override
        public String designDocumentName() {
            return ((CouchbaseService)this.getService()).designDocumentName();
        }
    }
}

